/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.PrologStream;
import gnu.prolog.vm.TermConstants;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Predicate_stream_property
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        Term property;
        if (backtrackMode) {
            StreamPropertyBacktrackInfo bi = (StreamPropertyBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return this.nextSolution(interpreter, bi);
        }
        Term stream = args[0];
        if (!(stream instanceof VariableTerm)) {
            if (stream instanceof JavaObjectTerm) {
                JavaObjectTerm jt = (JavaObjectTerm)stream;
                if (jt.value instanceof PrologStream) {
                    PrologStream ps = (PrologStream)jt.value;
                    ps.checkExists();
                } else {
                    PrologException.domainError(TermConstants.streamAtom, stream);
                }
            } else {
                PrologException.domainError(TermConstants.streamAtom, stream);
            }
        }
        if (!((property = args[1]) instanceof VariableTerm) && property != TermConstants.inputAtom && property != TermConstants.outputAtom) {
            if (property instanceof CompoundTerm) {
                CompoundTerm ct = (CompoundTerm)property;
                if (ct.tag == PrologStream.filenameTag) {
                    if (!(ct.args[0] instanceof AtomTerm) && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else if (ct.tag == PrologStream.aliasTag) {
                    if (!(ct.args[0] instanceof AtomTerm) && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else if (ct.tag == PrologStream.endOfStreamTag) {
                    if (ct.args[0] != PrologStream.atAtom && ct.args[0] != PrologStream.pastAtom && ct.args[0] != PrologStream.notAtom && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else if (ct.tag == PrologStream.eofActionTag) {
                    if (ct.args[0] != PrologStream.errorAtom && ct.args[0] != PrologStream.eofCodeAtom && ct.args[0] != PrologStream.resetAtom && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else if (ct.tag == PrologStream.repositionTag) {
                    if (ct.args[0] != TermConstants.trueAtom && ct.args[0] != TermConstants.falseAtom && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else if (ct.tag == PrologStream.positionTag) {
                    if (ct.args[0] != TermConstants.trueAtom && ct.args[0] != TermConstants.falseAtom && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else if (ct.tag == PrologStream.typeTag) {
                    if (ct.args[0] != PrologStream.textAtom && ct.args[0] != PrologStream.binaryAtom && !(ct.args[0] instanceof VariableTerm)) {
                        PrologException.domainError(TermConstants.streamPropertyAtom, property);
                    }
                } else {
                    PrologException.domainError(TermConstants.streamPropertyAtom, property);
                }
            } else {
                PrologException.domainError(TermConstants.streamPropertyAtom, property);
            }
        }
        StreamPropertyBacktrackInfo bi = new StreamPropertyBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.stream2option = interpreter.getEnvironment().getStreamProperties();
        bi.streams = bi.stream2option.keySet().iterator();
        bi.stream = args[0];
        bi.property = args[1];
        return this.nextSolution(interpreter, bi);
    }

    private int nextSolution(Interpreter interpreter, StreamPropertyBacktrackInfo bi) throws PrologException {
        int undoPos = interpreter.getUndoPosition();
        while (true) {
            if (bi.options == null || !bi.options.hasNext()) {
                if (bi.streams.hasNext()) {
                    PrologStream stream = bi.streams.next();
                    bi.currentStream = stream.getStreamTerm();
                    bi.options = bi.stream2option.get(stream).iterator();
                    continue;
                }
                return -1;
            }
            Term currentProp = bi.options.next();
            if (interpreter.simpleUnify(bi.stream, bi.currentStream) == 1 && interpreter.simpleUnify(bi.property, currentProp) == 1) {
                interpreter.pushBacktrackInfo(bi);
                return 0;
            }
            interpreter.undo(undoPos);
        }
    }

    private static class StreamPropertyBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        Map<PrologStream, List<Term>> stream2option;
        Iterator<PrologStream> streams;
        Term currentStream;
        Iterator<Term> options;
        Term stream;
        Term property;

        StreamPropertyBacktrackInfo() {
            super(-1, -1);
        }
    }
}

