/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPPopupMenuOptionView.cp,v 1.5 1999/04/04 11:13:51 wprice Exp $
____________________________________________________________________________*/

// Public includes:
#include <LPopupButton.h>
#include <PP_Messages.h>

#include "MacStrings.h"
#include "pgpMem.h"

// Private includes:
#include "CPGPPopupMenuOptionView.h"
#include "pgpOptionListPriv.h"

const ResIDT	kPopupMenuOptionViewResourceID 	= 4801;
const PaneIDT	kPopupMenuPaneID 				= 4801;

CPGPPopupMenuOptionView::CPGPPopupMenuOptionView(LStream *inStream) :
					CPGPOptionView(inStream)
{
	mPopupMenu 	= NULL;
	mResultPtr	= NULL;
}

CPGPPopupMenuOptionView::~CPGPPopupMenuOptionView()
{
}

	void
CPGPPopupMenuOptionView::FinishCreateSelf(void)
{
	CPGPOptionView::FinishCreateSelf();
	
	mPopupMenu = (LPopupButton *) FindPaneByID( kPopupMenuPaneID );
	pgpAssertAddrValid( mPopupMenu, VoidAlign );
	
	mPopupMenu->AddListener( this );
}

	void
CPGPPopupMenuOptionView::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	switch( inMessage )
	{
		case kPopupMenuPaneID:
		{
			BroadcastMessage( msg_ChangedViewControlValue, ioParam );
			break;
		}
		
		case msg_OK:
		{
			pgpAssertAddrValid( mPopupMenu, VoidAlign );
			pgpAssertAddrValid( mResultPtr, PGPUInt32 );
			
			*mResultPtr = mPopupMenu->GetValue();
			break;
		}
		
		default:
			CPGPOptionView::ListenToMessage( inMessage, ioParam );
			break;
	}
}

	void
CPGPPopupMenuOptionView::SetInfo(const PGPOUIPopupListDesc *info)
{
	Str255		pTitle;
	MenuHandle	theMenu;
	PGPUInt32	numMenuItems;
	
	pgpAssertAddrValid( info, PGPOUIPopupListDesc );
	pgpAssertAddrValid( info->title, char );
	pgpAssertAddrValid( info->description, char );
	pgpAssert( info->numListItems > 0 );
	pgpAssertAddrValid( info->listItems, char * );
	pgpAssertAddrValid( info->valuePtr, PGPUInt32 );
	
	mItemID 	= info->itemID;
	mResultPtr 	= info->valuePtr;
	
	CToPString( info->title, pTitle );
	mPopupMenu->SetDescriptor( pTitle );

	// PP calls DisposeHandle on theMenu, not DisposeMenu
	MacLeaks_Suspend();
		theMenu = NewMenu( mPopupMenu->GetMenuID(), pTitle );
	MacLeaks_Resume();
	
	AssertHandleIsValid( theMenu, "" );

	numMenuItems = 0;
	
	// Build the popup
	for( PGPUInt32 itemIndex = 0; itemIndex < info->numListItems; itemIndex++)
	{
		if( IsntNull( info->listItems[itemIndex] ) )
		{
			++numMenuItems;
			
			CToPString( info->listItems[itemIndex], pTitle );
			AppendMenu( theMenu, "\px" );
			SetMenuItemText( theMenu, numMenuItems, pTitle );
		}
	}
	
	mPopupMenu->SetMacMenuH( theMenu );
	
	// Need to set this before calling SetValue()!

	mPopupMenu->SetMinValue( 1 );
	mPopupMenu->SetMaxValue( numMenuItems );
	mPopupMenu->SetValue( *mResultPtr );
	SetDescription( info->description );
}

	CPGPPopupMenuOptionView *
CPGPPopupMenuOptionView::CreatePopupMenuOptionView(
	LView 						*superView,
	const PGPOUIPopupListDesc	*info)
{
	CPGPPopupMenuOptionView	*popupMenuView;
	
	pgpAssertAddrValid( superView, VoidAlign );
	pgpAssertAddrValid( info, PGPOUIPopupListDesc );
	
	popupMenuView = (CPGPPopupMenuOptionView *)
						CPGPOptionView::CreateOptionView(
							superView, kPopupMenuOptionViewResourceID );
	if( IsntNull( popupMenuView ) )
	{
		popupMenuView->SetInfo( info );
	}
	
	return ( popupMenuView );
}