/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPDecrPassphraseGrafPort.cp,v 1.15 1999/03/10 02:36:48 heller Exp $
____________________________________________________________________________*/

#include <LPushButton.h>
#include <LStaticText.h>
#include <PP_Messages.h>

#include "MacStrings.h"
#include "pgpErrors.h"
#include "pgpMem.h"
#include "pgpPassphraseUtils.h"

#include "CPassphraseEdit.h"
#include "CPGPDecrPassphraseGrafPort.h"
#include "CPrivateKeysPopup.h"
#include "CPGPRecipientTable.h"
#include "PGPsdkUILibDialogs.h"
#include "PGPsdkUILibUtils.h"

CPGPDecryptionPassphraseGrafPortView::
	CPGPDecryptionPassphraseGrafPortView(LStream *inStream)
	: CPGPKeySetPassphraseGrafPortView(inStream)
{
	mOptions		= NULL;
	mRecipientTable	= NULL;
}

CPGPDecryptionPassphraseGrafPortView::~CPGPDecryptionPassphraseGrafPortView()
{
}

	void
CPGPDecryptionPassphraseGrafPortView::FinishCreateSelf()
{
	CPGPKeySetPassphraseGrafPortView::FinishCreateSelf();
	
	mRecipientTable =
		(CPGPRecipientTable *) FindPaneByID( kRecipientUserIDTablePaneID );
	pgpAssertAddrValid( mRecipientTable, VoidAlign );

	mRecipientTable->InsertCols(1, 1, NULL, 0, TRUE);
	mRecipientTable->AddListener( this );
}

	PGPError
CPGPDecryptionPassphraseGrafPortView::AddKeySetToRecipientsTable(
	PGPKeySetRef keySet)
{
	PGPError		err;
	PGPKeyListRef	keyList;
	
	err = PGPOrderKeySet( keySet, kPGPAnyOrdering, &keyList );
	if( IsntPGPError( err ) )
	{
		PGPKeyIterRef	keyIterator;
		
		err = PGPNewKeyIter( keyList, &keyIterator );
		if( IsntPGPError( err ) )
		{
			PGPKeyRef	theKey;

			err = PGPKeyIterNext( keyIterator, &theKey );
			while( IsntPGPError( err ) )
			{
				mRecipientTable->AddKey( theKey );
				
				err = PGPKeyIterNext( keyIterator, &theKey );
			}
		
			if( err == kPGPError_EndOfIteration )
				err = kPGPError_NoErr;
				
			PGPFreeKeyIter( keyIterator );
		}

		PGPFreeKeyList( keyList );
	}
	
	return( err );
}

	PGPError
CPGPDecryptionPassphraseGrafPortView::BuildRecipientsTable(void)
{
	PGPError		err;
	TableIndexT		numRows, numColumns;
	
	mRecipientTable->GetTableSize( numRows, numColumns );
	if( numRows != 0 )
		mRecipientTable->RemoveRows( numRows, 1, TRUE );
	
	if( IsntNull( mOptions->mMissingKeyIDList ) )
	{
		Str255	userID;
		
		if( mOptions->mMissingKeyIDCount == 1 )
		{
			GetIndString( userID, kPGPLibDialogsStringListResID,
				kUnknownRecipientStrIndex );
		}
		else
		{
			Str32	numStr;
			
			GetIndString( userID, kPGPLibDialogsStringListResID,
				kXUnknownRecipientsStrIndex );
			NumToString( mOptions->mMissingKeyIDCount, numStr );
			PrintPString( userID, userID, numStr );
		}
		
		PToCString( userID, (char *) userID );
		mRecipientTable->AddMissingUserID( (char *) userID );
	}
	
	err = AddKeySetToRecipientsTable( mOptions->mKeySet );
	if( IsntPGPError( err ) &&
		IsntNull( mOptions->mNewKeys ) &&
		PGPKeySetRefIsValid( *mOptions->mNewKeys ) )
	{
		err = AddKeySetToRecipientsTable( *mOptions->mNewKeys );
	}
	
	return( err );
}

	PGPError
CPGPDecryptionPassphraseGrafPortView::SetOptions(
	PGPContextRef								context,
	CPGPDecryptionPassphraseDialogOptions *options)
{
	PGPError	err = kPGPError_NoErr;
	
	err = CPGPKeySetPassphraseGrafPortView::SetOptions( context, options );
	if( IsntPGPError( err ) )
	{
		Str255		msg;
		
		mOptions = options;
		
		pgpAssert( PGPKeySetRefIsValid( mOptions->mKeySet ) );

		if( PGPKeyRefIsValid( options->mDefaultKey ) )
		{
			LStaticText	*keyCaption;
			PGPSize		len;
			
			err = PGPGetPrimaryUserIDNameBuffer( options->mDefaultKey,
				sizeof( msg ) - 1, (char *) &msg[1], &len );
			if ( IsntPGPError( err ) )
			{
				keyCaption = (LStaticText *) FindPaneByID(
							kKeyIDTextPaneID );
				pgpAssertAddrValid( keyCaption, VoidAlign );
			
				msg[0] = len;
				
				keyCaption->SetDescriptor( msg );
			}
		}
		else
		{
			Str255	msg;
			
			GetIndString( msg, kPGPLibDialogsStringListResID,
						kNoDecryptionKeysFoundStrIndex );
			SetDescriptor( msg );
			
			mPassphraseEdit->Hide();
			mOKButton->Disable();
		}

		if( IsntPGPError( err ) )
		{
			err = BuildRecipientsTable();
		}
	}
	
	return( err );
}
	
	PGPKeyRef
CPGPDecryptionPassphraseGrafPortView::FindKeyForPassphrase(
	PGPKeySetRef 	keySet,
	const char 		*passphrase)
{
	return( GetKeyForPassphrase( keySet, passphrase, FALSE ) );
}

	PGPKeyRef
CPGPDecryptionPassphraseGrafPortView::GetPassphraseKey(void)
{
	pgpAssert( PGPKeyRefIsValid( mOptions->mDefaultKey ) );
	
	return( mOptions->mDefaultKey );
}

	void
CPGPDecryptionPassphraseGrafPortView::ListenToMessage(
	MessageT 	inMessage,
	void 		*ioParam)
{
	switch( inMessage )
	{
		case kUpdateMissingRecipientsMsg:
		{
			PGPBoolean	haveNewKeys;
			
			(void) mOptions->SearchForMissingKeys( NULL, &haveNewKeys );
			if( haveNewKeys )
			{
				BuildRecipientsTable();
			}
			break;
		}
		
		default:
			CPGPKeySetPassphraseGrafPortView::ListenToMessage(
						inMessage, ioParam );
			break;
	}
}
