/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPOpenAdminPrefs.cp,v 1.4 1999/04/23 22:53:10 heller Exp $
____________________________________________________________________________*/

#include <TextUtils.h>

#include "PGPOpenPrefs.h"

#include "MacErrors.h"
#include "MacFiles.h"
#include "pgpClientPrefs.h"
#include "pgpMem.h"
#include "pgpAdminPrefs.h"
#include "pgpSDKPrefs.h"
#include "pgpFileSpec.h"
#include "CComboError.h"
#include "pgpClientErrors.h"
#include "pgpClientLib.h"

const ResID		kPrefsNameListID			=	14444;
const short		kAdminPrefsFilenameStrIndex	=	2;

/*____________________________________________________________________________
	Acts differently, depending on whether this is an administrator build
	or not.  If it's an admin build, then the admin prefs will be created
	if they don't exist.  If it's not an admin build, then they won't be
	created and a kPGPError_AdminPrefsNotFound error will be returned.
____________________________________________________________________________*/

	PGPError
PGPGetAdminPrefsFileFSSpec(FSSpec *fileSpec)
{
	CComboError		err;
	
	PGPValidatePtr( fileSpec );
	
	err.err = FindPGPPreferencesFolder( kOnSystemDisk, &fileSpec->vRefNum,
					&fileSpec->parID );
	if( err.IsntError() )
	{
		GetIndString( fileSpec->name, kPrefsNameListID,
				kAdminPrefsFilenameStrIndex);
		pgpAssert( fileSpec->name[0] != 0 );
	}
	
	return( err.ConvertToPGPError() );
}

	PGPError
PGPOpenAdminPrefs(
	PGPMemoryMgrRef	memoryMgr,
	PGPPrefRef		*prefRef)
{
#if PGP_BUSINESS_SECURITY	// [
	CComboError		err;
	FSSpec			fsSpec;
	
	PGPValidatePtr( prefRef );
	*prefRef	= NULL;
	
	err.pgpErr = PGPGetAdminPrefsFileFSSpec( &fsSpec );
	if ( err.IsntError() )
	{
		PGPBoolean	adminConfig;
		
		/* create it if it doesn't already exist */
		if ( ! FSpExists( &fsSpec ) &&
			IsntPGPError( err.pgpErr = PGPIsAdminConfigured( &adminConfig )))
		{
			if( adminConfig )
			{
				// only an administrator build is allowed to create these
				err.pgpErr	= kPGPClientError_AdminPrefsNotFound;
			}
		}
		
		if ( err.IsntError() )
		{
			PFLFileSpecRef	fsRef	= NULL;
		
			err.pgpErr	= PFLNewFileSpecFromFSSpec( memoryMgr, &fsSpec, &fsRef);
			if ( err.IsntError() )
			{
				PFLFileSpecMacMetaInfo		info;
				
				pgpClearMemory( &info, sizeof( info ) );
				
				info.fInfo.fileCreator	= kPGPMacFileCreator_Keys;
				info.fInfo.fileType		= 'pref';
				info.fInfo.location.h	= -1;
				info.fInfo.location.v	= -1;

				err.pgpErr = PFLSetFileSpecMetaInfo( fsRef, &info );
			}
		
			if ( err.IsntError() )
			{
				err.pgpErr = PGPOpenPrefFile(fsRef, adminDefaults, 
								adminDefaultsSize, prefRef);

				PFLFreeFileSpec( fsRef );
			}
		}
	}
	
	return( err.ConvertToPGPError() );
#else
	memoryMgr;
	prefRef;
	pgpAssert(0);	// This function is *only* called in non-BS builds
	return kPGPError_FeatureNotAvailable;
#endif	// ] PGP_BUSINESS_SECURITY
}


