/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPFindermenu.cp,v 1.8 1999/04/29 21:58:54 jason Exp $
____________________________________________________________________________*/

#include <AEPackObject.h>
#include <AERegistry.h>
#include <FinderRegistry.h>
#include <ToolUtils.h>

#include <LFile.h>
#include <UAppleEventsMgr.h>
#include <UExtractFromAEDesc.h>

#include "MacDesktop.h"
#include "MacMenus.h"
#include "MacProcesses.h"
#include "MacStrings.h"
#include "pflPrefTypes.h"
#include "pgpClientPrefs.h"
#include "pgpMem.h"
#include "pgpMemoryMgr.h"
#include "pgpOpenPrefs.h"
#include "WarningAlert.h"

#include "CString.h"
#include "StPGPRefs.h"
#include "StSaveCurResFile.h"
#include "StSaveHeapZone.h"
#include "StSuspendAESpecialHandler.h"

#include "CPGPFindermenu.h"



namespace {
	const ResID			STRx_Findermenu					=	17360;
	enum {				stringID_UnableToSendToolsEvent	=	1,
						stringID_Special,
						stringID_EmptyTrash,
						stringID_WipeTrash,
						stringID_WarnAndWipeTrash
	};

	const AEEventClass	kAEPGPmenuClass					=	'Menu';
	const AEEventID		kAEmenuOpenApp					=	'OApp';
	const AEEventID		kAESignID						=	'Sign';
	const AEEventID		kAEEncryptID					=	'Encr';
	const AEEventID		kAEEncryptAndSignID				=	'EnSi';
	const AEEventID		kAEDecryptVerifyID				=	'DeVe';
	const AEEventID		kAEOptionSignID					=	'OSig';
	const AEEventID		kAEOptionEncryptID				=	'OEnc';
	const AEEventID		kAEOptionEncryptAndSignID		=	'OEnS';
	const AEEventID		kAEOptionDecryptVerifyID		=	'ODeV';
	const AEEventID		kAEWipeID						=	'Wipe';
	const AEEventID		kAEWipeTrashID					=	'WTrs';
	const AEEventID		kAEOptionWipeTrashID			=	'OWTr';
}



CPGPFindermenu::CPGPFindermenu(
	FSSpec *			inFSSpec,
	SPGPmenuMESPData *	inMESPData)
		: CPGPmenu(inFSSpec), mWipeTrash(false), mWarnOnWipe(true), mSpecialMenu(0)
{
	(void) inMESPData;
}



CPGPFindermenu::~CPGPFindermenu()
{
}



	void
CPGPFindermenu::Patch()
{
	if (mPatchMenuSelect) {
		new CPGPFindermenuMenuSelectPatch;
	}
	mPatchMenuSelect = false;
	CPGPmenu::Patch();
}



	void
CPGPFindermenu::Initialize()
{
	UAppleEventsMgr::Initialize();
	
	mSpecialString.Assign(CStringFromSTRx(STRx_Findermenu, stringID_Special));
	mEmptyTrashString.Assign(CStringFromSTRx(STRx_Findermenu, stringID_EmptyTrash));
	mWipeTrashString.Assign(CStringFromSTRx(STRx_Findermenu, stringID_WipeTrash));
	mWarnAndWipeTrashString.Assign(CStringFromSTRx(STRx_Findermenu, stringID_WarnAndWipeTrash));
	
	CPGPmenu::Initialize();
}



	void
CPGPFindermenu::AdjustMenuItems()
{
	// We need to check to make sure that only files, folders or the trash are selected
	PGPBoolean					trashSelected = false;
	PGPBoolean					itemSelected = true;
	StSuspendAESpecialHandler	suspendedHandler(keyPreDispatch);
	
	try {
		StAEDescriptor	reply;
		OSErr			err;
		
		// Send the appleevent
		{
			StAEDescriptor	getSelectionEvent;
			StAEDescriptor	address;
			StAEDescriptor	nullDescriptor;
			StAEDescriptor	userSelectionProperty(static_cast<DescType>(pUserSelection));
			StAEDescriptor	userSelectionSpecifier;
			StAEDescriptor	asObjectSpecifierType(static_cast<DescType>(typeObjectSpecifier));
			
			UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getSelectionEvent);
			err = ::CreateObjSpecifier(cProperty, nullDescriptor, formPropertyID,
						userSelectionProperty, false, userSelectionSpecifier);
			PGPThrowIfOSError_(err);
			err = ::AEPutParamDesc(getSelectionEvent, keyDirectObject, userSelectionSpecifier);
			PGPThrowIfOSError_(err);
			err = ::AEPutParamDesc(getSelectionEvent, keyAERequestedType,
						asObjectSpecifierType);
			PGPThrowIfOSError_(err);
			UAppleEventsMgr::SendAppleEventWithReply(getSelectionEvent, reply, false);
		}
		
		// Read the reply
		StAEDescriptor	errorCode(reply, keyErrorNumber);
		StAEDescriptor	userSelection(reply, keyDirectObject);
		StAEDescriptor	userSelectionList;
		AEKeyword		keyWord;
		SInt32			numItems = 0;
		
		if (errorCode.mDesc.descriptorType != typeNull) {
			UExtractFromAEDesc::TheInt16(errorCode, err);
			PGPThrowIfOSError_(err);
		}
		if ((userSelection.mDesc.descriptorType != typeObjectSpecifier)
		&& (userSelection.mDesc.descriptorType != typeAEList)) {
			itemSelected = false;
		} else {
			err = ::AECoerceDesc(userSelection, typeAEList, userSelectionList);
			PGPThrowIfOSError_(err);
			err = ::AECountItems(userSelectionList, &numItems);
			PGPThrowIfOSError_(err);
			for (PGPInt32 i = 1; i <= numItems; i++) {
				StAEDescriptor	item;
				StAEDescriptor	itemRecord;
				StAEDescriptor	itemType;
				
				// We coerce the item into a record in order to get its type
				err = ::AEGetNthDesc(userSelectionList, i, typeObjectSpecifier, &keyWord,
							item);
				PGPThrowIfOSError_(err);
				err = ::AECoerceDesc(item, typeAERecord, itemRecord);
				PGPThrowIfOSError_(err);
				err = ::AEGetKeyDesc(itemRecord, keyAEDesiredClass, typeType, itemType);
				PGPThrowIfOSError_(err);
				if (*reinterpret_cast<DescType *>(*itemType.mDesc.dataHandle) == cProperty) {
					StAEDescriptor	form;
					StAEDescriptor	propertyID;
					
					err = ::AEGetKeyDesc(itemRecord, keyAEKeyData, typeType, form);
					PGPThrowIfOSError_(err);
					if (*reinterpret_cast<DescType *>(*form.mDesc.dataHandle)
					!= formPropertyID) {
						itemSelected = false;
						break;
					}
					err = ::AEGetKeyDesc(itemRecord, keyAEKeyData, typeType, propertyID);
					PGPThrowIfOSError_(err);
					if (*reinterpret_cast<DescType *>(*propertyID.mDesc.dataHandle)
					!= pTrash) {
						itemSelected = false;
						break;
					} else {
						trashSelected = true;
					}
				} else if ((*reinterpret_cast<DescType *>(*itemType.mDesc.dataHandle) != cFile)
				&& (*reinterpret_cast<DescType *>(*itemType.mDesc.dataHandle) != cFolder)) {
					itemSelected = false;
					break;
				}
			}
		}
		UAppleEventsMgr::CheckForMissedParams(reply);
	}
	
	catch (...) {
		itemSelected = false;
	}
	
	if (itemSelected && (! trashSelected)) {
		mSignEnabled = true;
		mEncryptEnabled = true;
		mDecryptEnabled = true;
		mVerifyEnabled = true;
	} else {
		mSignEnabled = false;
		mEncryptEnabled = false;
		mDecryptEnabled = false;
		mVerifyEnabled = false;
	}
	CPGPmenu::AdjustMenuItems();
}



	long
CPGPFindermenu::FilterMenuSelect(
	long	inResult)
{
	long	result;
	
	if (DoWipeTrash() && (HiWord(inResult) == mSpecialMenu)
	&& (LoWord(inResult) == mEmptyTrashItem)) {
		SendToolsEvent(
		(CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->modifiers & optionKey)
			? kAEOptionWipeTrashID : kAEWipeTrashID);
		result = 0;
	} else {
		result = CPGPmenu::FilterMenuSelect(inResult);
	}
	
	return result;
}



	void
CPGPFindermenu::FindEmptyTrash()
{
	PGPUInt16	numMenus;
	PGPInt16	numItems;
	MenuHandle	menu;
	Str255		itemText;
	
	mSpecialMenu = 0;
	numMenus = GetNumMenusInMenuBar();
	for (PGPUInt16 i = 0; i < numMenus; i++) {
		menu = GetIndMenuInMenuBar(i);
		if (PStringsAreEqual((**menu).menuData, mSpecialString)) {
			numItems = ::CountMItems(menu);
			for (PGPInt16 x = 1; x <= numItems; x++) {
				::GetMenuItemText(menu, x, itemText);
				if (pgpMemoryEqual(&static_cast<StringPtr>(mEmptyTrashString)[1], &itemText[1],
				static_cast<StringPtr>(mEmptyTrashString)[0])) {
					mSpecialMenu = (**menu).menuID;
					mEmptyTrashItem = x;
					break;
				}
			}
		}
		if (mSpecialMenu != 0) {
			break;
		}
	}
}



	PGPBoolean
CPGPFindermenu::DoWipeTrash()
{
	return (CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->modifiers & cmdKey) ?
				!mWipeTrash : mWipeTrash;
}



	void
CPGPFindermenu::UpdatePrefs()
{
	PGPError			pgpErr;
	StPGPMemoryMgrRef	memoryMgr;
	StPGPPrefRef		prefs;
	
	CPGPmenu::UpdatePrefs();
	pgpErr = PGPNewMemoryMgr(0, &memoryMgr);
	PGPThrowIfPGPError_(pgpErr);
	pgpErr = PGPOpenClientPrefs(memoryMgr, &prefs);
	PGPThrowIfPGPError_(pgpErr);
	pgpErr = PGPGetPrefBoolean(prefs, kPGPPrefTrashIntegration, &mWipeTrash);
	PGPThrowIfPGPError_(pgpErr);
	pgpErr = PGPGetPrefBoolean(prefs, kPGPPrefWarnOnWipe, &mWarnOnWipe);
	PGPThrowIfPGPError_(pgpErr);
}


	void
CPGPFindermenu::Sign()
{
	SendToolsEvent(
		(CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->modifiers & optionKey)
			? kAEOptionSignID : kAESignID);
}



	void
CPGPFindermenu::Encrypt()
{
	SendToolsEvent(
		(CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->modifiers & optionKey)
			? kAEOptionEncryptID : kAEEncryptID);
}



	void
CPGPFindermenu::EncryptAndSign()
{
	SendToolsEvent(
		(CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->modifiers & optionKey)
			? kAEOptionEncryptAndSignID : kAEEncryptAndSignID);
}



	void
CPGPFindermenu::DecryptVerify()
{
	SendToolsEvent(
		(CPGPmenuWaitNextEventPatch::GetEventParamsPtr()->theEvent->modifiers & optionKey)
			? kAEOptionDecryptVerifyID : kAEDecryptVerifyID);
}



	void
CPGPFindermenu::SendToolsEvent(
	AEEventID	inEventID)
{
	OSStatus			err;
	AppParameters		params;
	ProcessSerialNumber	psn;
	StAEDescriptor		address;
	StAEDescriptor		event;

	params.theMsgEvent.what = kHighLevelEvent;
	params.theMsgEvent.message = kAEPGPmenuClass;
	params.theMsgEvent.where = *(Point *) & kAEmenuOpenApp;
	params.theMsgEvent.when = params.theMsgEvent.modifiers = 0;
	params.eventRefCon = 0;
	params.messageLength = 0;
	err = BringAppToFront(kPGPtoolsType, kPGPtoolsCreator, kFindAppOnAllVolumes, true,
			&params, nil);
	if (err != noErr) {
		WarningAlert(kWAStopAlertType, kWAOKStyle, STRx_Findermenu,
			stringID_UnableToSendToolsEvent);
		PGPThrowPGPError_(kPGPError_UserAbort);
	}
	PGPThrowIfNot_(FindProcess(kPGPtoolsType, kPGPtoolsCreator, &psn, 0, 0, 0),
		CString(CStringFromSTRx(STRx_Findermenu, stringID_UnableToSendToolsEvent)));
	err = ::AECreateDesc(typeProcessSerialNumber, reinterpret_cast<Ptr>(&psn),
				sizeof(psn), address);
	PGPThrowIfOSError_(err);
	err = ::AECreateAppleEvent(kAEPGPmenuClass, inEventID, address, kAutoGenerateReturnID,
				kAnyTransactionID, event);
	PGPThrowIfOSError_(err);
	UAppleEventsMgr::SendAppleEvent(event);
}



	long
CPGPFindermenu::CPGPFindermenuMenuSelectPatch::NewMenuSelect(
	Point	startPt)
{
	long				result;
	CPGPFindermenu *	pgpmenu = dynamic_cast<CPGPFindermenu *>(CPGPmenu::Getmenu());
	MenuHandle			menu = 0;
	Str255				savedText;
	
	if (pgpmenu->mSpecialMenu == 0) {
		pgpmenu->FindEmptyTrash();
	}
	if (pgpmenu->DoWipeTrash()) {
		menu = ::GetMenuHandle(pgpmenu->mSpecialMenu);
	}
	if (menu != 0) {
		::GetMenuItemText(menu, pgpmenu->mEmptyTrashItem, savedText);
		if (pgpmenu->mWarnOnWipe) {
			::SetMenuItemText(menu, pgpmenu->mEmptyTrashItem, pgpmenu->mWarnAndWipeTrashString);
		} else {
			::SetMenuItemText(menu, pgpmenu->mEmptyTrashItem, pgpmenu->mWipeTrashString);
		}
	}
	result = CPGPmenuMenuSelectPatch::NewMenuSelect(startPt);
	if (menu != 0) {
		::SetMenuItemText(menu, pgpmenu->mEmptyTrashItem, savedText);
	}
	
	return result;
}


// We define our own version here to keep from having to pull in any sdk stuff
	PGPError
PGPGetErrorString(
	PGPError	theError,
	PGPSize		bufferSize,
	char *		theString)
{
	(void *) theError;
	
	if (bufferSize > 0) {
		*theString = 0;
	}
	
	return kPGPError_NoErr;
}