/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CPGPClarisEmailermenu.cp,v 1.2 1999/04/30 06:35:11 jason Exp $
____________________________________________________________________________*/

#include <AEObjects.h>
#include <AEPackObject.h>
#include <AERegistry.h>

#include <UAppleEventsMgr.h>
#include <UExtractFromAEDesc.h>

#include "pgpMemoryMgr.h"
#include "pgpMem.h"

#include "StPGPRefs.h"

#include "CPGPClarisEmailermenu.h"



namespace {
	const DescType	pDisplayedMessage	=	'pMsg';
	const DescType	pContent			=	'ctnt';
	const DescType	pAddress			=	'addr';
	const DescType	cRecipient			=	'rcpt';
}



CPGPClarisEmailermenu::CPGPClarisEmailermenu(
	FSSpec *			inFSSpec,
	SPGPmenuMESPData *	inMESPData)
		: CPGPAppleEventmenu(inFSSpec, inMESPData)
{
}



CPGPClarisEmailermenu::~CPGPClarisEmailermenu()
{
}



	void
CPGPClarisEmailermenu::DoOperation(
	EOperation	inOperation)
{
	//	We override this operation because emailer won't let us get the selection from the
	//	output window.
	if (inOperation == op_DecryptVerify) {
		StPGPDataRef	input;
		PGPSize			inputSize;
		StPGPDataRef	output;
		PGPSize			outputSize;
		
		GetContents(&input, &inputSize);
		if (inputSize > 0) {
			AppDecryptVerify(input, inputSize, reinterpret_cast<char **>(&output),
				&outputSize);
			SetContents(output, outputSize);
		}
	} else {
		CPGPAppleEventmenu::DoOperation(inOperation);
	}
}



	void
CPGPClarisEmailermenu::GetSelection(
	PGPByte **	outData,
	PGPSize *	outDataSize)
{
	OSErr			err;
	StAEDescriptor	reply;
	
	{
		StAEDescriptor	getSelectionEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		StAEDescriptor	selectionProperty(static_cast<DescType>(pUserSelection));
		StAEDescriptor	selection;
		
		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getSelectionEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, window, formPropertyID, selectionProperty,
					false, selection);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(getSelectionEvent, keyDirectObject, selection);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEventWithReply(getSelectionEvent, reply, false);
	}
	
	StAEDescriptor	errorCode(reply, keyErrorNumber);
	StAEDescriptor	userSelection(reply, keyDirectObject, typeChar);
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	*outDataSize = ::GetHandleSize(userSelection.mDesc.dataHandle);
	if (*outDataSize > 0) {
		*outData = static_cast<PGPByte *>(PGPNewData(mMemoryMgr, *outDataSize,
											kPGPMemoryMgrFlags_None));
		PGPThrowIfMemFail_(*outData);
		pgpCopyMemory(*userSelection.mDesc.dataHandle, *outData, *outDataSize);
		UAppleEventsMgr::CheckForMissedParams(reply);
	}
}



	void
CPGPClarisEmailermenu::SetSelection(
	PGPByte *	inData,
	PGPSize		inDataSize)
{
	OSStatus		err;
	StAEDescriptor	setSelectionEvent;
	StAEDescriptor	nullDescriptor;
	DescType		first = kAEFirst;
	StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
	StAEDescriptor	window;
	StAEDescriptor	selectionProperty(static_cast<DescType>(pUserSelection));
	StAEDescriptor	selection;
	
	UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAESetData, setSelectionEvent);
	err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
				firstPosition, false, window);
	PGPThrowIfOSError_(err);
	err = ::CreateObjSpecifier(cProperty, window, formPropertyID, selectionProperty,
				false, selection);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setSelectionEvent, keyDirectObject, selection);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setSelectionEvent, keyAEData,
				StAEDescriptor(typeChar, inData, inDataSize));
	PGPThrowIfOSError_(err);
	UAppleEventsMgr::SendAppleEvent(setSelectionEvent);
}



	void
CPGPClarisEmailermenu::GetContents(
	PGPByte **	outData,
	PGPSize *	outDataSize)
{
	OSErr			err;
	StAEDescriptor	reply;
	
	{
		StAEDescriptor	getContentsEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		StAEDescriptor	displayedMessageProperty(static_cast<DescType>(pDisplayedMessage));
		StAEDescriptor	displayedMessage;
		StAEDescriptor	contentProperty(static_cast<DescType>(pContent));
		StAEDescriptor	content;
		
		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getContentsEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, window, formPropertyID, displayedMessageProperty,
					false, displayedMessage);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, displayedMessage, formPropertyID, contentProperty,
					false, content);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(getContentsEvent, keyDirectObject, content);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEventWithReply(getContentsEvent, reply, false);
	}
	
	StAEDescriptor	errorCode(reply, keyErrorNumber);
	StAEDescriptor	contents(reply, keyDirectObject, typeChar);
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	*outDataSize = ::GetHandleSize(contents.mDesc.dataHandle);
	if (*outDataSize > 0) {
		*outData = static_cast<PGPByte *>(PGPNewData(mMemoryMgr, *outDataSize,
											kPGPMemoryMgrFlags_None));
		PGPThrowIfMemFail_(*outData);
		pgpCopyMemory(*contents.mDesc.dataHandle, *outData, *outDataSize);
		UAppleEventsMgr::CheckForMissedParams(reply);
	}
}



	void
CPGPClarisEmailermenu::SetContents(
	PGPByte *	inData,
	PGPSize		inDataSize)
{
	OSStatus		err;
	StAEDescriptor	setContentsEvent;
	StAEDescriptor	nullDescriptor;
	DescType		first = kAEFirst;
	StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
	StAEDescriptor	window;
	StAEDescriptor	displayedMessageProperty(static_cast<DescType>(pDisplayedMessage));
	StAEDescriptor	displayedMessage;
	StAEDescriptor	contentProperty(static_cast<DescType>(pContent));
	StAEDescriptor	content;
	
	UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAESetData, setContentsEvent);
	err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
				firstPosition, false, window);
	PGPThrowIfOSError_(err);
	err = ::CreateObjSpecifier(cProperty, window, formPropertyID, displayedMessageProperty,
				false, displayedMessage);
	PGPThrowIfOSError_(err);
	err = ::CreateObjSpecifier(cProperty, displayedMessage, formPropertyID, contentProperty,
				false, content);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setContentsEvent, keyDirectObject, content);
	PGPThrowIfOSError_(err);
	err = ::AEPutParamDesc(setContentsEvent, keyAEData,
				StAEDescriptor(typeChar, inData, inDataSize));
	PGPThrowIfOSError_(err);
	UAppleEventsMgr::SendAppleEvent(setContentsEvent);
}



	void
CPGPClarisEmailermenu::GetRecipients(
	PGPUInt32 *			outNumRecipients,
	PGPRecipientSpec **	outRecipients)
{
	OSErr			err;
	StAEDescriptor	reply;
	
	*outNumRecipients = 0;
	{
		StAEDescriptor	getRecipientsEvent;
		StAEDescriptor	nullDescriptor;
		DescType		first = kAEFirst;
		StAEDescriptor	firstPosition(typeAbsoluteOrdinal, &first, sizeof(first));
		StAEDescriptor	window;
		StAEDescriptor	displayedMessageProperty(static_cast<DescType>(pDisplayedMessage));
		StAEDescriptor	displayedMessage;
		DescType		all = kAEAll;
		StAEDescriptor	allPosition(typeAbsoluteOrdinal, &all, sizeof(all));
		StAEDescriptor	recipientElements;
		StAEDescriptor	addressProperty(pAddress);
		StAEDescriptor	address;
		
		UAppleEventsMgr::MakeAppleEvent(kAECoreSuite, kAEGetData, getRecipientsEvent);
		err = ::CreateObjSpecifier(cWindow, nullDescriptor, formAbsolutePosition,
					firstPosition, false, window);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, window, formPropertyID, displayedMessageProperty,
					false, displayedMessage);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cRecipient, displayedMessage, formAbsolutePosition, allPosition,
					false, recipientElements);
		PGPThrowIfOSError_(err);
		err = ::CreateObjSpecifier(cProperty, recipientElements, formPropertyID, addressProperty,
					false, address);
		PGPThrowIfOSError_(err);
		err = ::AEPutParamDesc(getRecipientsEvent, keyDirectObject, address);
		PGPThrowIfOSError_(err);
		UAppleEventsMgr::SendAppleEventWithReply(getRecipientsEvent, reply, false);
	}
	
	StAEDescriptor		errorCode(reply, keyErrorNumber);
	StAEDescriptor		recipientList(reply, keyDirectObject, typeAEList);
	SInt32				numRecipients;
	StPGPDataRef		recipientBuffer;
	PGPRecipientSpec *	recipients;
	AEKeyword			keyWord;
	PGPSize				dataSize;
	
	if (errorCode.mDesc.descriptorType != typeNull) {
		UExtractFromAEDesc::TheInt16(errorCode, err);
		PGPThrowIfOSError_(err);
	}
	err = ::AECountItems(recipientList, &numRecipients);
	PGPThrowIfOSError_(err);
	if (numRecipients > 0) {
		recipientBuffer = static_cast<PGPByte *>(PGPNewData(mMemoryMgr, numRecipients *
												sizeof(PGPRecipientSpec), kPGPMemoryMgrFlags_None));
		PGPThrowIfMemFail_(recipientBuffer);
		recipients = reinterpret_cast<PGPRecipientSpec*>(static_cast<PGPByte *>(recipientBuffer));
		for (PGPUInt32 i = 1; i <= numRecipients; i++) {
			StAEDescriptor	aRecipient;
			StAEDescriptor	anAddress;
			
			err = ::AEGetNthDesc(recipientList, i, typeWildCard, &keyWord, aRecipient);
			PGPThrowIfOSError_(err);
			err = ::AEGetKeyDesc(aRecipient, pAddress, typeChar, anAddress);
			PGPThrowIfOSError_(err);
			dataSize = ::GetHandleSize(anAddress.mDesc.dataHandle);
			if (dataSize > 253) {
				dataSize = 253;
			}
			recipients[i - 1].type = kPGPRecipientSpecType_UserID;
			recipients[i - 1].locked = false;
			recipients[i - 1].u.userIDStr[0] = '<';
			pgpCopyMemory(*anAddress.mDesc.dataHandle, &recipients[i - 1].u.userIDStr[1], dataSize);
			recipients[i - 1].u.userIDStr[dataSize + 1] = '>';
			recipients[i - 1].u.userIDStr[dataSize + 2] = 0;
		}
		UAppleEventsMgr::CheckForMissedParams(reply);
		*outNumRecipients = numRecipients;
		*outRecipients = recipients;
		recipientBuffer = 0;
	}
}
