/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CSplitWindow.h,v 1.9 1999/03/10 02:41:16 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LGADialog.h>
#include <LDragAndDrop.h>
#include <LBroadcaster.h>
#include <LCommander.h>
#include <LActiveScroller.h>
#include <LLittleArrows.h>
#include <LStaticText.h>
#include <LPushButton.h>

#include "pgpKeys.h"
#include "pgpShareFile.h"
#include "CShareholderList.h"

const ResIDT	kSplitDialogResID	=	151;


class CSplitWindow		:					public LGADialog,
											public LBroadcaster,
											public LDragAndDrop
{
public:
	enum { class_ID = 'SplK' };
					CSplitWindow();
					CSplitWindow(LStream *inStream);
					~CSplitWindow();
	void			ListenToMessage(MessageT inMessage, void *ioParam);
	void			FinishCreateSelf();
	virtual Boolean	ItemIsAcceptable(
										DragReference	inDragRef,
										ItemReference	inItemRef);
	virtual void	ReceiveDragItem(
										DragReference	inDragRef,
										DragAttributes	inDragAttrs,
										ItemReference	inItemRef,
										Rect			&inItemBounds);
	
	void			SetSplitKey(		PGPKeyRef		key );
	void			Split();
private:
	PGPError		MakeShareFile(PGPShareRef			shareRef,
								ShareholderListEntry *	holder,
								Int32					dirID,
								Int16					vRefNum );
	void			DoDropAreaHilite(
										DragReference 	inDragRef,
										Boolean			showHilite);

	CShareholderList *		mHolderList;
	PGPKeyID				mKeyID;
	PGPPublicKeyAlgorithm	mAlgorithm;
	LActiveScroller	*		mScroller;
	LStaticText	*			mSplitName,
				*			mReqdShares,
				*			mSelShares,
				*			mTotalShares,
				*			mSelName;
	LPushButton *			mSplitKeyButton,
				*			mRemoveButton;
	PGPBoolean				mActiveSelection;
	STableCell				mSelectedCell;
	LLittleArrows *			mSelArrows;

	enum	{	
				kSplitKeyName			= 'cNam',
				kSplitKeyIcon			= 'iSKI',
				kHolderScroller			= 'sSCR',
				kHolderList				= 'lSHA',
				kSelectedShareName		= 'cSel',
				kSelectedShareNum		= 'cSSh',
				kTotalShareNum			= 'cTSh',
				kRequiredShareNum		= 'cRSh',
				kShareArrows			= 'aSha',
				kReqdShareArrows		= 'aRSh',
				kAddHolderButton		= 'bAdd',
				kRemoveHolderButton		= 'bRmv',
				kSplitKeyButton			= 'bSpl',
				kSplitCancelButton		= 'bCan'
			};
};

