/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CKeyTable.h,v 1.63 1999/05/10 03:42:32 wprice Exp $
____________________________________________________________________________*/
#pragma once

#include <UGWorld.h>
#include <LDragAndDrop.h>
#include <LListener.h>
#include <LBroadcaster.h>
#include <LPeriodical.h>
#include <LCommander.h>
#include <LMarqueeTask.h>

#include "pgpKeys.h"
#include "CDragSource.h"
#include "CPGPHierarchyTable.h"
#include "pgpKeyServerPrefs.h"
#include "CCAServer.h"

class CKeyDragTask;
class CKeyTableLabels;
class CSearchWindow;
class CGroupsWindow;

const ResIDT	kColumnTitleStringsID	=	1000;
const Int16		kMaxKeyTableColumnTypes	=	9;
const Int16		kMaxKeypressInterval	=	60;
const Int16		kMaxSearchStringSize	=	64;
const Int16		kDropFlagSlop			=	20;
const Int16		kLevelIndent			=	20;
const MessageT	kRebuildServersMessage	=	'reSM';
const MessageT	kKeyTableRedrawMessage	=	'redr';
const MessageT	kKeyTableResyncMessage	=	'resy';
const Int16		kLeftIndent				=	2;
const Int16		kIconWidth				=	16;
const Int16		kIconHeight				=	16;
const Int16		kLeftBorder				=	4;
const Int16		kBottomBorder			=	5;

typedef struct KeyTableColumnInfo
{
	Int16	numActiveColumns;
	Int16	columns[kMaxKeyTableColumnTypes];
	Int16	columnWidths[kMaxKeyTableColumnTypes];
} KeyTableColumnInfo;

enum KeyTableEntryType	{	kKey, kUserID, kSignature	};

typedef struct KeyTableRef
{
	enum KeyTableEntryType	type;
	PGPKeyRef				ownerKey;
	Boolean					terminated;
	ResIDT					iconID;
	Int16					selectRight,
							selectLeft;
	union
	{
		PGPKeyRef			key;
		PGPUserIDRef		user;
		PGPSigRef			sig;
	} u;
} KeyTableRef;

typedef struct KeyImportStruct
{
	Boolean				savedImportIsFile;
	Boolean				bypassImportDialog;
	FSSpec				savedImportSpec;
	PGPByte				*savedImportBuffer;
	PGPSize				savedImportBufferSize;
	KeyImportStruct		*next;
} KeyImportStruct;


class	CKeyTable	:	public CPGPHierarchyTable,
						public LBroadcaster,
						public LCommander,
						public CDragSource,
						public LDragAndDrop,
						public LListener,
						public LPeriodical,
						public LMarqueeReceiver
{
public:
	enum { class_ID = 'keyT' };
						CKeyTable(LStream *inStream);
	virtual				~CKeyTable();
	void				FinishCreateSelf();
	virtual Boolean		ObeyCommand(CommandT inCommand, void* ioParam);	
	virtual void		FindCommandStatus(CommandT inCommand,
							Boolean &outEnabled, Boolean &outUsesMark,
							Char16 &outMark, Str255 outName);
	virtual Boolean		HandleKeyPress(const EventRecord&	inKeyEvent);
	virtual void		DrawSelf();
	virtual void		ClickSelf(const SMouseDownEvent	&inMouseDown);
	virtual void		Click(SMouseDownEvent	&inMouseDown);
	virtual void		ListenToMessage(	MessageT	inMessage,
											void		*ioParam);
	virtual void		SpendTime(const EventRecord		&inMacEvent);
	virtual const LView*	GetTargetView() const;
	virtual void		FocusMarqueeArea();
	virtual Boolean		CheckSelectionChanged(
								const LMarqueeTask& inMarqueeTask,
								const Rect&			inOldMarqueeRect,
								const Rect&			inNewMarqueeRect);
	virtual void		DrawDropFlag(
								const STableCell	&inCell,
								TableIndexT			inWideOpenRow);
								
	virtual void		UpdateSelection(
								const LMarqueeTask& inMarqueeTask,
								const Rect&			inOldMarqueeRect,
								const Rect&			inNewMarqueeRect);
	
	void				ScrollImageBy(
									Int32		inLeftDelta,
									Int32		inTopDelta,
									Boolean		inRefresh);
	void				SetKeyLabels(CKeyTableLabels *keyLabels);

	// Drag and Drop Class Overrides
	void				FocusDropArea();
	virtual Boolean		ItemIsAcceptable(
										DragReference	inDragRef,
										ItemReference	inItemRef);
	virtual void		ReceiveDragItem(
										DragReference	inDragRef,
										DragAttributes	inDragAttrs,
										ItemReference	inItemRef,
										Rect			&inItemBounds);
	void				HiliteDropArea(	DragReference	inDragRef);
	void				UnhiliteDropArea(DragReference	inDragRef);
	
	// The next four functions are overrides from CDragSource
	virtual void		GetDragHiliteRgn(	RgnHandle		ioHiliteRgn,
											const STableCell&	skipCell,
											Boolean			globalize );
	virtual void		AddFlavors(			CKeyDragTask	*dragTask);
	virtual Boolean		GetKeyRef(			ItemReference	item, 
											PGPKeyRef *		key);
	virtual Boolean		GetTextBlock(		ItemReference	item, 
											void			**outData,
											Int32			*len );
	virtual Boolean		GetHFS(				ItemReference	item,
											DragReference	dragRef,
											FSSpec			*spec);

	// Key Management routines
	virtual void		SetKeyDBInfo(	PGPKeySetRef	keySet,
										Boolean			writable,
										Boolean			defaultRings );
	void				GetKeyColumnInfo(KeyTableColumnInfo *columnInfo);
	void				ImportKeysFromHandle(Handle data);
	void				ImportKeysFromKeySet(PGPKeySetRef keySet);

	// Table Management routines
	Boolean				ResyncTable(	Boolean collapse,
										Boolean onlyUnmarked,
										Boolean	selectUnmarkedKeys = FALSE );
	void				RedrawTable();
	void				ClearTable();
	void				Reset1();
	void				Empty();
	void				MoveColumn( Int16 oldCol, Int16 newCol );
	void				ResizeColumn( Int16 col, Int16 newSize );
	
	static void			DrawIcon(
							ResIDT				iconID,
							Rect				cellRect,
							UInt32				indentLevel,
							IconTransformType	transform = kTransformNone );
	
	Boolean				IsWritable()	{	return mMutableRing;	}
	Boolean				IsDefault()		{	return mDefaultRing;	}
	PGPKeySetRef		GetKeySet()		{	return mKeySet;			}
	PGPKeyListRef		GetKeyList()	{	return mKeyList;		}
	void				BuildServerSubmenu();
	PGPBoolean			GetSelectionStats(
								PGPUInt32	*numKeys,
								PGPUInt32	*numUserIDs,
								PGPUInt32	*numSigs );
	void				GetSelectedKeySet(
								PGPKeySetRef *selectedKeys );
protected:
	virtual void		DrawCell(
								const STableCell		&inCell,
								const Rect				&inLocalRect);
	virtual void		ClickCell(
								const STableCell&		inCell,
								const SMouseDownEvent&	inMouseDown);
	virtual void		HiliteCellActively(
								const STableCell	&inCell,
								Boolean				inHilite);
	virtual void		HiliteCellInactively(
								const STableCell	&inCell,
								Boolean				inHilite);
	void				ClickValidityCell(
								const STableCell&		inCell);
private:
	void				DrawCell1(
								const STableCell	&inCell,
								const Rect			&inLocalRect,
								Boolean				hilite,
								Boolean				inactive );
	void				Reset();
	void				CommitKeySet();
	Boolean				AskUserForUserID(Str255 userIDStr);
	Boolean				AskUserForPhotoID(void **photoData,
							PGPSize	*photoDataSize);
	
	Boolean				SelectionExists();
	void				CollapseKeys(Boolean all);
	void				ExpandKeys();
	UInt32				SelectionAction(
							Boolean (CKeyTable::*function)(STableCell&));
	Boolean				ShowKeyInfo(STableCell& inCell);
	Boolean				Revoke(STableCell& inCell);
	Boolean				Split(STableCell& inCell);
	Boolean				CAServerOp(STableCell& inCell);
	Boolean				Delete(STableCell& inCell);
	Boolean				AddDrag(STableCell& inCell);
	Boolean				EnableKey(STableCell& inCell);
	Boolean				DisableKey(STableCell& inCell);
	Boolean				GetCellOnServer(STableCell& inCell);
	Boolean				SendKeyToServer(STableCell& inCell);
	Boolean				GetKeyOnServer(PGPKeyRef key);
	Boolean				SetDefault();
	void				AddUserID(PGPBoolean addPhotoID);
	void				AddRevoker();
	void				Sign();
	void				ReverifySigs();
	static PGPError		ReverifySigsHandler(
									PGPContextRef	context,
									PGPEvent		*event,
									PGPUserValue	userValue );
	static PGPError		CAServerHandler(
									PGPContextRef	context,
									PGPEvent		*event,
									PGPUserValue	userValue );
	PGPError			GetMetaIntroducers(PGPKeySetRef		*metaKeys);
	void				UpdateIntroducers();
	void				ImportHandler();
	void				ImportKeysFromFile(FSSpec *keyFile, Boolean noDialog);
	void				UnmarkKey(PGPKeyRef inKey);
	void				RemoveKeyFromTable(PGPKeyRef inKey);
	void				TerminateKey(PGPKeyRef inKey);
	void				RemoveTerminatedKeys();
	void				CopyKeys();
	void				ExportSelected();
	void				SelectSearchString();
	void				SetupColumns();
	Boolean				ColumnVisible(Int16	columnID);
	void				ToggleColumn(Int16 columnID);
	void				GetColumnCheck(	Int16		columnID,
										Boolean		&outEnabled,
										Boolean		&outUsesMark,
										Char16		&outMark);
	void				GetCellDragRgn(
										const STableCell&	inCell,
										RgnHandle			dragRgn,
										Boolean				cutout );
	Boolean				DrawUserIDColumnCell(	KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth,
												Boolean		hilite,
												Boolean		inactive );
	void				DrawValidityColumnCell(	KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawTrustColumnCell(	KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawSizeColumnCell(		KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawKeyIDColumnCell(	KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawCreationColumnCell(	KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawExpirationColumnCell(KeyTableRef *ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawMRKColumnCell(		KeyTableRef	*ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawDescriptionColumnCell(KeyTableRef *ktr,
												Rect		cellRect,
												Int16		depth);
	void				DrawTrust(				Int32		trustValue,
												Rect		cellRect,
												Int16		depth);
	void				DrawValidity(			Int32		trustValue,
												Rect		cellRect,
												Int16		depth);
	Boolean				WeAreFront();
	void				StepForward();
	void				SaveColumnInfo();

	
	PGPKeyIterRef		mKeyIter;
	PGPKeySetRef		mKeySet;
	PGPKeyListRef		mKeyList;
	KeyTableColumnInfo	mColumnInfo;
	CKeyTableLabels		*mKeyLabels;
	Boolean				mMutableRing;
	Boolean				mDefaultRing;
	PGPBoolean			mHasRSA;
	CKeyDragTask		*mDragTask;
	PixPatHandle		mBarberPixPat;
	Int16				mLowVertUpdate,
						mHighVertUpdate;
	PGPKeyRef			mDefaultKey;
	KeyImportStruct		*mImports;
	Int32				mBlockDialogDelays;
	Boolean				mNotified,
						mSendingDrag;
	PGPKeyServerEntry	*mTargetKeyServer;
	LGWorld				*mDragHiliteWorld;
	RgnHandle			mDragHiliteRgn;
	Handle				mNotifyIconSuite;
	PGPkeysCAOp			mCAOp;
	
	UInt32				mLastKeypress;
	char				mSearchString[kMaxSearchStringSize];
	
	static KeyTableColumnInfo	kDefaultColumnInfo;
	
	enum	{
				kUserIDColumnID = 0,
				kValidityColumnID,
				kTrustColumnID,
				kKeySizeColumnID,
				kKeyIDColumnID,
				kCreationColumnID,
				kExpirationColumnID,
				kMRKColumnID,
				kDescriptionColumnID
			};

	enum	{
				kStringListID		= 1004,
				kAddNameOnlyPairsID	= 1,
				kClearQuestion,
				kCantDefaultStringID,
				kBadPassID,
				kExpandSelectionID,
				kCollapseSelectionID,
				kExpandAllID,
				kCollapseAllID,
				kSigUserUnavailableID,
				kRevokeConfirmID,
				kUserIDSampleID,
				kNoKeyToExportID,
				kDupeUserID,
				kGetSignerMenuItemID,
				kGetSelectedKeyMenuItemID,
				kSetDefaultMenuItemID,
				kSetPrimaryNameMenuItemID,
				kNeverExpiresID,
				kBadNameID,
				kNoKeysFoundID,
				kSpecifyKeysToImportID,
				kStepForwardID,
				kExportKeysPromptID,
				kExportKeysDefaultNameID,
				kServerSendSuccessful,
				kVerifyingSignaturesID,
				kFailedServerPolicyID,
				kPhotographID,
				kUnknownID,
				kNoRootServerID,
				kAddRevokerID,
				kAddRevokerConfirmationID,
				kAddRevokerFinishedID,
				kNoRevokerKeyID,
				kOnlyOnePhotoID,
				kNoX509Revocation,
				kCertReqSuccessfulID,
				kCertRetrieveSuccessID,
				kCRLUpdateSuccessID,
				
				kKeyDescriptionsStringListID	=	1018,
				kRSAKeyDescriptionID			=	1,
				kDHDSSKeyDescriptionID,
				kRSAKeyPairDescriptionID,
				kDHDSSKeyPairDescriptionID,
				kUserIDDescriptionID,
				kDSSSignatureDescriptionID,
				kRSASignatureDescriptionID,
				kUnknownSignatureDescriptionID,
				kSplitKeyPairDescriptionID,
				kX509DSSCertDescriptionID,
				kX509RSACertDescriptionID
			};
};

