/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: PGPnetOpenPrefs.cp,v 1.4 1999/04/26 10:06:27 wprice Exp $
____________________________________________________________________________*/

#include <TextUtils.h>
#include <Finder.h>

#include "PGPnetOpenPrefs.h"

#include "MacErrors.h"
#include "MacFiles.h"
#include "pgpFileSpec.h"
#include "pgpNetPrefs.h"
#include "CComboError.h"
#include "pgpClientErrors.h"
#include "pgpMem.h"

const ResID		kPrefsNameListID			=	14448;
const short		kNetPrefsFilenameStrIndex	=	1;
const short		kNetLogFilenameStrIndex		=	2;


	PGPError
PGPnetOpenPrefs(
	PGPMemoryMgrRef	memoryMgr,
	PGPPrefRef		*prefRef)
{
	CComboError		err;
	FSSpec			fsSpec;
	Boolean			created = FALSE;
	
	PGPValidatePtr( prefRef );
	*prefRef	= NULL;
	
	err.err = FindPGPPreferencesFolder(-1, &fsSpec.vRefNum, &fsSpec.parID);
	if ( err.IsntError() )
	{
		PFLFileSpecRef	fsRef	= NULL;
		
		GetIndString( fsSpec.name, kPrefsNameListID,
					kNetPrefsFilenameStrIndex);
		pgpAssert( fsSpec.name[0] != 0 );
		
		err.pgpErr	= PFLNewFileSpecFromFSSpec( memoryMgr, &fsSpec, &fsRef);
		if ( err.IsntError() )
		{
			PFLFileSpecMacMetaInfo		info;
			
			pgpClearMemory( &info, sizeof( info ) );
			
			info.fInfo.fileCreator	= kPGPMacFileCreator_Keys;
			info.fInfo.fileType		= 'pref';
			info.fInfo.location.h	= -1;
			info.fInfo.location.v	= -1;

			err.pgpErr = PFLSetFileSpecMetaInfo( fsRef, &info );
		}
			
		if ( err.IsntError() )
		{
			err.pgpErr = PGPOpenPrefFile(fsRef, netDefaults, 
							netDefaultsSize, prefRef);
			
			PFLFreeFileSpec( fsRef );
		}
	}
	
	return( err.ConvertToPGPError() );
}

	PGPError
PGPnetOpenLog(
	PGPMemoryMgrRef	memoryMgr,
	PGPBoolean		writeAccess,
	PGPnetLogRef	*logRef )
{
	CComboError		err;
	FSSpec			fsSpec;
	Boolean			created = FALSE;
	
	PGPValidatePtr( logRef );
	*logRef	= NULL;
	
	err.err = FindPGPPreferencesFolder(-1, &fsSpec.vRefNum, &fsSpec.parID);
	if ( err.IsntError() )
	{
		PFLFileSpecRef	fsRef	= NULL;
		
		GetIndString( fsSpec.name, kPrefsNameListID,
					kNetLogFilenameStrIndex);
		pgpAssert( fsSpec.name[0] != 0 );
		
		/* create it if it doesn't already exist */
		if ( ! FSpExists( &fsSpec ) )
		{
			err.err	= FSpCreate( &fsSpec, 'PGPn', 'pref', smSystemScript );
			created = TRUE;
		}
		
		if ( err.IsntError() )
			err.pgpErr	= PFLNewFileSpecFromFSSpec( memoryMgr, &fsSpec, &fsRef);
			
		if ( err.IsntError() )
		{
			err.pgpErr = PGPnetOpenLogFile( fsRef, writeAccess || created,
							FALSE, logRef );
			
			PFLFreeFileSpec( fsRef );
		}
	}
	
	return( err.ConvertToPGPError() );
}

