/*
	File:		NetworkSetupHelpers.h

	Contains:	High-level network preference routines.

	Written by:	Quinn

	Copyright:	Copyright (C) 1998 by Apple Computer, Inc., all rights reserved.

				You may incorporate this Apple sample source code into your program(s) without
				restriction. This Apple sample source code has been provided "AS IS" and the
				responsibility for its operation is yours. You are not permitted to redistribute
				this Apple sample source code as "Apple sample source code" after having made
				changes. If you're going to re-distribute the source, we require that you make
				it clear in the source that the code was descended from Apple sample source
				code, but that you've made changes.

	Change History (most recent first):

         <6>     2/19/99    wprice  MODIFIED BY NETWORK ASSOCIATES
         <5>    10/11/98    Quinn   Convert "MorePrefix.h" to "MoreSetup.h".
         <4>     9/11/98    Quinn   AppleTalk on/off support.
         <3>     9/11/98    Quinn   Add "TCP will dial" code.
         <2>     5/11/98    Quinn   Fix header.
         <1>     5/11/98    Quinn   First checked in.
*/

#pragma once

/////////////////////////////////////////////////////////////////
// MoreIsBetter Setup

#include "MoreSetup.h"

/////////////////////////////////////////////////////////////////
// Mac OS Interfaces

#include <MacTypes.h>
#include <NetworkSetup.h>

/////////////////////////////////////////////////////////////////
// Routines to Enumerate and Switch TCP/IP and AppleTalk Preferences

struct NSHConfigurationEntry {
	Str255 	name;					// user-visible name of the configuration
	Boolean selected;				// true if this configuration is currently active
	Boolean crypted;
	SInt16 	cookie;					// cookies for use by this library
	CfgEntityRef cookie2;
	CfgEntityInfo cookie3;
};
typedef struct NSHConfigurationEntry NSHConfigurationEntry;
typedef NSHConfigurationEntry *NSHConfigurationListPtr;
typedef NSHConfigurationListPtr *NSHConfigurationListHandle;

#ifdef __cplusplus
extern "C" {
#endif

extern pascal ItemCount NSHCountConfigurationList(NSHConfigurationListHandle configList);
	// Returns a count of the number of entries in configList.
	
extern pascal OSStatus  NSHSetConfigurationList(OSType protocol, NSHConfigurationListHandle configList);
extern pascal OSStatus  NSHGetConfigurationList(OSType protocol, NSHConfigurationListHandle configList);
	// Reads the list of configurations for the specific protocol,
	// placing a NSHConfigurationEntry in configList for each one.
	// configList must be a non-locked handle allocated by you.
	// The routine will resize it appropriate.  Specify protocol
	// using one of the constants declared in "NetworkSetup.h",
	// ie kOTTCPv4NetworkConnection or kOTAppleTalkNetworkConnection.
	// Only handles those two protocols at the moment.

extern pascal OSStatus  NSHSelectConfiguration(OSType protocol, const NSHConfigurationEntry *chosenEntry);
	// Given an entry from the configList generated by the previous
	// routine, this routine switches the network protocol to use
	// that configuration.  Specify protocol
	// using one of the constants declared in "NetworkSetup.h",
	// ie kOTTCPv4NetworkConnection or kOTAppleTalkNetworkConnection.
	// Only handles those two protocols at the moment.

#ifdef __cplusplus
}
#endif

/////////////////////////////////////////////////////////////////
// TCP/IP Will Dial

enum {
	kNSHTCPDialUnknown = 0,
	kNSHTCPDialTCPDisabled,
	kNSHTCPDialYes,
	kNSHTCPDialNo
};

extern pascal OSStatus NSHTCPWillDial(UInt32 *willDial);
	// This routine returns, in willDial, a flag indicating
	// whether opening a TCP/IP provider will cause the modem 
	// to dial.  You must call InitOpenTransport before calling
	// this routine.  [Not because it allocates memory but
	// because it calls OTInetGetInterfaceInfo.]

/////////////////////////////////////////////////////////////////
// AppleTalk On/Off

extern pascal OSStatus NSHIsAppleTalkActive(Boolean *active);
	// Sets *active to true if the AppleTalk stack is active.

extern pascal OSStatus HSHSetAppleTalkActive(Boolean active);
	// Sets the active state of the AppleTalk stack to the active
	// parameter.

/////////////////////////////////////////////////////////////////
