/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: PGPnetModuleCommon.h,v 1.15 1999/05/05 09:54:21 wprice Exp $
____________________________________________________________________________*/

#pragma once

#include <OpenTptModule.h>

#include "pgpIPsecContext.h"
#include "PGPnetModuleMessages.h"

// From dlpiuser.h [
/* Flags for various structures. */
enum
{
	DL_NORMAL_STATUS	= 0x01,
	DL_ERROR_STATUS		= 0x02,
	DL_TRUNCATED_PACKET	= 0x04,
	DL_VERSION			= 0x00,
	DL_VERSION_BITS		= 0xF0000000
};

/* Input and output structure for I_OTSetRawMode kOTSetRecvMode ioctl. */
struct dl_recv_control_t {
	unsigned long	dl_primitive;
	unsigned long	dl_flags;
	unsigned long	dl_truncation_length;
};

typedef struct dl_recv_control_t dl_recv_control_t;

/* Structure returned with every inbound packet after kOTSetRecvMode. */
struct dl_recv_status_t {
	unsigned long	dl_overall_length;
	unsigned long	dl_flags;
	unsigned long	dl_packet_length_before_truncation;
	unsigned long	dl_pad;
	OTTimeStamp		dl_timestamp;
};
// End included dlpiuser.h ]



struct SIPReassemblyList {
	mblk_t *			header;
	mblk_t *			packetMessage;
	PGPUInt32			expireTime;
	PGPUInt32			numRemaining;
	SIPReassemblyList *	next;
};


struct SPerStreamData {
	PGPBoolean			streamOn;
	PGPIPsecContextRef	readContext;
	PGPIPsecContextRef	writeContext;
	PGPUInt32			maxSDU;
	PGPUInt32			minSDU;
	PGPUInt32			macType;
	PGPBoolean			rawRecv;
//	SIPReassemblyList *	reassemblyList;
	SIPReassemblyList *	inReassemblyList;
	SIPReassemblyList *	outReassemblyList;
};



	inline SPerStreamData *
GetPerStreamData(
	queue_t *	inQ)
{
	return reinterpret_cast<SPerStreamData *>(inQ->q_ptr);
}



struct SSAList {
	PGPUInt32	index;
	PGPikeSA	sa;
	PGPBoolean	killed;
	SSAList *	next;
};



struct SHostEntryList {
	PGPUInt32			numHosts;
	PGPNetPrefHostEntry	host[];
};



struct SPendingSAList {
	PGPUInt32				ipAddress;
	PGPBoolean				destIsRange;
	PGPUInt32				ipAddrStart;
	PGPUInt32				ipMaskEnd;
	SPendingSAList *		next;
};



struct SGlobals {
	PGPBoolean			allowUnconfigured;
	PGPBoolean			requireSecure;
	SSAList *			saList;
	SHostEntryList *	hostEntryList;
	SPendingSAList *	pendingSAList;
	PGPUInt32			broadcastAddress;
};



// These return true if they were successful
PGPBoolean	AddIPAddressToPendingList(
						PGPUInt32	inAddress,
						PGPBoolean	destIsRange,
						PGPUInt32	ipAddrStart,
						PGPUInt32	ipMaskEnd );

PGPBoolean	SendErrorToService(PGPError inError, PGPUInt32 address=0);
PGPBoolean	SendNeedSAToService(
							PGPUInt32		inAddress,
							PGPBoolean		destIsRange,
							PGPUInt32		ipAddrStart,
							PGPUInt32		ipMaskEnd );
PGPBoolean	SendKillSAToService(PGPUInt32 inIndex);
PGPBoolean	SendRekeySAToService(PGPUInt32 inIndex);
PGPBoolean	SendStatsToService();

