/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFTSerial.cp,v 1.5.10.1 1999/07/09 00:02:37 heller Exp $
____________________________________________________________________________*/
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <Serial.h>
#include <CommResources.h>
#include <CTBUtilities.h>
#include <Connections.h>
#include <LMutexSemaphore.h>
#include "CPFTSerial.h"

#include "PGPFMacUtils.h"
#include "CPFWindow.h"
#include "CStatusPane.h"

#define SERBUFSIZE			2048

SerialPort		CPFTSerial::sSerialPorts[MAXSERPORTS];
short			CPFTSerial::sNumSerialPorts;
IOCompletionUPP CPFTSerial::sSerialCompProc=NIL;


#ifdef __MC68K__
AsyncTransport *GetSPB(void)=0x2048;
static void SerialAsyncCompletion(void)
#else
static void SerialAsyncCompletion(AsyncTransport *spb)
#endif
{
#ifdef __MC68K__
	long curA5;
	AsyncTransport *spb;
	
	spb=GetSPB();
	curA5=SetA5(spb->savedA5);
#endif
	spb->mutex->Signal();	/* current LThread library doesn't support */
#ifdef __MC68K__		/* signal from here so we don't use this */
	SetA5(curA5);
#endif 
}

CPFTSerial::CPFTSerial(SerialOptions *serOpt, CPFWindow *cpfWindow, short *result)
					:	CPFTransport(cpfWindow)
{
	DCtlHandle *unitTable;
	short unitnum, units, inx, inref=0, outref=0, alreadyOpen=0;
	DCtlHandle curDCtlHndl;
	DRVRHeaderPtr drvrPtr;
	//Component compInx;
	//ComponentDescription compDesc;
	//StringHandle compName;
	
	*result = 0;
	mSerBuf = NIL;
	mIndex = mOutdex = 0;
	mInRef=0;
	mOutRef=0;
	mSPort = -1;
	for(inx = 0;inx<sNumSerialPorts;inx++)
		if(!pstrcmp(serOpt->portName, sSerialPorts[inx].name))
		{
			mSPort = inx;
			break;
		}
	units = LMGetUnitTableEntryCount();
	unitTable = (DCtlHandle *)LMGetUTableBase();
	for(unitnum=0;unitnum<units;unitnum++)
	{
		if(curDCtlHndl=*unitTable++)
		{
			if((*curDCtlHndl)->dCtlDriver &&
				((*curDCtlHndl)->dCtlFlags & dOpenedMask))
			{
				if((*curDCtlHndl)->dCtlFlags & dRAMBasedMask)
					drvrPtr=*(DRVRHeaderPtr *)((*curDCtlHndl)->dCtlDriver);
				else
					drvrPtr=(DRVRHeaderPtr)((*curDCtlHndl)->dCtlDriver);
				if(EqualString(sSerialPorts[mSPort].inName, drvrPtr->drvrName,0,1))
				{
					inref = (*curDCtlHndl)->dCtlRefNum;
					alreadyOpen++;
				}
				if(EqualString(sSerialPorts[mSPort].outName, drvrPtr->drvrName,0,1))
				{
					outref = (*curDCtlHndl)->dCtlRefNum;
					alreadyOpen++;
				}
			}
		}
	}
	if(alreadyOpen == 2)
	{
		if(PGFAlert("Serial port is already open, try to reset it?", 1))
		{
			::CloseDriver(inref);
			::CloseDriver(outref);
			alreadyOpen = 0;
		}
	}

	if(!alreadyOpen && (mSPort >= 0) &&
			!(*result = ::OpenDriver(sSerialPorts[mSPort].inName, &mInRef)) &&
			!(*result = ::OpenDriver(sSerialPorts[mSPort].outName, &mOutRef)))
	{
		pgp_memcpy(&mSerOpts, serOpt, sizeof(SerialOptions));
		SetState(_cs_none);
		mLastRingTime = 0;
		mSerBuf = (char *) pgp_malloc(SERBUFSIZE);
		pgpAssert(mSerBuf);
		::SerSetBuf(mInRef, mSerBuf, SERBUFSIZE);
		if(!sSerialCompProc)
			sSerialCompProc=NewIOCompletionProc(SerialAsyncCompletion);
		mOutputDevice = 0;
		/*
		//The following code is intended to search the list of sound output
		//devices to facilitate playing the ring out of the speaker while
		//headphones are plugged in.  Looks like the 1710AV monitor makes
		//this a total nightmare by eliminating the published API and
		//using its own.  For now, I'll just leave this dormant until
		//a miracle occurs.
		
		compInx = 0;
		compName = (StringHandle)NewHandle(0);
		do
		{
			compDesc.componentType = kSoundOutputDeviceType;
			compDesc.componentSubType = 0;
			compDesc.componentManufacturer = 0;
			compDesc.componentFlags = 0;
			compDesc.componentFlagsMask = 0;
			compInx = FindNextComponent(compInx, &compDesc);
			GetComponentInfo(compInx, &compDesc, (Handle)compName, NIL, NIL);
			mOutputDevice = compDesc.componentSubType;
		} while(compInx);
		DisposeHandle((Handle)compName);
		*/
	}
	else if(!(*result))
		*result = _pge_PortNotAvail;
	if(*result)
		PGFAlert("Could not open serial port!", 0);
}

CPFTSerial::~CPFTSerial()
{
	AbortSync();
	mTMutex->Wait(semaphore_WaitForever);
	if(mState == _cs_connected)
		Disconnect();
	if(mSerBuf)
	{
		::KillIO(mInRef);
		::KillIO(mOutRef);
		::SerSetBuf(mInRef, NIL, 0);
		::CloseDriver(mInRef);
		::CloseDriver(mOutRef);
		pgp_free(mSerBuf);
	}
}

PGErr
CPFTSerial::Connect(ContactEntry *con, short *connectResult)
{
	short reply=_cr_NoReply, x;
	OSErr result=0;
	char s[256], t[256], number[64], *p;
	LThread *thread;
	
	mTMutex->Wait(semaphore_WaitForever);
	SetState(_cs_connecting);
	thread = LThread::GetCurrentThread();
	*connectResult=0;
	if(con->modemInit[0])
	{
		for(short retries = 3; reply != _cr_OK && retries ;retries--)
		{
			Write("AT%s\r", con->modemInit);
			reply = GetModemResult(1000*5);
		}
		if(reply != _cr_OK)
		{
			*connectResult=reply;
			result = _pge_ModemNotAvail;
			PGFAlert("Modem is not responding!", 0);
			goto done;
		}
	}
	if(con->useDialInfo)
	{
		x=0;
		strcpy(t,con->phoneNumber);
		for(p=t;*p && x<63;p++)
			if(*p!=' ' && *p!='-' && *p!='(' && *p!=')')
				number[x++]=*p;
		number[x]=0;
		if(number[0]!=gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].areaCode[1] ||
		   number[1]!=gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].areaCode[2] ||
		   number[2]!=gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].areaCode[3])
			x=2;
		else if(con->nonLocal)
			x=1;
		else
			x=0;
		strcpy(s, gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].catBefore[x]);
		strcat(s, number);
		strcat(s, gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].catAfter[x]);
	}
	else
		strcpy(s, con->phoneNumber);
	CStatusPane::GetStatusPane()->AddStatus(0, "Contacting %s...", s);
	strcpy(t,"ATD ");
	t[3] = gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].usePulseDial ? 'P':'T';
	strcat(t,s);
	Write("%s\r", t);
	reply = GetModemResult(1000L*80L);
	if(mAbort)
		Write("\r");
	*connectResult=reply;
	if(!(reply == _cr_Connect))
	{
		if(gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].redialDelay)
			thread->Sleep(gPGFOpts.dopt.dialInfo[gPGFOpts.dopt.curDialSet].redialDelay);
		CStatusPane::GetStatusPane()->AddStatus(0, "Connection failed.");
		SetState(_cs_none);
	}
	else
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Connected %s.", mConnectString);
		SetState(_cs_connected);
	}
done:
	mTMutex->Signal();
	return result;
}

#define CheckModemResponse(strP, num)	\
		if(!strP ## Str || ch!=*strP ## Str) strP ## Str=NIL;	\
		else if(!*++strP ## Str) response=num;

short
CPFTSerial::GetModemResult(long timeout)
{
	char *okStr=NIL, *noCarrierStr=NIL, *noAnswerStr=NIL, *busyStr=NIL;
	char *noDialtoneStr=NIL, *connectStr=NIL, *errorStr=NIL;
	uchar *p, ch;
	long count, outOfTime;
	short response = _cr_Timeout, i, state=0, csLen;
	
	outOfTime = pgp_getticks() + timeout;
	while((response == _cr_Timeout || state==1) && !mAbort && (!timeout || pgp_getticks() < outOfTime))
	{
		LThread::Yield();
		if(Read(NIL, 0, NIL))
		{
			if(mIndex > mOutdex)
				count=mIndex-mOutdex;
			else
				count=INCBUFSIZE-mOutdex;
			//DoOutputData(&mInc[mOutdex],count,0);	// for debugging modem i/o
			p = &mInc[mOutdex];
			if(!state)
			{
				for(i=0;i<count && response == _cr_Timeout;i++, p++)
				{
					ch=(*p & 0x7F);
					if(ch == '\r' || ch== '\n')
					{
						okStr="OK";
						noCarrierStr="NO CARRIER";
						noAnswerStr="NO ANSWER";
						busyStr="BUSY";
						noDialtoneStr="NO DIAL";
						connectStr="CONNECT";
						errorStr="ERROR";
					}
					else
					{
						CheckModemResponse(connect, 	_cr_Connect);
						CheckModemResponse(ok, 			_cr_OK);
						CheckModemResponse(noCarrier, 	_cr_NoCarrier);
						CheckModemResponse(noDialtone, 	_cr_NoDialTone);
						CheckModemResponse(noAnswer, 	_cr_NoAnswer);
						CheckModemResponse(busy, 		_cr_Busy);
						CheckModemResponse(error, 		_cr_Error);
					}
				}
				if(response == _cr_Connect)
				{
					state++;
					csLen=0;
					goto getConSuffix;
				}
			}
			else
			{
				i=0;
			getConSuffix:
				for(;i<count && *p != '\r';i++,p++)
					if(csLen<CONNECTSTRINGLEN-1)
						mConnectString[csLen++] = *p;
				if((*p=='\r') || (csLen==CONNECTSTRINGLEN-1))
				{
					mConnectString[csLen]=0;
					state++;
				}
			}
			mOutdex+=count;
			mOutdex%=INCBUFSIZE;
		}
	}
	return response;
}

PGErr
CPFTSerial::Disconnect()
{
	OSErr result=0;
	LThread *thread;
	short reply;
	
	mTMutex->Wait(semaphore_WaitForever);
	if(mState == _cs_connected)
	{
		SetState(_cs_disconnecting);
		::KillIO(mOutRef);
		(thread=LThread::GetCurrentThread())->SetupAsynchronousResume(&mPB);
		mPB.ioPB.F.cntrlParam.ioCRefNum = mInRef;
		mPB.ioPB.F.cntrlParam.csCode = 18;
		PBControlAsync(&mPB.ioPB.F);		/* turn off DTR */
		result = thread->SuspendUntilAsyncResume(&mPB, noErr);
		thread->Sleep(1100);				/* for a little more than */
		mPB.ioPB.F.cntrlParam.csCode = 17;	/* the 1 seconds Hayes guard time */
		PBControlAsync(&mPB.ioPB.F);		/* now turn it back on */
		result = thread->SuspendUntilAsyncResume(&mPB, noErr);
		for(short retries = 4;retries && !mAbort;retries--)
		{
			Write("+++");
			reply = GetModemResult(2*1000);	/* wait 2 seconds for an OK */
			Write("ATH0\r");				/* Hayes AT hangup, universal to all modems */
			reply = GetModemResult(4*1000);
			if(reply == _cr_OK)
				break;
		}
	}
	SetState(_cs_none);
	mTMutex->Signal();
	return result;
}

short
CPFTSerial::WaitForRing()
{
	char *ringStr=NIL;
	uchar *p, ch;
	long count;
	short response = _cr_Timeout, i;
	LThread *thread;
	
	thread = LThread::GetCurrentThread();
	while(response == _cr_Timeout && !mAbort && !mAnswer)
	{
		if((mState == _cs_calldetected) && (mLastRingTime + (8 * 1000) < pgp_getticks()))
		{
			// last ring was more than 8 seconds ago, so abort call detected state
			SetState(_cs_listening);
		}
		if(Read(NIL, 0, NIL))
		{
			if(mIndex>mOutdex)
				count=mIndex-mOutdex;
			else
				count=INCBUFSIZE-mOutdex;
			//DoOutputData(&mInc[mOutdex],count,0);	/* for debugging i/o */
			p = &mInc[mOutdex];
			for(i=0;i<count && response == _cr_Timeout;i++)
			{
				ch=(*p & 0x7F);
				if(ch == '\r' || ch == '\n')
					ringStr = "RING";
				else
					CheckModemResponse(ring, _cr_Ring);
				p++;
			}
			mOutdex += count;
			mOutdex %= INCBUFSIZE;
		}
		thread->Yield();
	}
	return response;
}

PGErr
CPFTSerial::Listen(Boolean answer)
{
	short result=0, reply=_cr_NoReply;
	SndListHandle ringSound = NIL;
	SndChannelPtr ringSndChannel = NIL;

	mTMutex->Wait(semaphore_WaitForever);
	if(answer)
		mAnswer = TRUE;
	else
		SetState(_cs_listening);
	while(!mAbort)
	{
		if((mAnswer || (WaitForRing() == _cr_Ring)) && !mAbort)
		{
			if(mAnswer)
			{
				SetState(_cs_connecting);
				Write("ATA\r");		/* answer the call, universal AT command */
				reply = GetModemResult(60L*1000L);
				if(reply == _cr_Connect)
				{
					CStatusPane::GetStatusPane()->AddStatus(0, "Connected %s.",
															mConnectString);
					SetState(_cs_connected);
					break;
				}
				else
					Write("\r");	/* abort the modem connecting */
			}
			else
			{
				if(mState != _cs_calldetected)
					SetState(_cs_calldetected);
				mLastRingTime = pgp_getticks();
				CStatusPane::GetStatusPane()->AddStatus(0, "...Ring...");
				if(ringSound = (SndListHandle)GetNamedResource('snd ', "\pRing"))
				{
					HLock((Handle)ringSound);
					if(!ringSndChannel)
					{
						if(mOutputDevice)
							SndNewChannel(&ringSndChannel, kUseOptionalOutputDevice,
											mOutputDevice, NIL);
						else
							SndNewChannel(&ringSndChannel, 0, 0, NIL);
					}
					SndPlay(ringSndChannel, ringSound, 1);	/* ring the phone */
				}
			}
		}
	}
	if(ringSound)
		HUnlock((Handle)ringSound);
	if(ringSndChannel)
		SndDisposeChannel(ringSndChannel, 1);
	if(!mAnswer && mAbort)
		result = _pge_InternalAbort;
	mAnswer = FALSE;
	mTMutex->Signal();
	return result;
}

/* Resets the port parameters including handshaking, baud rate, stop bits, etc...
	Also sends the modem init string and checks for a proper reply */

PGErr
CPFTSerial::Reset()
{
	ushort baudRate;
	long baudRate1;
	SerShk shk;
	//SerStaRec sta;
	OSErr result=0;
	short reply, inx;

	mTMutex->Wait(semaphore_WaitForever);
	SetState(_cs_initializing);
	::KillIO(mOutRef);
	::KillIO(mInRef);
	result = ::SerReset(mInRef, baud19200 | (mSerOpts.frameType << 10));
	pgpAssertNoErr(result);
	baudRate = baudRate1 = atoi(mSerOpts.baud);
	result = ::Control(mInRef, 13, &baudRate);
	shk.fXOn = !!(mSerOpts.handshaking & 2);
	shk.fCTS = !!(mSerOpts.handshaking & 8);
	shk.xOn = 17;
	shk.xOff = 19;
	shk.errs = 0;
	shk.evts = 0;
	shk.fInX = !!(mSerOpts.handshaking & 1);
	shk.fDTR = !!(mSerOpts.handshaking & 4);
	result = ::Control(mInRef, 14, (Ptr)&shk);
	pgpAssertNoErr(result);
	mAbort = FALSE;
	/*SerStatus(mInRef, &sta);
	if(sta.ctsHold)
		result = _pge_ModemNotAvail;
	else*/
	{
		for(inx = 0; inx < 5 && reply != _cr_OK ; inx++)
		{
			Write("AT%s\r", gPGFOpts.sopt.modemInit);	/* send the modem init string */
			reply = GetModemResult(5L*1000L);			/* wait 6 seconds for a reply */
		}												/* try it three times */
		if(reply != _cr_OK)
			result = _pge_ModemNotAvail;
		else	/* make sure next command is not too soon for modem */
			LThread::GetCurrentThread()->Sleep(350);
	}
	SetState(_cs_none);
	mTMutex->Signal();
	if(result)
		PGFAlert("Modem is not responding!", 0);
	return result;
}

PGErr
CPFTSerial::Flush()
{
	::KillIO(mOutRef);
	::KillIO(mInRef);
	return 0;
}

/*	all machine dependent code for reading data from the port
	is in this function.  max is the number of bytes available
	in the data buffer.  Returns the number of bytes placed into
	the buffer.  The function can also be used as a query if
	data is NIL and max is 0 to return the total number of bytes
	available. */

long
CPFTSerial::Read(void *data, long max, short *channel)
{
	LThread *thread;
	OSErr result;
	long t, count;
	
	if(channel)
		*channel = _pfc_Control;	// everything is on control channel for serial
	thread = LThread::GetCurrentThread();
	/* load up our internal buffers */
	mReadPB.ioPB.F.cntrlParam.ioCRefNum = mInRef;
	mReadPB.ioPB.F.cntrlParam.csCode = 2;
	PBStatusImmed(&mReadPB.ioPB.F);
	if(count = (long)mReadPB.ioPB.F.cntrlParam.csParam[1])
	{
		if(count > INCBUFSIZE - mIndex)
			count = INCBUFSIZE - mIndex;
		thread->SetupAsynchronousResume(&mReadPB);
		mReadPB.ioPB.F.ioParam.ioBuffer=(Ptr)&mInc[mIndex];
		mReadPB.ioPB.F.ioParam.ioReqCount=count;
		mReadPB.ioPB.F.ioParam.ioPosMode=fsAtMark;
		mReadPB.ioPB.F.ioParam.ioPosOffset=0;
		PBReadAsync(&mReadPB.ioPB.F);
		result = thread->SuspendUntilAsyncResume(&mReadPB, noErr);
		mIndex += count;
		mIndex %= INCBUFSIZE;
	}
	/* is there data in our internal buffers? */
	if(mOutdex != mIndex)
	{
		if(mIndex > mOutdex)
			t = mIndex - mOutdex;
		else
			t = INCBUFSIZE - mOutdex;
	}
	else
		t = 0;
	if(t && data && max)
	{
		t = minl(t, max);
		pgp_memcpy(data, &mInc[mOutdex], t);
		mOutdex += t;
		mOutdex %= INCBUFSIZE;
	}
	else if(data && !max)
		t = 0;
	return t;
}

/*	The real meat for writing to the modem on the Mac */

PGErr
CPFTSerial::WriteBlock(void *buffer, long *count, short /*channel*/)
{
	OSErr result;
	LThread *thread;
	
	mTMutex->Wait(semaphore_WaitForever);
	thread = LThread::GetCurrentThread();
	mPB.ioPB.F.ioParam.ioRefNum = mOutRef;
	mPB.ioPB.F.ioParam.ioBuffer = (Ptr)buffer;
	mPB.ioPB.F.ioParam.ioReqCount = *count;
	mPB.ioPB.F.ioParam.ioPosMode = fsAtMark;
	mPB.ioPB.F.ioParam.ioPosOffset = 0;
	
	thread->SetupAsynchronousResume(&mPB);
	PBWriteAsync(&mPB.ioPB.F);
	result = thread->SuspendUntilAsyncResume(&mPB, noErr);

	*count = mPB.ioPB.F.ioParam.ioActCount;
	mTMutex->Signal();
	return result;
}

/*	Same thing, but this time asynchronous */

PGErr
CPFTSerial::WriteAsync(long count, short /*channel*/, AsyncTransport *async)
{
	OSErr result = 0;
	
	async->u.serial.ioParam.ioResult = 0;
	async->u.serial.ioParam.ioCompletion = NIL;
	async->u.serial.ioParam.ioRefNum = mOutRef;
	async->u.serial.ioParam.ioBuffer=(Ptr)async->buffer;
	async->u.serial.ioParam.ioReqCount=count;
	async->u.serial.ioParam.ioPosMode=fsAtMark;
	async->u.serial.ioParam.ioPosOffset=0;
	result = PBWriteAsync(&async->u.serial);
	LThread::Yield();
	return result;
}

void
CPFTSerial::WaitAsync(AsyncTransport *asyncTrans)
{
	while(asyncTrans->u.serial.ioParam.ioResult == 1)
		LThread::Yield();
	CPFTransport::WaitAsync(asyncTrans);
}

/*	Mac specific routine for doing Communications Toolbox port lookup
	to find out what serial ports are available. */

void
CPFTSerial::FindDevices()
{
	CRMRecPtr crm;
	CRMRec crit;
	CRMSerialPtr serial;
	short lastID=0;
	
	sNumSerialPorts=0;
	if(::InitCRM())
	{
		PGFAlert("PGPFone requires System 7.1.", 0);
		::ExitToShell();
	}
	::InitCTBUtilities();
	::InitCM();
	while(1)
	{
		crit.crmDeviceType=crmSerialDevice;
		crit.crmDeviceID=lastID;
		if(!(crm = ::CRMSearch(&crit)))
			break;
		lastID=crm->crmDeviceID;
		if(crm->crmDeviceType!=crmSerialDevice)
			continue;
		serial = (CRMSerialPtr)crm->crmAttributes;
		if(sNumSerialPorts>=MAXSERPORTS)
		{
			pgp_errstring("Too many serial ports.");
			break;
		}
		pstrcpy(sSerialPorts[sNumSerialPorts].name,*serial->name);
		pstrcpy(sSerialPorts[sNumSerialPorts].inName,*serial->inputDriverName);
		pstrcpy(sSerialPorts[sNumSerialPorts].outName,*serial->outputDriverName);
		sSerialPorts[sNumSerialPorts].inUse=0;
		sSerialPorts[sNumSerialPorts].deviceIcon=serial->deviceIcon;
		sNumSerialPorts++;
	}
}

/* The following 2 routines allow other objects such as CPFPrefDialog to
	interrogate this object regarding Macintosh serial ports */

CRMIconHandle
CPFTSerial::GetDeviceIcon(short index)
{
	return sSerialPorts[index].deviceIcon;
}

uchar *
CPFTSerial::GetDeviceName(short index)
{
	return sSerialPorts[index].name;
}

