/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFDirectoryWindow.h,v 1.5 1999/03/10 02:35:25 heller Exp $
____________________________________________________________________________*/
#pragma once

#include <LWindow.h>
#include <LListener.h>

#include "PGPfoneUtils.h"

class CDirTable;
class LPushButton;

typedef struct DirectoryEntry
{
	enum ContactMethods 	connection;
	uchar					name[32],
							address[64];
} DirectoryEntry;

class CPFDirectoryWindow	:	public LWindow,
								public LListener
{
public:
	enum { class_ID = 'wDir' };
								CPFDirectoryWindow();
								CPFDirectoryWindow(LStream *inStream);
								~CPFDirectoryWindow();
	static CPFDirectoryWindow*	CreateDirectoryWindowStream(LStream *inStream);
	void						ListenToMessage(MessageT inMessage, void *ioParam);
	void						FinishCreateSelf();
	void						DirectoryDiskOp(Boolean save);
	void						AddEntry(
										uchar				*name,
										uchar				*address,
										enum ContactMethods	connection);
	Boolean						HandleKeyPress(
										const EventRecord&	inKeyEvent);
	void						CancelEntry();
	void						Call(Boolean simulateButton);
private:
	CDirTable					*mDirTable;
	DirectoryEntry				*mEntries;
	long						mNumEntries,
								mEditing;
	LPushButton					*mCallButton;
};

