Attribute VB_Name = "modVBDemo"
Option Explicit

' Keyring Types:
Global Const KEYSEL_PUBLIC = 1
Global Const KEYSEL_PRIVATE = 2
Global Const KEYSEL_GROUP = 3

' Show or Hide goups or expired, disabled, or revoked keys
Global Const KEYSEL_SHOW_GROUPS = &H100
Global Const KEYSEL_SHOW_EXP = &H200
Global Const KEYSEL_SHOW_DIS = &H400
Global Const KEYSEL_SHOW_REV = &H800
Global Const KEYSEL_KEY_LIST = &H1000

' Identify the shared button to use
Global Const KEYSEL_GROUP_DEF = 1
Global Const KEYSEL_COPYTO_DEFKEYRING = 2
Global Const KEYSEL_CHECK_ENTIRE_KEYRING = 3
Global Const KEYSEL_DISABLE_SHARED_BUTTONS = 4

Global Const KEYS_OLD = 1   ' Tradional PGP RSA Keys
Global Const KEYS_ENCR = 2  ' New style PGP Encryption-only keys
Global Const KEYS_SIGN = 4  ' New style PGP Signature-only keys

Global Const INCLUDE_ONLYUSERIDS = 1
Global Const INCLUDE_ONLYKEYIDS = 2
Global Const INCLUDE_BOTH = 3

Declare Function SimplePGPKeySel Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal Caption As String, ByVal AllowMultSel As Long, ByVal KeyRingType As Long, ByVal SelectedList As String, ByVal SelectedListLength As Long, SelectedCount As Long, ByVal IncludeWhat As Long, ByVal UidKid As String, ByVal KeyType As Long, ByVal CAKey As String, ByVal ShowKeyDetails As Long, ByVal DisplayType As Long, ByVal SharedButtonID As Long, ByVal KeyRingName As String) As Long

Declare Function SimplePGPEncryptFile Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputFileName As String, ByVal OutputFileName As String, ByVal SignIt As Long, ByVal Wipe As Long, ByVal Armor As Long, ByVal TextMode As Long, ByVal IDEAOnly As Long, ByVal UseUntrustedKeys As Long, ByVal RecipientList As String, ByVal SignerKeyID As String, ByVal SignerBufferLen As Long, ByVal SignerPassphrase As String, ByVal SignerPwdBufferLen As Long, ByVal IDEAPassphrase As String, ByVal IDEAPwdBufferLen As Long, ByVal PublicKeyRingName As String, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPEncryptBuffer Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputBuffer As String, ByVal InputBufferLen As Long, ByVal InputBufferName As String, ByVal OutputBuffer As String, pOutputBufferLen As Long, ByVal SignIt As Long, ByVal Armor As Long, ByVal TextMode As Long, ByVal IDEAOnly As Long, ByVal UseUntrustedKeys As Long, ByVal RecipientList As String, ByVal SignerKeyID As String, ByVal SignerBufferLen As Long, ByVal SignerPassphrase As String, ByVal SignerPwdBufferLen As Long, ByVal IDEAPassphrase As String, ByVal IDEAPwdBufferLen As Long, ByVal PublicKeyRingName As String, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPSignFile Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputFileName As String, ByVal OutputFileName As String, ByVal Armor As Long, ByVal TextMode As Long, ByVal SignatureOnly As Long, ByVal ClearSign As Long, ByVal SignerKeyID As String, ByVal SignerBufferLen As Long, ByVal SignerPassphrase As String, ByVal SignerPwdBufferLen As Long, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPSignBuffer Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputBuffer As String, ByVal InputBufferLen As Long, ByVal InputBufferName As String, ByVal OutputBuffer As String, pOutputBufferLen As Long, ByVal Armor As Long, ByVal TextMode As Long, ByVal SignatureOnly As Long, ByVal ClearSign As Long, ByVal SignerKeyID As String, ByVal SignerBufferLen As Long, ByVal SignerPassphrase As String, ByVal SignerPwdBufferLen As Long, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPVerifyDetachedSignatureFile Lib "smplpgp_32.dll" (ByVal hWnd1 As Long, ByVal InputDataFileName As String, ByVal InputSignatureFileName As String, SignatureStatus As Long, ByVal Signer As String, ByVal SignerBufLen As Long, ByVal SignDate As String, ByVal SignDateBufLen As Long, ByVal PublicKeyRingName As String) As Long

Declare Function SimplePGPVerifyDetachedSignatureBuffer Lib "smplpgp_32.dll" (ByVal hWnd1 As Long, ByVal InputDataBuffer As String, ByVal InputDataBufferLen As Long, ByVal InputSignatureBuffer As String, ByVal InputSignatureBufferLen As Long, SignatureStatus As Long, ByVal Signer As String, ByVal SignerBufLen As Long, ByVal SignDate As String, ByVal SignDateBufLen As Long, ByVal PublicKeyRingName As String) As Long
                                                                                        
Declare Function SimplePGPReceiveFile Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputFileName As String, ByVal OutputFileName As String, ByVal DecryptPassphrase As String, ByVal DecryptPwdBufferLen As Long, SignatureStatus As Long, ByVal Signer As String, ByVal SignerBufLen As Long, ByVal SignDate As String, ByVal SignDateBufLen As Long, ByVal PublicKeyRingName As String, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPReceiveBuffer Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputBuffer As String, ByVal InputBufferLen As Long, ByVal InputBufferName As String, ByVal OutputBuffer As String, pOutputBufferLen As Long, ByVal DecryptPassphrase As String, ByVal DecryptPwdBufferLen As Long, SignatureStatus As Long, ByVal Signer As String, ByVal SignerBufLen As Long, ByVal SignDate As String, ByVal SignDateBufLen As Long, ByVal PublicKeyRingName As String, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPGenerateKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal UserID As String, ByVal KeyLength As Long, ByVal KeyType As Long, ByVal ValidDays As Long, ByVal Passphrase As String, ByVal PwdBufferLen As Long, ByVal PublicKeyRingName As String, ByVal PrivateKeyRingName As String, ByVal GeneratedKeyID As String) As Long

Declare Function SimplePGPExtractKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal UserIDKeyID As String, ByVal OutputFileName As String, ByVal KeyRingName As String) As Long

Declare Function SimplePGPAddKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal InputFileName As String, ByVal KeyRingName As String) As Long

Declare Function SimplePGPOpenPublicKeyRing Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal PublicKeyRingName As String) As Long

Declare Function SimplePGPGetNextPublicKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal UserID As String, ByVal KeyID As String, KeyLength As Long, ByVal CreationDate As String, ByVal ExpirationDate As String, ValidDays As Long, KeyType As Long, ByVal KeyTypeES As String, ByVal KeyState As String) As Long

Declare Function SimplePGPClosePublicKeyRing Lib "smplpgp_32.dll" (ByVal hwnd As Long) As Long

Declare Function SimplePGPOpenPrivateKeyRing Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPGetNextPrivateKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal UserID As String, ByVal KeyID As String, KeyLength As Long, ByVal CreationDate As String, ByVal ExpirationDate As String, ValidDays As Long, KeyType As Long, ByVal KeyTypeES As String, ByVal KeyState As String) As Long

Declare Function SimplePGPClosePrivateKeyRing Lib "smplpgp_32.dll" (ByVal hwnd As Long) As Long

Declare Function SimplePGPWipeFile Lib "smplpgp_32.dll" (ByVal FileName As String) As Long

Declare Function SimplePGPRemoveKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal UserIDKeyID As String, ByVal KeyRingName As String) As Long

Declare Function SimplePGPCertifyPublicKey Lib "smplpgp_32.dll" (ByVal hwnd As Long, ByVal PublicKeyToCertify As String, ByVal SignerKeyID As String, ByVal SignerBufferLen As Long, ByVal SignerPassphrase As String, ByVal SignerPwdBufferLen As Long, ByVal PublicKeyRingName As String, ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPCountPublicKeys Lib "smplpgp_32.dll" (ByVal PublicKeyRingName As String) As Long

Declare Function SimplePGPCountPrivateKeys Lib "smplpgp_32.dll" (ByVal PrivateKeyRingName As String) As Long

Declare Function SimplePGPAnalyzeFile Lib "smplpgp_32.dll" (ByVal FileName As String) As Long

Declare Function SimplePGPAnalyzeBuffer Lib "smplpgp_32.dll" (ByVal Buffer As String, ByVal Length As Long) As Long

Declare Function SimplePGPGetVersion Lib "smplpgp_32.dll" (ByVal Buffer As String, ByVal Length As Long) As Long

' signature status codes
Global Const SIGSTS_NOTSIGNED = 1
Global Const SIGSTS_VERIFIED = 2
Global Const SIGSTS_NOTVERIFIED = 3
Global Const SIGSTS_BADSIG = 4
Global Const SIGSTS_VERIFIED_UNTRUSTED = 5

'***********************************************************
'
'        Simple PGP Return Codes
'
'        A zero return code always means no error.
'        Otherwise all Simple PGP return codes
'        have unique values.
'
'
'************************************************************
' PGP kernel return codes
Global Const KERNEL_EXIT_OK = 0
                                        
                                        ' for +batchmode, file without a
                                        ' valid signature - EXIT_OK_NOSIG
Global Const KERNEL_EXIT_OK_NOSIG = 1
Global Const KERNEL_FILE_NOT_FOUND_ERROR = 2
Global Const KERNEL_UNKNOWN_FILE_ERROR = 3
Global Const KERNEL_NO_BATCH = 4
Global Const KERNEL_BAD_ARG_ERROR = 5
Global Const KERNEL_INTERRUPT = 6
Global Const KERNEL_OUT_OF_MEM = 7
Global Const KERNEL_INVALID_FILE_OP_ERROR = 8

' Keyring errors: Base value = 10
Global Const KERNEL_KEYGEN_ERROR = 10
Global Const KERNEL_NONEXIST_KEY_ERROR = 11
Global Const KERNEL_KEYRING_ADD_ERROR = 12
Global Const KERNEL_KEYRING_EXTRACT_ERROR = 13
Global Const KERNEL_KEYRING_EDIT_ERROR = 14
Global Const KERNEL_KEYRING_VIEW_ERROR = 15
Global Const KERNEL_KEYRING_REMOVE_ERROR = 16
Global Const KERNEL_KEYRING_CHECK_ERROR = 17
Global Const KERNEL_KEY_SIGNATURE_ERROR = 18
Global Const KERNEL_KEYSIG_REMOVE_ERROR = 19

' Encode errors: Base value = 20
Global Const KERNEL_SIGNATURE_ERROR = 20
Global Const KERNEL_RSA_ENCR_ERROR = 21
Global Const KERNEL_ENCR_ERROR = 22
Global Const KERNEL_COMPRESS_ERROR = 23

' Decode errors: Base value = 30
Global Const KERNEL_SIGNATURE_CHECK_ERROR = 30
Global Const KERNEL_RSA_DECR_ERROR = 31
Global Const KERNEL_DECR_ERROR = 32
Global Const KERNEL_DECOMPRESS_ERROR = 33

' ViaCrypt-detected problems
                                        ' Unexpected conditions found
                                        ' (Use this code if no other code
                                        ' fits, and the conditions seem so
                                        ' wildly unlikely as to not need
                                        ' a unique exit code -
                                        ' expect the unexpected.)
Global Const KERNEL_EXIT_UNEXPECTED = 80
                                        ' Evaluation copy of executable
                                        ' expire date has passed.
Global Const KERNEL_EXIT_EXPIRED = 81

                                        ' -r pgpoutfile
                                        ' syntax or cannot open
Global Const KERNEL_EXIT_STDOUT_FAIL = 82
                                        ' @cmdfile or -@ cmdfile
                                        ' syntax or cannot open
Global Const KERNEL_EXIT_CMDFILE_OPEN = 83
                                        ' @cmdfile mem alloc failure
                                        ' arg list too big
                                        ' avail mem too small
                                        ' or ctrl value problem
Global Const KERNEL_EXIT_CMDFILE_MEM = 84
                                        ' @cmdfile unrecognized directive
Global Const KERNEL_EXIT_CMDFILE_UNREC = 85
                                        ' OK exit status, non-zero value
                                        ' used with setjmp()/longjmp()
                                        ' to resume pgp_cmd_ln()/main()
Global Const KERNEL_EXIT_OK_NZ = 86
                                        ' Problem with kbhit()
                                        ' simulation - raw terminal IO
Global Const KERNEL_EXIT_TERM_IO = 87
                                        ' Attempt to create session with
                                        ' cryptographic engine - failed
Global Const KERNEL_NO_CRYPT_ENGINE = 88
Global Const KERNEL_VERSION_MISMATCH = 90
Global Const KERNEL_CANCEL_ON_BUSY = 91

Global Const KERNEL_EXIT_CODE_NOT_WRITTEN = 100

' keysel return codes
Global Const KEYSEL_OK = 0
Global Const KEYSEL_LOCKED = 201
Global Const KEYSEL_BADKEYRINGTYPE = 202 ' The KeyRingType argument is invalid
Global Const KEYSEL_BADKEYTYPE = 203
Global Const KEYSEL_NOKEYRINGNAME = 204
Global Const KEYSEL_USERABORT = 205
Global Const KEYSEL_NOPGPPATH = 206      ' No PGPPATH env variable set
Global Const KEYSEL_OPENFAILED = 207     ' fopen of keyring failed
Global Const KEYSEL_EOF = 208            ' End-Of-File in keyring encountered
Global Const KEYSEL_BADCTBLENOFLEN = 209 ' Unexpected CTB length-of-length code
                                         ' in ringfile.  Possible keyring corruption
Global Const KEYSEL_READFAILURE = 210    ' fread of ringfile failed unexpectedly
Global Const KEYSEL_BADUIDLEN = 211      ' User ID longer than 255 (bad!)
Global Const KEYSEL_UIDTOOLONG = 212     ' the length of the userid is longer
                                         ' than the size of the userid element
                                         ' of the pgpkey struct.
Global Const KEYSEL_BADCREATIONDATE = 213 ' Creation date in key is 0
Global Const KEYSEL_UNKNOWNUID = 214
Global Const KEYSEL_NOMEMORY = 215    ' malloc failed
Global Const KEYSEL_BADPKT = 216      ' unexpected for malformed packet found
Global Const KEYSEL_BADPOINTER = 217  ' one of the pointer args to KeySel is invalid
Global Const KEYSEL_USEIDEAONLY = 218
Global Const KEYSEL_CANCEL_ON_BUSY = 219

Global Const KEYSEL_UNKNOWN = 225

' Simple PGP function return codes
Global Const SP_KEYSEL_KEYLIBOK = 0
Global Const SP_KEYSEL_USEIDEAONLY = 301
Global Const SP_KEYSEL_CANCEL = 302
Global Const SP_KEYSEL_NULLCAPTIONSTRPOINTER = 303
Global Const SP_KEYSEL_EMPTYCAPTIONSTR = 304
Global Const SP_KEYSEL_KEYRINGTYPENOTPUBLICORSECRET = 305
Global Const SP_KEYSEL_NULPTRTOSELECTEDLIST = 306
Global Const SP_KEYSEL_SELECTEDLISTLENGTHTOOSMALL = 307
Global Const SP_KEYSEL_NULPTRTOSELECTEDLISTCOUNT = 308
Global Const SP_KEYSEL_BADINCLUDEWHATVALUE = 309
Global Const SP_KEYSEL_NULPTRTOUIDKIDSEARCHSTR = 310
Global Const SP_KEYSEL_BADKEYTYPEBITMAP = 311
Global Const SP_KEYSEL_BADDISPLAYTYPEBITMAP = 312
Global Const SP_KEYSEL_BADSHAREDBUTTONIDBITMAP = 313

Global Const SP_ENCFIL_OK = 0
Global Const SP_ENCFIL_NULPTRTOINPUTFILENAME = 401
Global Const SP_ENCFIL_EMPTYINPUTFILENAMESTR = 402
Global Const SP_ENCFIL_INPUTFILEDOESNOTEXIST = 403
Global Const SP_ENCFIL_NULPTRTOOUTPUTFILENAME = 404
Global Const SP_ENCFIL_EMPTYOUTPUTFILENAMESTR = 405
Global Const SP_ENCFIL_NULPTRTORCPTLST = 406
Global Const SP_ENCFIL_EMPTYRCPTLSTSTR = 407
Global Const SP_ENCFIL_RCPTLSTDOESNOTENDWITHNEWLINE = 408
Global Const SP_ENCFIL_RCPTLSTDNSWITHCODCHR = 409
Global Const SP_ENCFIL_NULPTRTOSIGNERKEYIDSTR = 410
Global Const SP_ENCFIL_NULPTRTOSIGNERPASSPHRASESTR = 411
Global Const SP_ENCFIL_NULPTRTOIDEAPASSPHRASESTR = 412
Global Const SP_ENCFIL_NOTENUFMEM4INPUTSTRUCT = 413
Global Const SP_ENCFIL_NOTENUFMEM4OUTPUTSTRUCT = 414
Global Const SP_ENCFIL_KEYSELCANCEL = 415
Global Const SP_ENCFIL_SIGNERPWDBUFFERTOOSMALL = 416
Global Const SP_ENCFIL_IDEAPWDBUFFERTOOSMALL = 417

Global Const SP_READRCPTLST_OK = 0
Global Const SP_READRCPTLST_NULPTROREMPTYLIST = 501
Global Const SP_READRCPTLST_LISTDNSWITHCODCHR = 502
Global Const SP_READRCPTLST_AUSERIDSTRISTOOLONG = 503
Global Const SP_READRCPTLST_OUTOFMEMORYFORUSERIDLIST = 504
Global Const SP_READRCPTLST_AKEYIDSTRISTOOLONG = 505
Global Const SP_READRCPTLST_OUTOFMEMORYFORKEYIDLIST = 506

Global Const SP_ENCBUF_NULPTRTOINPUTBUFFER = 601
Global Const SP_ENCBUF_INPUTBUFLENISZERO = 602
Global Const SP_ENCBUF_NULPTRTOOUTPUTBUFFER = 603
Global Const SP_ENCBUF_NULPTRTORCPTLST = 604
Global Const SP_ENCBUF_EMPTYRCPTLSTSTR = 605
Global Const SP_ENCBUF_RCPTLSTDOESNOTENDWITHNEWLINE = 606
Global Const SP_ENCBUF_RCPTLSTDNSWITHCODCHR = 607
Global Const SP_ENCBUF_NULPTRTOSIGNERKEYIDSTR = 608
Global Const SP_ENCBUF_NULPTRTOSIGNERPASSPHRASESTR = 609
Global Const SP_ENCBUF_NULPTRTOIDEAPASSPHRASESTR = 610
Global Const SP_ENCBUF_NOTENUFMEM4INPUTSTRUCT = 611
Global Const SP_ENCBUF_NOTENUFMEM4OUTPUTSTRUCT = 612
Global Const SP_ENCBUF_KEYSELCANCEL = 613
Global Const SP_ENCBUF_SIGNERPWDBUFFERTOOSMALL = 614
Global Const SP_ENCBUF_IDEAPWDBUFFERTOOSMALL = 615
Global Const SP_ENCBUF_OUTPUTBUFFERTOOSMALL = 616

Global Const SP_SIGNFILE_NULPTRTOINPUTFILENAME = 701
Global Const SP_SIGNFILE_EMPTYINPUTFILENAMESTR = 702
Global Const SP_SIGNFILE_INPUTFILEDOESNOTEXIST = 703
Global Const SP_SIGNFILE_NULPTRTOOUTPUTFILENAME = 704
Global Const SP_SIGNFILE_EMPTYOUTPUTFILENAMESTR = 705
Global Const SP_SIGNFILE_NULPTRTOSIGNERKEYIDSTR = 706
Global Const SP_SIGNFILE_NULPTRTOSIGNERPASSPHRASESTR = 707
Global Const SP_SIGNFILE_NOTENUFMEM4INPUTSTRUCT = 708
Global Const SP_SIGNFILE_NOTENUFMEM4OUTPUTSTRUCT = 709
Global Const SP_SIGNFILE_KEYSELCANCEL = 710
Global Const SP_SIGNFILE_SIGNERPWDBUFFERTOOSMALL = 711

Global Const SP_SIGNBUFFER_NULPTRTOINPUTBUFFER = 801
Global Const SP_SIGNBUFFER_INPUTBUFLENISZERO = 802
Global Const SP_SIGNBUFFER_NULPTRTOOUTPUTBUFFER = 803
Global Const SP_SIGNBUFFER_NULPTRTOSIGNERKEYIDSTR = 804
Global Const SP_SIGNBUFFER_NULPTRTOSIGNRPASSPHRASESTR = 805
Global Const SP_SIGNBUFFER_NOTENUFMEM4INPUTSTRUCT = 806
Global Const SP_SIGNBUFFER_NOTENUFMEM4OUTPUTSTRUCT = 807
Global Const SP_SIGNBUFFER_KEYSELCANCEL = 808
Global Const SP_SIGNBUFFER_SIGNERPWDBUFFERTOOSMALL = 809
Global Const SP_SIGNBUFFER_OUTPUTBUFFERTOOSMALL = 810

Global Const SP_VERDETSIG_NULPTRTOINPUTDATAFILENAME = 901
Global Const SP_VERDETSIG_EMPTYINPUTDATAFILENAMESTR = 902
Global Const SP_VERDETSIG_INPUTDATAFILEDOESNOTEXIST = 903
Global Const SP_VERDETSIG_NULPTRTOINPUTSIGFILENAME = 904
Global Const SP_VERDETSIG_EMPTYINPUTSIGFILENAMESTR = 905
Global Const SP_VERDETSIG_INPUTSIGFILEDOESNOTEXIST = 906
Global Const SP_VERDETSIG_NULPTRTOSIGNATURESTATUS = 907
Global Const SP_VERDETSIG_NULPTRTOSIGNERSTR = 908
Global Const SP_VERDETSIG_SIGNERBUFLENGTHTOOSMALL = 909
Global Const SP_VERDETSIG_NULPTRTOSIGNDATE = 910
Global Const SP_VERDETSIG_SIGNDATEBUFLENGTHTOOSMALL = 911
Global Const SP_VERDETSIG_NOTENUFMEM4INPUTDATASTRUCT = 912
Global Const SP_VERDETSIG_NOTENUFMEM4INPUTSIGSTRUCT = 913

Global Const SP_VERDETSIGBUF_NULPTRTOINPUTDATABUFFER = 1001
Global Const SP_VERDETSIGBUF_INPUTDATABUFLENISZERO = 1002
Global Const SP_VERDETSIGBUF_NULPTRTOINPUTSIGBUFFER = 1003
Global Const SP_VERDETSIGBUF_INPUTSIGBUFLENISZERO = 1004
Global Const SP_VERDETSIGBUF_NULPTRTOSIGNATURESTATUS = 1005
Global Const SP_VERDETSIGBUF_NULPTRTOSIGNERSTR = 1006
Global Const SP_VERDETSIGBUF_SIGNERBUFLENGTHTOOSMALL = 1007
Global Const SP_VERDETSIGBUF_NULPTRTOSIGNDATE = 1008
Global Const SP_VERDETSIGBUF_SIGNDATEBUFLENTOOSMALL = 1009
Global Const SP_VERDETSIGBUF_NOTENUFMEM4INPUTDTASTRCT = 1010
Global Const SP_VERDETSIGBUF_NOTENUFMEM4INPUTSIGSTRCT = 1011

Global Const SP_RCVFIL_NULPTRTOINPUTFILENAME = 1101
Global Const SP_RCVFIL_EMPTYINPUTFILENAMESTR = 1102
Global Const SP_RCVFIL_INPUTFILEDOESNOTEXIST = 1103
Global Const SP_RCVFIL_NULPTRTOOUTPUTFILENAME = 1104
Global Const SP_RCVFIL_EMPTYOUTPUTFILENAMESTR = 1105
Global Const SP_RCVFIL_NULPTRTODECRYPTPASSPHRASE = 1106
Global Const SP_RCVFIL_NULPTRTOSIGNATURESTATUS = 1107
Global Const SP_RCVFIL_NULPTRTOSIGNERSTR = 1108
Global Const SP_RCVFIL_SIGNERBUFLENGTHTOOSMALL = 1109
Global Const SP_RCVFIL_NULPTRTOSIGNDATE = 1110
Global Const SP_RCVFIL_SIGNDATEBUFLENGTHTOOSMALL = 1111
Global Const SP_RCVFIL_NOTENUFMEM4INPUTSTRUCT = 1112
Global Const SP_RCVFIL_NOTENUFMEM4OUTPUTSTRUCT = 1113
Global Const SP_RCVFIL_DECRYPTPWDBUFFERTOOSMALL = 1114
Global Const SP_RCVFIL_ISKEY = 1115

Global Const SP_RCVBUF_NULPTRTOINPUTBUFFER = 1201
Global Const SP_RCVBUF_INPUTBUFLENISZERO = 1202
Global Const SP_RCVBUF_NULPTRTOOUTPUTBUFFER = 1203
Global Const SP_RCVBUF_NULPTRTODECRYPTPASSPHRASE = 1204
Global Const SP_RCVBUF_NULPTRTOSIGNATURESTATUS = 1205
Global Const SP_RCVBUF_NULPTRTOSIGNERSTR = 1206
Global Const SP_RCVBUF_SIGNERBUFLENGTHTOOSMALL = 1207
Global Const SP_RCVBUF_NULPTRTOSIGNDATE = 1208
Global Const SP_RCVBUF_SIGNDATEBUFLENGTHTOOSMALL = 1209
Global Const SP_RCVBUF_NOTENUFMEM4INPUTSTRUCT = 1210
Global Const SP_RCVBUF_NOTENUFMEM4OUTPUTSTRUCT = 1211
Global Const SP_RCVBUF_DECRYPTPWDBUFFERTOOSMALL = 1212
Global Const SP_RCVBUF_OUTPUTBUFFERTOOSMALL = 1213
Global Const SP_RCVBUF_ISKEY = 1214

Global Const SP_GENERATEKEY_FUNCTIONNOTENABLED = 1301
Global Const SP_GENERATEKEY_NULPTRTOUSEIDSTR = 1302
Global Const SP_GENERATEKEY_USERIDSTRISEMPTY = 1303
Global Const SP_GENERATEKEY_KEYLENGTHOUTOFRANGE = 1304
Global Const SP_GENERATEKEY_BADKEYTYPE = 1305
Global Const SP_GENERATEKEY_VALIDDAYSOUTOFRANGE = 1306
Global Const SP_GENERATEKEY_NULPTRTOPASSPHRASESTR = 1307
Global Const SP_GENERATEKEY_NULPTRTOGENKEYID = 1308
Global Const SP_GENERATEKEY_PWDBUFFERTOOSMALL = 1309

Global Const SP_EXTRACTKEY_FUNCTIONNOTENABLED = 1401
Global Const SP_EXTRACTKEY_NULPTRTOUIDKIDSTR = 1402
Global Const SP_EXTRACTKEY_UIDKIDSTRISEMPTY = 1403
Global Const SP_EXTRACTKEY_NULPTRTOOUTPUTFILENAME = 1404
Global Const SP_EXTRACTKEY_OUTPUTFILENAMESTRISEMPTY = 1405
Global Const SP_EXTRACTKEY_NOTENUFMEM4OUTPUTSTRUCT = 1406

Global Const SP_ADDKEY_FUNCTIONNOTENABLED = 1501
Global Const SP_ADDKEY_NULPTRTOINPUTFILENAME = 1502
Global Const SP_ADDKEY_INPUTFILENAMESTRISEMPTY = 1503
Global Const SP_ADDKEY_INPUTFILENAMEDOESNOTEXIST = 1504
Global Const SP_ADDKEY_NOTENUFMEM4INPUTSTRUCT = 1505

Global Const SP_REMOVEKEY_FUNCTIONNOTENABLED = 1601
Global Const SP_REMOVEKEY_NULPTRTOUIDKIDSTR = 1602
Global Const SP_REMOVEKEY_UIDKIDSTRISEMPTY = 1603

Global Const SP_CERTIFYKEY_FUNCTIONNOTENABLED = 1701
Global Const SP_CERTIFYKEY_NULPTRTOKEYTOCERTIFY = 1702
Global Const SP_CERTIFYKEY_KEYTOCERTIFYSTRISEMPTY = 1703
Global Const SP_CERTIFYKEY_NULPTRTOSIGNERSTR = 1704
Global Const SP_CERTIFYKEY_NULPTRTOPASSPHRASESTR = 1705
Global Const SP_CERTIFYKEY_KEYSELCANCEL = 1706
Global Const SP_CERTIFYKEY_SIGNERPWDBUFFERTOOSMALL = 1707

Global Const SP_OPENPUBKEYRING_OK = 0
Global Const SP_OPENPUBKEYRING_USERCANCELONTASKBUSY = 1801
Global Const SP_OPENPUBKEYRING_CANTOPENKEYRINGFILE = 1802

Global Const SP_GETNEXTPUBKEY_OK = 0
Global Const SP_GETNEXTPUBKEY_NULLUSERIDSTRPOINTER = 1801
Global Const SP_GETNEXTPUBKEY_NULLKEYIDSTRPOINTER = 1902
Global Const SP_GETNEXTPUBKEY_NULLKEYLENGTHPOINTER = 1903
Global Const SP_GETNEXTPUBKEY_NULLCREATIONDATEPOINTER = 1904
Global Const SP_GETNEXTPUBKEY_NULLEXPIRATIONDATEPTR = 1905
Global Const SP_GETNEXTPUBKEY_NULLVALIDDAYSPOINTER = 1906
Global Const SP_GETNEXTPUBKEY_NULLKEYTYPEPOINTER = 1907
Global Const SP_GETNEXTPUBKEY_NULLKEYTYPEESPOINTER = 1908
Global Const SP_GETNEXTPUBKEY_NULLKEYSTATEPOINTER = 1909

Global Const SP_CLOSEPUBKEYRING_OK = 0

Global Const SP_OPENPRIVKEYRING_OK = 0
Global Const SP_OPENPRIVKEYRING_USERCANCELONTASKBUSY = 2001
Global Const SP_OPENPRIVKEYRING_CANTOPENKEYRINGFILE = 2002

Global Const SP_GETNEXTPRIVKEY_OK = 0
Global Const SP_GETNEXTPRIVKEY_NULLUSERIDSTRPOINTER = 2101
Global Const SP_GETNEXTPRIVKEY_NULLKEYIDSTRPOINTER = 2102
Global Const SP_GETNEXTPRIVKEY_NULLKEYLENGTHPOINTER = 2103
Global Const SP_GETNEXTPRIVKEY_NULLCREATIONDATEPTR = 2104
Global Const SP_GETNEXTPRIVKEY_NULLEXPIRATIONDATEPTR = 2105
Global Const SP_GETNEXTPRIVKEY_NULLVALIDDAYSPOINTER = 2106
Global Const SP_GETNEXTPRIVKEY_NULLKEYTYPEPOINTER = 2107
Global Const SP_GETNEXTPRIVKEY_NULLKEYTYPEESPOINTER = 2108
Global Const SP_GETNEXTPRIVKEY_NULLKEYSTATEPOINTER = 2109

Global Const SP_CLOSEPRIVKEYRING_OK = 0

' analyze return codes
Global Const SIMPLEANALYZE_UNKNOWN = 0
Global Const SIMPLEANALYZE_ENCR = 1
Global Const SIMPLEANALYZE_SIGN = 2
Global Const SIMPLEANALYZE_KEY = 3
Global Const SIMPLEANALYZE_IOERROR = 4

Global Const SP_ANALYZEFILE_FILENAMEPOINTERISNULL = 2201
Global Const SP_ANALYZEFILE_FILENAMESTRISEMPTY = 2202
Global Const SP_ANALYZEFILE_FILENAMEDOESNOTEXIST = 2203

Global Const SP_ANALYZEBUFFER_BUFFERPOINTERISNULL = 2301
Global Const SP_ANALYZEBUFFER_BUFLENISZERO = 2302
Global Const SP_ANALYZEBUFFER_CANTOPENTEMPFILE = 2304
Global Const SP_ANALYZEBUFFER_ERRORWRITINGTEMPFILE = 2305

Global Const SP_WIPEFILE_OK = 0
Global Const SP_WIPEFILE_CANTOPENFILE = 2401
Global Const SP_WIPEFILE_CANTREMOVEFILE = 2402

Global Const SP_GETVERSION_OK = 0
Global Const SP_GETVERSION_BUFFERPOINTERISNULL = 2501
Global Const SP_GETVERSION_BUFFERTOOSMALL = 2502

Function MyOwnKeySel(sCaption, iKeyringType)
    frmKeySel.Caption = sCaption
    frmKeySel.lblKeyringType.Caption = iKeyringType

    frmKeySel.Show 1
    
    ' Organize results and return them
    
    ' If the first character of the selected
    ' item is a tab, then this item is an additional
    ' user ID
    Do While Left(frmKeySel.lstKeys.List(frmKeySel.lstKeys.ListIndex), 1) = Chr(9)
        ' We need to scan up to find the key ID
        frmKeySel.lstKeys.ListIndex = frmKeySel.lstKeys.ListIndex - 1
        If frmKeySel.lstKeys.ListIndex = -1 Then Exit Do
    Loop
    
    If frmKeySel.lstKeys.ListIndex <> -1 Then
        ' The first characters in this item, up to the
        ' tab character, are the key ID
        MyOwnKeySel = Left(frmKeySel.lstKeys.List(frmKeySel.lstKeys.ListIndex), InStr(frmKeySel.lstKeys.List(frmKeySel.lstKeys.ListIndex), Chr(9)) - 1)
    End If
    
    Unload frmKeySel
End Function

Function TrimNulls(sString As String) As String
    Dim i As Integer
    
    ' The DLLs will return a string with text at the beginning, and
    ' nulls (Chr(0)) filling the rest of the string.  This function
    ' trims the trailing nulls so VB can handle the string as it
    ' should.
    
    Do While i < Len(sString)
        i = i + 1
        If Asc(Mid(sString, i, 1)) = 0 Then Exit Do
    Loop
    
    TrimNulls = Left(sString, i - 1)
End Function

