//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-02-94	Began a major revision to fully handle a
//				multiple document interface with WWW, take
//				over the formatting and drawing of the
//				old gridtext functions of HText, and optimize
//				memory usage, selecting anchors, the usage of
//				HText's new image file.  See gridtext.
//		02-09-94	Split all members into seperate files.
#include"turlview.h"
#include"trace.h"
#include"urltodos.h"
#include<string.h>

TURLView::~TURLView()	{
//	Purpose:	Destructor
//	Arguments:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Memory possible allocated by isImage in the cp_imagename
//		member is not our responsibility.  Other DosLynx code must
//		free it when it is ready.
//	Revision History:
//		01-10-94	created
#ifndef RELEASE
	trace("Destorying view.");
#endif // RELEASE
	//	If a valid HText is in the view, set it to know that one less
	//	view is now accessing it.
	if(HTp_HyperDoc != NULL)	{
#ifndef RELEASE
		trace("Adjusting HText for one less view.");
#endif // RELEASE
		HTp_HyperDoc->usi_Views--;

		//	Here we manually get rid of the hotlist if there
		//	are no views looking at it.
		if(HTp_HyperDoc->usi_Views == 0 && cp_HotList != NULL &&
			*cp_HotList != '\0' && URLisLocal(getURL()) == 1)
		{
			//	Convert the hotlist to a URL.
			auto char ca_dosurl[usi_TILURLSize];
			dostourl(ca_dosurl, cp_HotList);

			//	Compare the names.
			if(0 == stricmp(getURL(), ca_dosurl))	{
				//	This is the HotList, get rid of it.
				HText_free(HTp_HyperDoc);
			}
		}
	}

	//	Free our line collection.
	//	There is in fact, no memory allocated, remove all items
	//	before destroying.
	if(TNSCp_lines != NULL)	{
#ifndef RELEASE
		trace("Freeing off line collection.");
#endif // RELEASE
		if(TNSCp_lines->getCount() != 0)	{
			TNSCp_lines->removeAll();
		}
		destroy(TNSCp_lines);
	}

	//	Free the anchor collection, one by one.
	if(TNSCp_anchors != NULL)	{
#ifndef RELEASE
		trace("Freeing off anchor collection.");
		trace(TNSCp_anchors->getCount() << " entries.");
#endif // RELEASE
		auto TextAttribute *TAp_free;
		for(signed short int ssi_free = 0; ssi_free <
			TNSCp_anchors->getCount(); ssi_free++)	{
			TAp_free = (TextAttribute *)(TNSCp_anchors->
				at(ssi_free));
			delete(TAp_free);
		}
		if(TNSCp_anchors->getCount() != 0)	{
			TNSCp_anchors->removeAll();
		}
		destroy(TNSCp_anchors);
	}

	//	If it exists, free the search attribute.
	if(TAp_search != NULL)	{
#ifndef RELEASE
		trace("Freeing off search attribute.");
#endif // RELEASE
		delete(TAp_search);
	}
}
