//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide the view of a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-04-94	created
#include"turlview.h"

void TURLView::LoadParent()	{
//	Purpose:	Cause the load of the current view's parent.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Puts an event into the event queue such that the following
//		actions should be taken by the owner of the TURLView:
//			destroy the TURLView
//			load the parent url in the TURLView's place.
//	Revision History:
//		03-04-94	created


	auto TEvent TE_load;

	//	Set up the event.
	//	Make sure to somehow mark which TURLView to destory through
	//		this message.
	TE_load.what = evCommand;
	TE_load.message.command = cmLoadParent;
	TE_load.message.infoPtr = (void *)this;

	//	Output the message.
	putEvent(TE_load);
}
