
/*
 * DLPI support routines to handle DPD.
 */

#include	<sys/types.h>
#include	<sys/stream.h>
#include	<sys/stropts.h>
#include	<sys/dlpi.h>
#include	<sys/signal.h>

#include	"ppp.h"
#include	"dpio.h"
#include	"dp.h"

dlattachreq(fd, ppa)
int	fd;
u_long	ppa;
{
    dl_attach_req_t	attach_req;
    struct	strbuf	ctl;
    int	flags;
    static char *WHERE = "dlattachreq";

    attach_req.dl_primitive = DL_ATTACH_REQ;
    attach_req.dl_ppa = ppa;

    ctl.maxlen = 0;
    ctl.len = sizeof (attach_req);
    ctl.buf = (char *) &attach_req;

    flags = 0;

    if (putmsg(fd, &ctl, (struct strbuf*) NULL, flags) < 0)
	d_log(DLOG_GENERAL, WHERE, "putmsg failed, %m");
}

dlbindreq(fd, sap, max_conind, service_mode, conn_mgmt, xidtest)
int	fd;
u_long	sap;
u_long	max_conind;
u_long	service_mode;
u_long	conn_mgmt;
u_long	xidtest;
{
    dl_bind_req_t	bind_req;
    struct	strbuf	ctl;
    int	flags;
    static char *WHERE = "dlbindreq";

    bind_req.dl_primitive = DL_BIND_REQ;
    bind_req.dl_sap = sap;
    bind_req.dl_max_conind = max_conind;
    bind_req.dl_service_mode = service_mode;
    bind_req.dl_conn_mgmt = conn_mgmt;
    bind_req.dl_xidtest_flg = xidtest;

    ctl.maxlen = 0;
    ctl.len = sizeof (bind_req);
    ctl.buf = (char *) &bind_req;

    flags = 0;

    if (putmsg(fd, &ctl, (struct strbuf*) NULL, flags) < 0)
	d_log(DLOG_GENERAL, WHERE, "putmsg failed, %m");
}


dlokack(fd, bufp)
int	fd;
char	*bufp;
{
    union	DL_primitives	*dlp;
    struct	strbuf	ctl;
    int	flags;
    static char *WHERE = "dlokack";

    ctl.maxlen = DP_MAXDLBUF;
    ctl.len = 0;
    ctl.buf = bufp;

    strgetmsg(fd, &ctl, (struct strbuf*)NULL, &flags, "dlokack");

    dlp = (union DL_primitives *) ctl.buf;

    if (expecting(DL_OK_ACK, dlp) < 0)
	return -1;

    if (ctl.len < sizeof (dl_ok_ack_t)) {
	d_log(DLOG_GENERAL, WHERE, "response ctl.len too short:  %d", ctl.len);
	return -1;
    }

    if (flags != RS_HIPRI) {
	d_log(DLOG_GENERAL, WHERE, "DL_OK_ACK was not M_PCPROTO");
	return -1;
    }

    if (ctl.len < sizeof (dl_ok_ack_t)) {
	d_log(DLOG_GENERAL, WHERE, "short response ctl.len:  %d", ctl.len);
	return -1;
    }
    return 0;
}


dlbindack(fd, bufp)
int	fd;
char	*bufp;
{
    union	DL_primitives	*dlp;
    struct	strbuf	ctl;
    int	flags;
    static char *WHERE = "dlbindack";

    ctl.maxlen = DP_MAXDLBUF;
    ctl.len = 0;
    ctl.buf = bufp;

    strgetmsg(fd, &ctl, (struct strbuf*)NULL, &flags, "dlbindack");

    dlp = (union DL_primitives *) ctl.buf;

    if (expecting(DL_BIND_ACK, dlp) < 0)
	return -1;

    if (flags != RS_HIPRI) {
	d_log(DLOG_GENERAL, WHERE, "DL_OK_ACK was not M_PCPROTO");
	return -1;
    }

    if (ctl.len < sizeof (dl_bind_ack_t)) {
	d_log(DLOG_GENERAL, WHERE, "short response ctl.len:  %d", ctl.len);
	return -1;
    }
    return 0;
}

static void
sigalrm()
{
    static char *WHERE = "sigalrm";
    (void) d_log(DLOG_GENERAL, WHERE, "getmsg TIMEOUT");
}

strgetmsg(fd, ctlp, datap, flagsp, caller)
int	fd;
struct	strbuf	*ctlp, *datap;
int	*flagsp;
char	*caller;
{
    int	rc;
    static	char	errmsg[80];
    static char *WHERE = "strgetmsg";

    /*
     * Start timer.
     */
    (void) signal(SIGALRM, sigalrm);
    if (alarm(DP_MAXWAIT) < 0) {
	d_log(DLOG_GENERAL, WHERE, "%s: alarm, %m", caller);
	return -1;
    }

    /*
     * Set flags argument and issue getmsg().
     */
    *flagsp = 0;
    if ((rc = getmsg(fd, ctlp, datap, flagsp)) < 0) {
	d_log(DLOG_GENERAL, WHERE, "%s: getmsg, %m", caller);
	return -1;
    }

    /*
     * Stop timer.
     */
    if (alarm(0) < 0) {
	d_log(DLOG_GENERAL, WHERE, "%s: alarm, %m", caller);
	return -1;
    }

    /*
     * Check for MOREDATA and/or MORECTL.
     */
    if ((rc & (MORECTL | MOREDATA)) == (MORECTL | MOREDATA))
	d_log(DLOG_GENERAL, WHERE, "%s:  MORECTL|MOREDATA", caller);
    if (rc & MORECTL)
	d_log(DLOG_GENERAL, WHERE, "%s:  MORECTL", caller);
    if (rc & MOREDATA)
	d_log(DLOG_GENERAL, WHERE, "%s:  MOREDATA", caller);

    /*
     * Check for at least sizeof (long) control data portion.
     */
    if (ctlp->len < sizeof (long))
	d_log(DLOG_GENERAL, WHERE,
	      "control portion length < sizeof (long):  %d", ctlp->len);
}

char *
dlprim(prim)
u_long	prim;
{
    static	char	primbuf[80];

    switch ((int)prim) {
     case DL_INFO_REQ:		return "DL_INFO_REQ";		break;
     case DL_INFO_ACK:		return "DL_INFO_ACK";		break;
     case DL_ATTACH_REQ:	return "DL_ATTACH_REQ";		break;
     case DL_DETACH_REQ:	return "DL_DETACH_REQ";		break;
     case DL_BIND_REQ:		return "DL_BIND_REQ";		break;
     case DL_BIND_ACK:		return "DL_BIND_ACK";		break;
     case DL_UNBIND_REQ:	return "DL_UNBIND_REQ";		break;
     case DL_OK_ACK:		return "DL_OK_ACK";		break;
     case DL_ERROR_ACK:		return "DL_ERROR_ACK";		break;
     case DL_SUBS_BIND_REQ:	return "DL_SUBS_BIND_REQ";	break;
     case DL_SUBS_BIND_ACK:	return "DL_SUBS_BIND_ACK";	break;
     case DL_UNITDATA_REQ:	return "DL_UNITDATA_REQ";	break;
     case DL_UNITDATA_IND:	return "DL_UNITDATA_IND";	break;
     case DL_UDERROR_IND:	return "DL_UDERROR_IND";	break;
     case DL_UDQOS_REQ:		return "DL_UDQOS_REQ";		break;
     case DL_CONNECT_REQ:	return "DL_CONNECT_REQ";	break;
     case DL_CONNECT_IND:	return "DL_CONNECT_IND";	break;
     case DL_CONNECT_RES:	return "DL_CONNECT_RES";	break;
     case DL_CONNECT_CON:	return "DL_CONNECT_CON";	break;
     case DL_TOKEN_REQ:		return "DL_TOKEN_REQ";		break;
     case DL_TOKEN_ACK:		return "DL_TOKEN_ACK";		break;
     case DL_DISCONNECT_REQ:	return "DL_DISCONNECT_REQ";	break;
     case DL_DISCONNECT_IND:	return "DL_DISCONNECT_IND";	break;
     case DL_RESET_REQ:		return "DL_RESET_REQ";		break;
     case DL_RESET_IND:		return "DL_RESET_IND";		break;
     case DL_RESET_RES:		return "DL_RESET_RES";		break;
     case DL_RESET_CON:		return "DL_RESET_CON";		break;
     default:			(void) sprintf(primbuf,
					       "unknown primitive 0x%x", prim);
				return primbuf;
    }
}

expecting(prim, dlp)
int	prim;
union	DL_primitives	*dlp;
{
    static char *WHERE = "expecting";
    if (dlp->dl_primitive != (u_long)prim) {
	d_log(DLOG_GENERAL, WHERE, "expected %s got %s", dlprim(prim),
	      dlprim(dlp->dl_primitive));
	return -1;
    }
    return 0;
}

strioctl(fd, cmd, timout, len, dp)
int	fd;
int	cmd;
int	timout;
int	len;
char	*dp;
{
    struct	strioctl	sioc;
    int	rc;

    sioc.ic_cmd = cmd;
    sioc.ic_timout = timout;
    sioc.ic_len = len;
    sioc.ic_dp = dp;
    rc = ioctl(fd, I_STR, &sioc);

    if (rc < 0)
	    return (rc);
    else
	    return (sioc.ic_len);
}
