(in-package "PT")

(defclass video-widget (widget)
  ((border-width :initform 0)
   (name :initform "A Video Widget")))

(defmethod do-repaint ((self video-widget) &key &allow-other-keys)
  (reset-video self))

(defun reset-video (self &aux x y)
  (multiple-value-setq (x y) (root-coords 0 0 self))
  (format *pip-pos* "POSITION ~d ~d~%" x y)
  (force-output *pip-pos*)
  (sleep 0.5)
  (format *pip-pos* "SIZE ~d ~d~%" (width self) (height self))
  (force-output *pip-pos*))

(defun make-video-widget (&rest args)
  (apply #'make-instance 'video-widget :allow-other-keys t args))

(defun start-video ()
  (format *pip-pos* "START~%")
  (force-output *pip-pos*))

(defun stop-video ()
  (format *pip-pos* "STOP~%")
  (force-output *pip-pos*))

(defun control-video (on)
  (if (= on 1) (start-video) (stop-video)))
