;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/text/RCS/entry-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:09:31 $
;;;

(in-package "PT")

;;;
;;; entry-widget class - a one-line text-widget.
;;;

;; Description of slots.
;;
;; return-function - function called after user presses return.

(defclass entry-widget (text-widget)
  ((return-function 
    :initarg :return-function  
    :initform nil 
    :type t 
    :accessor return-function)))

(defun make-entry-widget (&rest keys)
  (apply #'make-instance 'entry-widget :allow-other-keys t keys))

(defun quotize (self)
  (if (keywordp self)
      self
      `',self))

;; consistent with other names..
(defmethod (setf return-func) (val (self entry-widget))
  (setf (slot-value self 'return-function) val))

(defmethod return-func ((self entry-widget))
  (slot-value self 'return-function))

(defmethod new-instance ((self entry-widget)
			 &key
			 (base-width nil)
			 (base-size nil)
			 (resize-hint nil)
			 &allow-other-keys)
  (call-next-method)
  (setf (top-pad self) 
	(truncate (- (height self) (font-ascent (font self)))
		  2))
  (unless (or base-width base-size resize-hint)
	  (setf (columns self) 1))
  (setf (rows self) 1))

(defmethod value ((self entry-widget)
		  &key 
		  &allow-other-keys)
  (value (buffer self)))

(defun nil-func (&rest args)
  (declare (ignore args)))

(defhandler newline ((self entry-widget) &rest args
		     &default (:key-press :detail #\Return))
  (execute 'return-function self args))

;;;
;;;	Resize-window handler updates top-pad
;;;

(defmethod resize-window-handler ((self entry-widget))
  (call-next-method)
  (setf (top-pad self)
	(truncate (- (height self) (font-height (font self))) 2)))

(defmethod activate ((self entry-widget))
  (call-next-method)
  (when (viewable-p self)
	(warp-mouse self 5 (round (height self) 2))))
