;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/table/RCS/table-field.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:09:11 $
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/table/RCS/table-field.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/07/23 19:31:32 
;;;

(in-package "PT")

;;;
;;;	Layout
;;;
;;;  deselect button
;;;	|
;;;	\/
;;;	___________________________________________
;;;	|	      row-titles	       /  \ <-- pop-button
;;;	|  ____________________________________\__/
;;;	|c |				       |  |
;;;	|o |				       |  |
;;;	|l |				       |  |
;;;	|- |				       |  |
;;;	|t |				       |  |
;;;	|i |	     Primary Matrix	       |  |
;;;	|t |				       |  |
;;;	|l |				       |  |
;;;	|e |				       |  |
;;;	|s |				       |__|
;;;	|  |				       |/\|
;;;	|__|___________________________________|\/|
;;;	|  |				       |< |
;;;	|__|___________________________________|> |
;;;	
;;;
;;;
;;;
;;;	Functionality
;;;
;;;	Most of the function of the table-field is just to piece together the
;;;	matrix-field & functionality into a coherent user interface.  To 
;;;	accomplish this, the table-field consists of a primary matrix-field,
;;;	one or two optional titles, two scroll-bars, one pop-button, and an
;;;	"unselect button" which interact to perform simple and complex 
;;;	operations on each other.  Some of these operations, specifically,
;;;	the functions called by the tf-button, are user customizable but
;;;	have reasonable defaults.  
;;;
;;;	Creation options
;;;
;;;	Since a table-field creates its primary matrix-field (unless explicitly
;;;	passed in), all the matrix-field instantiation keywords should be 
;;;	passed to the table-field.  The table-field passes all of its 
;;;	instantiation arguments to the matrix-field.  The only other arguments
;;;	to the table-field new-instance are customization functions and 
;;;	a bitmap for the pop-button.
;;;
;;;	For a more detailed description of what table-fields do, see
;;;	matrix-fields.

(defclass table-field (collection-widget)
  ((horiz-scroll-bar 
    :initarg :horiz-scroll-bar  
    :initform nil 
    :type t
    :reader horiz-scroll-bar)
   (vert-scroll-bar
    :initarg :vert-scroll-bar 
    :initform nil
    :type t
    :reader vert-scroll-bar)
   (matrix-field 
    :initarg :matrix-field  
    :initform nil 
    :type t
    :accessor matrix-field)
   (name :initform "A Table-Field")
   (gm :initform 'anchor-gm)
   (gc-spec :initform '((gc-res "default")
			(gc-gray (:paint "gray50"))))
   (gc-gray
    :initform nil
    :type vector
    :reader gc-gray)
   (event-mask :initform '(:exposure))
   (conform :initform :dont-conform)))

(defun make-table-field (&rest keys)
  (apply #'make-instance 'table-field :allow-other-keys t keys))

;;;
;;;	Methods and setf's to propogate to matrix-field
;;;

(defmethod current-value ((self table-field))
  (if (matrix-field self)
      (current-value (matrix-field self))
      nil))

(defmethod (setf current-indices) (val (self table-field))
  (if (matrix-field self)
      (setf (current-indices (matrix-field self)) val)
      (warn "table-field.current-field.setf: Table has no matrix")))

(defmethod select-func ((self table-field))
  (if (matrix-field self)
      (select-func (matrix-field self))
      (warn "table-field.select-func.setf: Table has no matrix")))

(defmethod (setf select-func) (val (self table-field))
  (if (matrix-field self)
      (setf (select-func (matrix-field self)) val)
      (warn "table-field.select-func.setf: Table has no matrix")))

(defmethod data ((self table-field))
  (if (matrix-field self)
      (data (matrix-field self))
      nil))

(defmethod (setf data) (val (self table-field) &aux vsb hsb mf v)
  (setq vsb (vert-scroll-bar self)
	hsb (horiz-scroll-bar self)
	mf (matrix-field self))
  (when mf
      (progn (setf (data mf) val) 
	     (when vsb 
		   (setq v (visible-rows mf))
		   (setf (upper-limit vsb) (max (data-rows mf) v)
			 (slider-size vsb) v)) 
	     (when hsb
		   (setq v (visible-cols mf))
		   (setf (upper-limit hsb) (max (data-cols mf) v)
			 (slider-size hsb) v)))))

;;(defmethod (setf data) (val (self table-field))
;;  (setf (data (matrix-field self)) val))

(defmethod value ((self table-field)
		  &key 
		  &allow-other-keys)
  (data self))

(defmethod (setf value) (val (self table-field))
  (setf (data self) val))

(defmethod visible-rows ((self table-field))
  (visible-rows (matrix-field self)))

(defmethod (setf visible-rows) (val (self table-field))
  (setf (visible-rows (matrix-field self)) val))

(defmethod visible-cols ((self table-field))
  (visible-cols (matrix-field self)))

(defmethod (setf visible-cols) (val (self table-field))
  (setf (visible-cols (matrix-field self)) val))

(defmethod row-titles ((self table-field))
  (row-titles (matrix-field self)))

(defmethod (setf row-titles) (val (self table-field))
  (setf (row-titles (matrix-field self)) val))

(defmethod col-titles ((self table-field))
  (col-titles (matrix-field self)))

(defmethod (setf col-titles) (val (self table-field))
  (setf (col-titles (matrix-field self)) val))

(defmethod row-title-matrix ((self table-field))
  (row-title-matrix (matrix-field self)))

(defmethod (setf row-title-matrix) (val (self table-field))
  (setf (row-title-matrix (matrix-field self)) val))

(defmethod col-title-matrix ((self table-field))
  (col-title-matrix (matrix-field self)))

(defmethod (setf col-title-matrix) (val (self table-field))
  (setf (col-title-matrix (matrix-field self)) val))

(defmethod rows ((self table-field))
  (rows (matrix-field self)))

(defmethod cols ((self table-field))
  (cols (matrix-field self)))

(defmethod data-rows ((self table-field))
  (data-rows (matrix-field self)))

(defmethod data-cols ((self table-field))
  (data-cols (matrix-field self)))

(defmethod horiz-scroll-bar-p ((self table-field))
  (and (horiz-scroll-bar self) (exposed-p (horiz-scroll-bar self))))

(defmethod vert-scroll-bar-p ((self table-field))
  (and (vert-scroll-bar self) (exposed-p (vert-scroll-bar self))))

(defmethod (setf vert-scroll-bar-p) (val (self table-field) &aux mf sb hsb gs)
  (setq mf (matrix-field self)) 
  (when (and (null (setq sb (vert-scroll-bar self))) 
	     val) 
	;;  create scroll-bar 
	(setq sb (make-tf-vert-sb self))
	(attach sb))
  
  ;;  make backup copy of geom-spec
  (setf (slot-value mf 'geom-spec) (copy-list (geom-spec mf)))
  (setq gs (cadr (member :anchor (geom-spec mf))))
  (setf (getf gs :right)
	(if val 22 0))
  (if (keywordp (fifth gs))
      (setf (getf (cdr (geom-spec mf)) :anchor) gs)
      (setf (getf (geom-spec mf) :anchor) gs))
  (when (setq hsb (horiz-scroll-bar self))
	;;  make backup copy of geom-spec 
	(setf (slot-value hsb 'geom-spec) (copy-list (geom-spec hsb)))
	(setq gs (cadr (member :anchor (geom-spec hsb))))
	(setf (getf gs :right)
	      (if val 22 0))
	(if (keywordp (fifth gs))
	    (setf (getf (cdr (geom-spec hsb)) :anchor) gs)
	    (setf (getf (geom-spec hsb) :anchor) gs)))
  (when (setq hsb (col-title-matrix mf))
	;;  make backup copy of geom-spec 
	(setf (slot-value hsb 'geom-spec) (copy-list (geom-spec hsb)))
	(setq gs (cadr (member :anchor (geom-spec hsb))))
	(setf (getf gs :right)
	      (if val 22 0))
	(if (keywordp (fifth gs))
	    (setf (getf (cdr (geom-spec hsb)) :anchor) gs)
	    (setf (getf (geom-spec hsb) :anchor) gs)))
  (if val (expose sb) (conceal sb))
  (force-repack self))

(defmethod (setf horiz-scroll-bar-p) (val (self table-field) &aux mf sb vsb gs)
  (setq mf (matrix-field self))
  (when (and (null (setq sb (horiz-scroll-bar self))) 
	     val) 
	;;  create scroll-bar 
	(setq sb (make-tf-horiz-sb self))
	(attach sb))
  
  ;;  make backup copy of geom-spec
  (setf (slot-value mf 'geom-spec) (copy-list (geom-spec mf)))
  (setq gs (cadr (member :anchor (geom-spec mf))))
  (setf (getf gs :bottom)
	(if val 22 0))
  (if (keywordp (fifth gs))
      (setf (getf (cdr (geom-spec mf)) :anchor) gs)
      (setf (getf (geom-spec mf) :anchor) gs))
  (when (setq vsb (vert-scroll-bar self))
	;;  make backup copy of geom-spec 
	(setf (slot-value vsb 'geom-spec) (copy-list (geom-spec vsb)))
	(setq gs (cadr (member :anchor (geom-spec vsb))))
	(setf (getf gs :bottom)
	      (if val 22 0))
	(if (keywordp (fifth gs))
	    (setf (getf (cdr (geom-spec vsb)) :anchor) gs)
	    (setf (getf (geom-spec vsb) :anchor) gs)))
  (when (setq vsb (row-title-matrix mf))
	;;  make backup copy of geom-spec 
	(setf (slot-value vsb 'geom-spec) (copy-list (geom-spec vsb)))
	(setq gs (cadr (member :anchor (geom-spec vsb))))
	(setf (getf gs :bottom)
	      (if val 22 0))
	(if (keywordp (fifth gs))
	    (setf (getf (cdr (geom-spec vsb)) :anchor) gs)
	    (setf (getf (geom-spec vsb) :anchor) gs)))
  (if val (expose sb) (conceal sb))
  (force-repack self))

(defun make-tf-vert-sb (self &aux mf ctitles vsb)
  (setq mf (matrix-field self)
	ctitles (col-title-matrix mf))
  (setf (slot-value self 'vert-scroll-bar)
	(setq vsb
	      (make-scroll-bar 
	       :parent self
	       :orientation :vertical
	       :hot-spot :border
	       :geom-spec `(:anchor (:top 
				     ,(if ctitles 
					  (+ 4 (base-height ctitles))
					  0)
				     :right 0 :bottom 0))
	       :border-width 0
	       :lower-limit 0
	       :slider-location 0
	       :pause-seconds 0
	       :base-width 22
	       :data self
	       :slider-size (rows mf)
	       :upper-limit (max (num-elements (data mf)) 0)
	       :prev-line-func '(tf-up-row nil (data self) nil)
	       :next-line-func '(tf-down-row nil (data self) nil)
	       :prev-page-func '(tf-up-page nil (data self) nil)
	       :next-page-func '(tf-down-page nil (data self) nil)
	       :moved-func '(tf-move-row self (data self) event))))
  (setf (base-width vsb) 22
	(border-width vsb) 0)
  vsb)

(defun make-tf-horiz-sb (self &aux mf rtitles hsb)
  (setq mf (matrix-field self)
	rtitles (row-title-matrix mf))
  (setf (slot-value self 'horiz-scroll-bar)
	(setq hsb
	      (make-scroll-bar 
	       :parent self
	       :orientation :horizontal
	       :hot-spot :border
	       :geom-spec `(:anchor (:left 
				     ,(if rtitles 
					  (+ 4 (base-width rtitles))
					  0)
				     :right ,(if (and (vert-scroll-bar self)
						      (exposed-p 
						       (vert-scroll-bar self)))
						 22 0) 
				     :bottom 0))
	       :border-width 0
	       :lower-limit 0
	       :slider-location 0
	       :pause-seconds 0
	       :base-height 22
	       :buttons :right
	       :data self
	       :slider-size (cols mf)
	       :upper-limit (max (num-cols (data mf)) 0)
	       :prev-line-func '(tf-left-col nil (data self) nil)
	       :next-line-func '(tf-right-col nil (data self) nil)
	       :prev-page-func '(tf-left-page nil (data self) nil)
	       :next-page-func '(tf-right-page nil (data self) nil)
	       :moved-func '(tf-move-col self (data self) event))))
  (setf (base-height hsb) 22
	(border-width hsb) 0)
  hsb)

;;;
;;;	Message from geometry-manager
;;;

(defun ta-resize-update (self vr vc &aux vsb hsb)
  (setq vsb (vert-scroll-bar self)
	hsb (horiz-scroll-bar self))
  (unless (or (null vsb) (= vr (slider-size vsb)))
	  (setf (slider-size vsb) vr))
  (unless (or (null hsb) (= vc (slider-size hsb)))
	  (setf (slider-size hsb) vc)))

(defun ta-newdata-update (self nr nc &aux vsb hsb)
  (setq vsb (vert-scroll-bar self)
	hsb (horiz-scroll-bar self))
  (if vsb
      (setf (upper-limit vsb) nr))
  (if hsb
      (setf (upper-limit hsb) nc)))

;;;
;;;	Create a table-field instance
;;;

(defmethod new-instance ((self table-field)
			 &rest args 
			 &key
			 (vert-scroll-bar-p t)
			 (horiz-scroll-bar-p t)
					;; is tf-button wanted?
					;; customization for tf-button
			 (tf-button 	nil)
			 (tf-buttons	nil tbs-p)
			 (tf-items 	nil)
			 (tf-image	"swap.bitmap")
			 &aux vsb hsb mf rtitles ctitles right bottom)
  (call-next-method)

  (if tbs-p
      (setq tf-button tf-buttons))

  ;;	Turn off repacks
  (repack-off self)

  ;;	Create matrix-field
  (setq mf
	(apply #'make-matrix-field 
	       (append (list :parent self :gray nil :border-width 0) 
		       args 
		       (list :parent self :gray nil :border-width 0))))

  ;;	Create tf-items if needed
  (when (and tf-button (not tf-items))
	(setq tf-items
	      `(("deselect" (setf (current-indices ',mf)
				  nil))
		("add" (progn
			(insert-row ',mf) 
			(setf (current-indices ',mf) 
			      (list (list (1- (data-rows ',mf)) 0)))))
		("delete" (let* ((cur (current-indices ',mf))
				 (n (caar cur)))
				(when n 
				      (setf (current-indices ',mf) nil)
				      (delete-row ',mf n)
				      (setf (current-indices ',mf) cur))))
		("free-nomad" (let* ((temp nil))
				    (setf (free-nomad ',mf) 
					  (not (free-nomad ',mf)))
				    (setq temp 
					  (car (synths (menu (car (children
								    ',self))))))
				    (if (string= "free-rover"
						 (me-center temp))
					(setf (me-center temp)
					      "constrain-nomad")
					(setf (me-center temp)
					      "free-nomad")))))))
  (when tf-items (setq tf-button t))

  (setf (matrix-field self) mf
	(hot-spot mf) :window
	(base-size self) (base-size mf))
  (setq rtitles (slot-value mf 'row-titles)
	ctitles (slot-value mf 'col-titles))
  (setq right (if (and (> (rows mf) 1) vert-scroll-bar-p) 22 0)
	bottom (if (and (> (cols mf) 1) horiz-scroll-bar-p) 22 0))
  (cond ((and rtitles ctitles)
	 (setf (geom-spec mf) 
	       `(:anchor (:left ,(+ 3 (base-width rtitles))
				:top ,(+ 3 (base-height ctitles))
				:right ,right :bottom ,bottom)))
	 (setf (hot-spot rtitles) :window
	       (geom-spec rtitles)
	       `(:anchor (:left 0 :top ,(+ 3 (base-height ctitles))
				:bottom ,bottom))
	       (parent rtitles) self)
	 (setf (hot-spot ctitles) :window
	       (geom-spec ctitles)
	       `(:anchor (:left ,(+ 3 (base-width rtitles)) 
				:top 0 :right ,right))
	       (parent ctitles) self))
	(ctitles
	 (setf (geom-spec mf) 
	       `(:anchor (:left 0 :top ,(+ 3 (base-height ctitles))
				:right ,right :bottom ,bottom)))
	 (setf (hot-spot ctitles) :window
	       (geom-spec ctitles)
	       `(:anchor (:left 0 :top 0 :right ,right))
	       (parent ctitles) self))
	(rtitles
	 (setf (geom-spec mf)
	       `(:anchor (:left ,(+ 3 (base-width rtitles)) :top 0 
				:right ,right :bottom ,bottom)))
	 (setf (hot-spot rtitles) :window 
	       (geom-spec rtitles)
	       `(:anchor (:left 0 :top 0 :bottom ,bottom))
	       (parent rtitles) self))
	(t
	 (setf (geom-spec mf)
	       `(:anchor (:left 0 :right ,right :top 0 :bottom ,bottom)))))

  ;;	Create scroll-bars
  (unless (or (zerop right) (null vert-scroll-bar-p))
	  (setf (slot-value self 'vert-scroll-bar)
		(setq vsb
		      (make-scroll-bar 
		       :parent self
		       :orientation :vertical
		       :hot-spot :border
		       :geom-spec `(:anchor (:top 
					     ,(if ctitles 
						  (+ 4 (base-height ctitles))
						  0)
					     :right 0 :bottom 0))
		       :border-width 0
		       :lower-limit 0
		       :slider-location 0
		       :pause-seconds 0
		       :base-width 22
		       :data self
		       :slider-size (rows mf)
		       :upper-limit (max (num-elements (data mf)) 0)
		       :prev-line-func '(tf-up-row nil (data self) nil)
		       :next-line-func '(tf-down-row nil (data self) nil)
		       :prev-page-func '(tf-up-page nil (data self) nil)
		       :next-page-func '(tf-down-page nil (data self) nil)
		       :moved-func '(tf-move-row self (data self) event))))
	  (setf (base-width vsb) 22
		(border-width vsb) 0))
  (unless (or (zerop bottom) (null horiz-scroll-bar-p))
	  (setf (slot-value self 'horiz-scroll-bar)
		(setq hsb
		      (make-scroll-bar 
		       :parent self
		       :orientation :horizontal
		       :hot-spot :border
		       :geom-spec `(:anchor (:left 
					     ,(if rtitles 
						  (+ 4 (base-width rtitles))
						  0)
					     :right ,(if vsb 22 0)
					     :bottom 0))
		       :border-width 0
		       :lower-limit 0
		       :slider-location 0
		       :pause-seconds 0
		       :base-height 22
		       :buttons :right
		       :data self
		       :slider-size (cols mf)
		       :upper-limit (max (num-cols (data mf)) 0)
		       :prev-line-func '(tf-left-col nil (data self) nil)
		       :next-line-func '(tf-right-col nil (data self) nil)
		       :prev-page-func '(tf-left-page nil (data self) nil)
		       :next-page-func '(tf-right-page nil (data self) nil)
		       :moved-func '(tf-move-col self (data self) event))))
	  (setf (base-height hsb) 22
		(border-width hsb) 0))

  ;;	Create clear-button
  (when (and ctitles rtitles)
	(make-button :base-width (base-width rtitles)
		     :base-height (base-height ctitles)
		     :hot-spot :window
		     :geom-spec '(:anchor (:left 0 :top 0))
		     :parent self
		     :func '(ta-matrix-uncurrent self (data self) event)
		     :border-width 0))

  ;;	Create tf-button
  (when tf-button
	(when (and ctitles vsb)
	      (make-pop-button
	       :base-width (base-width vsb)
	       :base-height (base-height ctitles)
	       :parent self 
	       :hot-spot :window
	       :geom-spec '(:anchor (:top 0 :right 0))
	       :items tf-items
	       :value (make-image :file tf-image)
	       :border-width 0)))

  ;;	Turn repacking back on
  (repack-on self)

  (setf (size self)
	(list
	 (cond ((and rtitles (> (rows mf) 1))
		(+ (width mf) (width rtitles) 24))
	       (rtitles
		(+ (width mf) (width rtitles) 4))
	       ((> (rows mf) 1)
		(+ (width mf) 24))
	       (t
		(+ (width mf) 4)))
	 
	 (cond ((and ctitles (> (cols mf) 1))
		(+ (height mf) (height ctitles) 24))
	       (ctitles
		(+ (height mf) (height ctitles) 4))
	       ((> (cols mf) 1)
		(+ (height mf) 24))
	       (t
		(+ (height mf) 4)))))

  self)

(defmethod do-repaint ((self table-field)
		       &key 
		       &allow-other-keys
		       &aux mf temp temp2 res gc-res gc-gray)
  (call-next-method)
  (setq mf (matrix-field self)
	res (res self)
	gc-res (gc-res self)
	gc-gray (gc-gray self))
  (when (setq temp (slot-value mf 'col-titles)) 
	(setq temp (height temp)
	      temp2 (width self))
	(xlib:draw-rectangle res gc-res 0 temp temp2 2)
	(xlib:draw-line res gc-gray 0 (1+ temp) temp2 (1+ temp)))
  (when (setq temp (slot-value mf 'row-titles))
	(setq temp (width temp)
	      temp2 (height self)) 
	(xlib:draw-rectangle res gc-res temp 0 2 temp2)
	(xlib:draw-line res gc-gray (1+ temp) 0 (1+ temp) temp2)))
