#include <stdio.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/stat.h>
#include "libaudio.h"
#include "audio_device.h"

extern char *malloc();
extern char *realloc();

#define MALLOC(N)               malloc ((unsigned)(N))
#define REALLOC(P,N)            realloc ((char *)(P), (unsigned)(N))

static Audio_hdr hdr;
static int audioDataLength;
static int dataAlloc;
static char *audioData;

long
FileSize (file)
FILE *file;

    {
    struct stat buf;

    if (fstat (fileno(file), &buf) == -1)
	perror ("Warning: couldn't stat file");
    return (long)(buf.st_size);
    }

/* =========================== Sound Input Routines ======================= */

int
ReadSound (fname)
char *fname;

    {
    FILE *file;
    long size;
    int err;

    file = fopen(fname, "r");
    if (file == NULL)
	{
	perror (fname);
	return 0;
	}

    /*
     * Read in the data.  This is just one big fread into a buffer.
     */
    err = audio_read_filehdr(fileno(file), &hdr, (char *)NULL, 0);
    if (err != AUDIO_SUCCESS)
	{
	fprintf (stderr, "Warning: %s is not a valid audio file\n", fname);
	return 0;
	}
    else
	{
	audioDataLength = FileSize(file);
	audioData = MALLOC(size);
	audioDataLength = fread (audioData, 1, audioDataLength, file);
	audioData = REALLOC(audioData, audioDataLength);
	dataAlloc = 1;
	fclose (file);
	}
    return 1;
    }

int
SoundLength()

    {
    return audioDataLength;
    }

int
SoundSampleRate()

    {
    return hdr.sample_rate;
    }

int
SoundBytesPerUnit()

    {
    return hdr.bytes_per_unit;
    }

int
SoundChannels()

    {
    return hdr.channels;
    }

int
SoundSamplesPerUnit()

    {
    return hdr.samples_per_unit;
    }

void
GetSoundData(data)
char *data;

    {
    bcopy (audioData, data, audioDataLength);
    }

/* =========================== Sound Output Routines ======================= */

int
WriteSound (fname)
char *fname;

    {
    FILE *file;

    file = fopen(fname, "w");
    if (file == NULL)
	{
	perror (fname);
	return 0;
	}

    /*
     * Write the header.
     */
    if ((audio_write_filehdr(fileno(file), &hdr, NULL, 0) == AUDIO_SUCCESS) &&
	(fwrite (audioData, 1, audioDataLength, file) == audioDataLength))
	{
	fclose (file);
	return 1;
	}
    else
	{
	fprintf (stderr, "Warning: write failed to ");
	perror (fname);
	return 0;
	}
    }

void
SetSoundParams (sample_rate, bytes_per_unit, channels, samples_per_unit)
int sample_rate;
int bytes_per_unit;
int channels;
int samples_per_unit;

    {
    hdr.sample_rate = sample_rate;
    hdr.bytes_per_unit = bytes_per_unit;
    hdr.channels = channels;
    hdr.samples_per_unit = samples_per_unit;
    }

void
SetSoundData(data, start, end)
char *data;
int start, end;

    {
    if (dataAlloc) 
	{
	free (audioData);
	dataAlloc = 0;
	}
    audioDataLength = end-start+1;
    audioData = data;
    }

int
PlaySound()

    {
    int fd, len, err;
    Audio_hdr savedHdr;

    fd = open("/dev/audio", O_WRONLY);
    if (fd == -1)
	{
	perror ("Error opening audio device");
	return 0;
	}

    /* Check that the sound device is set up properly */
    audio_get_play_config(fd, &savedHdr);
    audio_set_play_config(fd, &hdr);

    /* Write all the data */
    len = audioDataLength;
    while (len)
	{
	err = write(fd, audioData+audioDataLength-len, len);
	if (err == -1)
	    {
	    perror ("Audio output error");
	    len = 0;
	    }
	else len -= err;
	}

    /* Close the audio file. */
    audio_set_play_config(fd, &savedHdr);
    close (fd);
    return (err >= 0);
    }
