;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/soh/RCS/initdb.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:49 $
;;;

#+libpq
(in-package 'pcl :use '(libpq lisp))

#+cling
(in-package 'pcl :use '(cling lisp))

;;; 
;;; Set the database and port when first entering SOH.
;;;

#+libpq
(defun initdb (dbname &key host port trace debug-tty)
  ;; Coerce dbname to string
  (setq dbname (string dbname))
  (pqsetdb dbname)
  (if host (setq libpq::*pqhost* host))
  (if port (setq libpq::*pqport* port))
  (if trace (pqtrace))
  (if debug-tty (setq libpq::*pqtty* debug-tty))
  ;; if the database is not initialized for storing persistent classes,
  ;; do so now.
  (pqexec "retrieve (pg_relation.oid) where pg_relation.relname = \"dbclass\"")
  (when (zerop (pqntuples (pqparray "blank")))
	(pqexec "create dbclass (name=char16,owner=text,superclasses=text, slots=text,options=text)")
	(pqexec "create superclasses (class=char16,superclass=char16)")
	(pqexec "create local (loid=text,make=text)")))

#+cling
(defun initdb (dbname &key host port (trace t) debug-tty)
  (db-connect dbname)
  (db-set-autocommit t)
  (if trace (setq cling::show-query t))
  (cling::db-whenever :sqlerror 'cling::sqlprint)
  ;; if the database is not initialized for storing persistent classes,
  ;; do so now.
  (when (null (db-select '(i.table_name) :from '((iitables i)) :where '(= i.table_name "dbclass")))
	(db-create-table 'dbclass '((name (char 16)) (owner (char 16)) (superclasses (varchar 64)) (slots (varchar 1024)) (options (varchar 512))))
	(db-create-table 'superclasses '((class (char 16)) (superclass (char 16))))
	(db-create-table 'local '((loid (varchar 512)) (make (varchar 512))))
	(db-commit))
    dbname)

#+libpq
(defun closedb ()
  (setq dbname nil))

#+cling
(defun closedb ()
  (db-disconnect)
  (setq dbname nil))

;;;
;;; Exports
;;;
(export '(initdb closedb)
	(find-package 'pcl))
