;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/soh/RCS/exit.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:49 $
;;;

(in-package 'pcl :use '(lisp))

;;;
;;; This function should always be executed when exiting from Lisp.
;;; Need to how to force execution at exit.
;;;

(defun save-object-cache ()
  (maphash #'(lambda (key val)
	       (declare (ignore key))
	       (when (not (equal (handle-mode val) 'local-copy))
		     (store-dbobject val)))
		     *object-cache*))

;;;
;;; Exports
;;;
(export '(save-object-cache)
	(find-package 'pcl))

