;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/misc/RCS/synth-gadget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:32 $
;;;

(in-package "PT")

;;;
;;; Definition of the synth-gadget class
;;;

(defclass synth-gadget (gadget)
  ((mask
    :initarg :mask
    :initform nil
    :type atom
    :reader mask) 
   (horiz-just
    :initarg :horiz-just
    :initform :center
    :type symbol
    :reader horiz-just)
   (vert-just
    :initarg :vert-just
    :initform :center
    :type symbol
    :reader vert-just)
   (flag 
    :initform nil
    :type atom
    :reader flag)
   (base-width :initform 0)
   (base-height :initform 0)
   (conform
    :initarg :conform
    :initform :grow-shrink
    :type symbol
    :accessor conform)
   (gc-spec :initform '(gc-res "default"))))

;;;
;;; Make functions
;;;

(defun make-synth-gadget (&rest keys)
  (apply #'make-instance 'synth-gadget :allow-other-keys t keys))

(defun make-text-gadget (&rest keys)
  (apply #'make-instance 'synth-gadget :allow-other-keys t keys))

(defun make-image-gadget (&rest keys)
  (apply #'make-instance 'synth-gadget :allow-other-keys t keys))

;;;
;;; Accessor functions
;;;

(defmethod value ((self synth-gadget)
		  &key 
		  &allow-other-keys)
  (car (slot-value self 'value)))

(defun sw-calc-base-size (self &aux val cf bsize)
  (setq val (car (slot-value self 'value))
	cf (slot-value self 'conform))
  (if (eq cf :dont-conform)
      (base-size self)
      (progn
       (setq bsize (calc-synth-base-size val 10 10 (font self)))
       (if (eq cf :grow-only)
	   (list (max (car bsize) (base-width self))
		 (max (cadr bsize) (base-height self)))
	   bsize))))

(defmethod (setf conform) (val (self synth-gadget))
  (cond ((eq val (slot-value self 'conform))
	 nil)
	((member val '(:grow-shrink :dont-conform :grow-only))
	 (setf (slot-value self 'conform) val)
	 (if (attached-p self)
	     (setf (base-size self) (sw-calc-base-size self))))
	(t
	 (warn "synth-gadget:  bad value for conform:  ~S" val))))

(defmethod (setf value) (val (self synth-gadget) &aux sval)
  (unless (and (setq sval (slot-value self 'value))
	       (flag self))
	  (setq sval (list nil :window self :width (width self)
			   :height (height self) :gc (gc-res self) 
			   :horiz-just :center :vert-just :center
			   :mask (mask self) :dimmed (dimmed self))))
  (setf (slot-value self 'value)
	(rplaca sval val))
  (when (attached-p self)
	(setf (base-size self) (sw-calc-base-size self))
	(repaint self)))

(defmethod (setf mask) (val (self synth-gadget) &aux synth)
  (if (and (consp (setq synth (slot-value self 'value))) (second synth))
      (setf (getf (cdr synth) :mask) val))
  (setf (slot-value self 'mask) val)
  (repaint self))

(defmethod (setf dimmed) (val (self synth-gadget) &aux synth)
  (call-next-method)
  (if (and (consp (setq synth (slot-value self 'value))) (second synth))
      (setf (getf (cdr synth) :dimmed) val))
  (repaint self))

(defmethod (setf horiz-just) (val (self synth-gadget) &aux synth)
  (if (and (consp (setq synth (slot-value self 'value))) (second synth))
      (setf (getf (cdr synth) :horiz-just) val))
  (setf (slot-value self 'horiz-just) val)
  (repaint self))

(defmethod (setf vert-just) (val (self synth-gadget) &aux synth)
  (if (and (consp (setq synth (slot-value self 'value))) (second synth))
      (setf (getf (cdr synth) :vert-just) val))
  (setf (slot-value self 'vert-just) val)
  (repaint self))

(defmethod resize-window-handler ((self synth-gadget) &aux sval)
  (setq sval (slot-value self 'value))
  (setf (getf (cdr sval) :width) (width self)
	(getf (cdr sval) :height) (height self))
  (setf (slot-value self 'value) sval))

(defmethod new-instance ((self synth-gadget) &rest args)
  (declare (ignore args))
  (call-next-method)
  (setf (slot-value self 'flag) t)
  self)

(defmethod do-attach ((self synth-gadget) &aux sval)
  (call-next-method)
  (setq sval (slot-value self 'value))
  (when (gc-res self)
	(setf (getf (cdr sval) :gc) (gc-res self))
	(setf (slot-value self 'value) sval))
  (setf (base-size self) (sw-calc-base-size self))
  )

(defmethod do-repaint ((self synth-gadget)
		       &key 
		       &allow-other-keys)
  (call-next-method)
  (apply #'put (slot-value self 'value)))
