;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/misc/RCS/indicator-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:32 $
;;;
;;; ACCESSORS AND INSTANTIATION
;;;
;;; The following accessors are provided for customization of the meter-widget:
;;; 	low	-	lower bound (number)
;;;	high	-	upper bound (number)
;;;	value	-	current position of locator relative to low and high
;;;				(number)
;;; NOTE: when value is nil, the locator is not drawn.
;;;

(in-package "PT")

(defclass indicator-widget (indicator)
  ((event-mask :initform '(:exposure :button-press))))

(defun make-indicator-widget (&rest args)
  (apply #'make-instance 'indicator-widget :allow-other-keys t args))

(defhandler select ((self indicator-widget) &key x &allow-other-keys
		    &default :button-press)
  ;;  calculate bounds
  (prog (val low high pad max min scale blah w)
	(setq val (value self)
	      low (low self)
	      high (high self))
	(setq pad (+ (pad self) 8)
	      max (if val (max low high val) (max low high))
	      min (if val (min low high val) (min low high)))
	(setq scale (/ (max 0 (- (width self) pad pad)) (max 1 (- max min))))
	(setq blah (truncate (+ pad -8 (* (- val min) scale))))
	
	(setq w (max 1 (- (width self) pad pad)))
	(decf x pad)
	(setf (value self) (truncate (* x scale)))))
