;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: johnb $
;;; $Source: /pic2/picasso/new/widgets/menu/RCS/menu-entry.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1991/08/19 22:37:29 $
;;;

(in-package "PT")

;;; THE DEFCLASS FOR MENU-ENTRY CAN BE FOUND IN menu-defclasses.cl

;;;
;;; Accessor Methods for menu-item
;;;

(defun menu-execute (me &optional (event nil))
  (push-env (window me))
  (eval
   `(let ((self ',me)
	  (event ',event))
	 ,(code me)))
  (pop-env))

(defun mi-width (mi &aux val font)
  "Return the 'desired' width of the menu-item"
  (if (null mi)
      (return-from mi-width 0))
  (setq val (value mi)
	font (font mi))
  (cond ((stringp val)
	 (cond ((font-p font))
	       ((stringp font) 
		(setq font (get-font font)))
	       ((null font)
		(setq font (get-font))))
	 (text-width val :font font))
	((not (listp val))
	 (width val))
	((null val) 0)
	#|(t (apply #'+ 
		    (mapcar #'(lambda (x) (intern-synth-width 
					   (cons x (cdr val))))
			    val)))|#
	(t (error "synth-width: can't compute width of list \`~s\`" val))
	))

(defun mi-height (mi &aux val font)
  "Return the 'desired' height of the menu-item"
  (if (null mi)
      (return-from mi-height 0))
  (setq val (value mi)
	font (font mi))
  (cond ((stringp val)
	 (cond ((font-p font))
	       ((stringp font) 
		(setq font (get-font font)))
	       ((null font)
		(setq font (get-font))))
	 (font-height font))
	((not (listp val))
	 (height val))
	((null val) 0)
	#|(t (apply #'+ 
		    (mapcar #'(lambda (x) (intern-synth-height 
					   (cons x (cdr val))))
			    val)))|#
	(t (error "synth-height: can't compute width of list \`~s\`" val))
	))

(defun mi-attach (mi &optional window &aux gc gc-dim gc-invert)
  (setf (dlist mi) nil)
  (if (null window)
      (setq window (window mi)))
  (setq gc 
	(make-shared-gc window 
			(list :paint (foreground mi) 
			      :background (background mi) 
			      :font (font mi))))
  (setq gc-invert 
	(make-shared-gc window 
			(list :paint (background mi) 
			      :background (foreground mi) 
			      :font (font mi))))
  (setq gc-dim
	(make-shared-gc window 
			(list :paint "gray50" 
			      :background (background mi) 
			      :font (font mi)
			      :function
			      (if (black-and-white-display-p (display window))
				  #+allegro 8 #+lucid xlib::boole-nor
				  #+allegro 2 #+lucid xlib::boole-1))))
  (setf (slot-value mi 'dlist)
	(list (value mi) :window window :gc gc :gc-invert gc-invert
	      :gc-dimmed gc-dim :x 0 :y 0 :width 0 :height 0 
	      :dimmed (dimmed mi))))

(defun mi-detach (mi)
  (setf (dlist mi) nil))

(defmethod (setf window) (val (item menu-item) &key warn-p)
  (declare (ignore warn-p))
  (setf (slot-value item 'window) val)
  (mi-attach item))

(defmethod (setf font) (val (item menu-item))
  (setf (slot-value item 'font) val)
  (mi-attach item))

(defmethod (setf foreground) (val (item menu-item))
  (setf (slot-value item 'foreground) val)
  (mi-attach item))

(defmethod (setf background) (val (item menu-item))
  (setf (slot-value item 'background) val)
  (mi-attach item))

(defmethod (setf region) (val (item menu-item) &aux dl)
  (if (setq dl (cdr (dlist item)))
      (setf (getf dl :x) (first val)
	    (getf dl :y) (second val)
	    (getf dl :width) (third val)
	    (getf dl :height) (fourth val))))

(defmethod (setf dimmed) (val (item menu-item) &aux dl)
  (setf (slot-value item 'dimmed) val)
  (if (setq dl (cdr (dlist item)))
      (setf (getf dl :dimmed) val)))

(defmethod value ((item menu-item) &key &allow-other-keys)
  (slot-value item 'value))

(defmethod (setf value) (val (item menu-item) &aux dl)
  (setf (slot-value item 'value) val)
  (if (setq dl (dlist item))
      (setf (car dl) val)))

;;;
;;; Accessor methods for menu-entry
;;;

(defmethod add ((me menu-entry) pane)
  (setf (window me) pane)
  (push me (slot-value pane 'synths)))

(defmethod (setf window) (pane (me menu-entry) &key warn-p &aux item)
  (declare (ignore warn-p))
  (setf (slot-value me 'window) pane)
  (if (setq item (left-item me))
      (setf (window item) pane))
  (if (setq item (center-item me))
      (setf (window item) pane))
  (if (setq item (right-item me))
      (setf (window item) pane)))

(defmethod (setf parent) (pane (me menu-entry))
  (setf (window me) pane)
  (push me (slot-value pane 'synths)))

(defun add-me (me sup)
  (setf (window me) sup))

(defmethod (setf left) (val (me menu-entry) &aux item)
  (setf (slot-value me 'left) val)
  (if (setq item (left-item me))
      (setf (value item) val)))

(defun me-left (me)
  (left me))

(defun set-me-left (me val)
  (setf (left me) val))

(defun me-center (me)
  (center me))

(defmethod (setf center) (val (me menu-entry) &aux item)
  (setf (slot-value me 'center) val)
  (if (setq item (center-item me))
      (setf (value item) val)))

(defun set-me-center (me val)
  (setf (center me) val))

(defun me-right (me)
  (right me))

(defmethod (setf right) (val (me menu-entry) &aux item)
  (setf (slot-value me 'right) val)
  (if (setq item (right-item me))
      (setf (value item) val)))

(defun set-me-right (me val)
  (setf (right me) val))

(defun me-font (me)
  (font me))

(defmethod (setf font) (val (me menu-entry) &aux item)
  (setf (slot-value me 'font) val)
  (if (setq item (left-item me))
      (setf (font item) val))
  (if (setq item (center-item me))
      (setf (font item) val))
  (if (setq item (right-item me))
      (setf (font item) val)))

(defun set-me-font (me val)
  (setf (font me) val))

(defun me-dimmed (me)
  (dimmed me))

(defmethod (setf dimmed) (val (me menu-entry) &aux item)
  (setf (slot-value me 'dimmed) val)
  (if (setq item (left-item me))
      (setf (dimmed item) val))
  (if (setq item (center-item me))
      (setf (dimmed item) val))
  (if (setq item (right-item me))
      (setf (dimmed item) val)))

(defun set-me-dimmed (me val)
  (setf (dimmed me) val))

(defmethod (setf exposed) (val (me menu-entry) &aux item)
  (setf (slot-value me 'exposed) val)
  (if (setq item (left-item me))
      (setf (exposed item) val))
  (if (setq item (center-item me))
      (setf (exposed item) val))
  (if (setq item (right-item me))
      (setf (exposed item) val)))

(defun show-me (me)
  (setf (exposed me) t))

(defun hide-me (me)
  (setf (exposed me) nil))

(defun remove-me (me pane)
  (setf (slot-value pane 'synths)
	(delete me (slot-value pane 'synths))))

(defun me-attach (me &optional parent &aux item)
  (if (setq item (left-item me))
      (mi-attach item parent))
  (if (setq item (center-item me))
      (mi-attach item parent))
  (if (setq item (right-item me))
      (mi-attach item parent)))

(defun me-detach (me &aux item)
  (if (setq item (left-item me))
      (mi-detach item))
  (if (setq item (center-item me))
      (mi-detach item))
  (if (setq item (right-item me))
      (mi-detach item)))

(defun me-invert (me pane-res gc width &aux item)
  (if (null me) (return-from me-invert))
  (xlib:draw-rectangle pane-res gc 
		       1 (y-offset me) 
		       (- width *menu-shadow-thickness* 2) 
		       (height me) t)
  (when (setq item (left-item me))
	(setq item (dlist item))
	(apply #'put (car item) :inverted t (cdr item)))
  (when (setq item (center-item me))
	(setq item (dlist item))
	(apply #'put (car item) :inverted t (cdr item)))
  (when (setq item (right-item me))
	(setq item (dlist item))
	(apply #'put (car item) :inverted t (cdr item))))

(defun me-uninvert (me pane-res gc-clear width &aux item)
  (if (null me) (return-from me-uninvert))
  (xlib:draw-rectangle pane-res gc-clear 1 (y-offset me)
		       (- width *menu-shadow-thickness* 2) (height me) t)
  (when (setq item (left-item me)) 
	(setq item (dlist item))
	(apply #'put item))
  (when (setq item (center-item me)) 
	(setq item (dlist item))
	(apply #'put item))
  (when (setq item (right-item me)) 
	(setq item (dlist item))
	(apply #'put item)))

;;;
;;;	Detach a menu-entry
;;;


;;;
;;; new-instance method for menu-entry
;;;
(defun default-menu-fxn (self) (declare (ignore self)) t)

(defmethod new-instance ((self menu-entry) 
			 &key
			 left center right 
			 foreground left-foreground 
			 right-foreground center-foreground 
			 background left-background 
			 right-background center-background 
			 font left-font center-font right-font 
			 dimmed 
			 status left-status center-status right-status 
			 parent
			&allow-other-keys)

  (when parent
	(setf (slot-value self 'window) parent)
	(push self (slot-value parent 'synths)))
  ;;  Set up fonts
  (if (null font)
      (setq font (or (get-default "menu" "font") (get-font))))
  (if (null left-font)
      (setq left-font font))
  (if (null center-font)
      (setq center-font font))
  (if (null right-font)
      (setq right-font font))

  ;;  Set up foreground
  (if (null foreground)
      (setq foreground (get-default "menu" "foreground" :default-to "black")))
  (if (null left-foreground)
      (setq left-foreground foreground))
  (if (null center-foreground)
      (setq center-foreground foreground))
  (if (null right-foreground)
      (setq right-foreground foreground))

  ;;  Set up background
  (if (null background)
      (setq background (get-default "menu" "background" :default-to "white")))
  (if (null left-background)
      (setq left-background background))
  (if (null center-background)
      (setq center-background background))
  (if (null right-background)
      (setq right-background background))

  ;;  Set up status
  (setq status 
	(if (eq status :concealed) nil t))

  (setq left-status
	(if left-status
	    (if (eq left-status :concealed) nil t)
	    status))
  (setq center-status
	(if center-status
	    (if (eq center-status :concealed) nil t)
	    status))
  (setq right-status
	(if right-status
	    (if (eq right-status :concealed) nil t)
	    status))

  ;;  Create menu-items
  (when left
      (setf (left-item self)
	    (make-menu-item :value left
			    :font left-font :foreground left-foreground 
			    :window parent :background left-background 
			    :dimmed dimmed :exposed left-status)))
  (when center
      (setf (center-item self)
	    (make-menu-item :value center
			    :font center-font :foreground center-foreground 
			    :window parent :background center-background 
			    :dimmed dimmed :exposed center-status)))
  (when right
      (setf (right-item self)
	    (make-menu-item :value right
			    :font right-font :foreground right-foreground 
			    :window parent :background right-background 
			    :dimmed dimmed :exposed right-status))))

