;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/menu/RCS/menu-bar.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:26 $
;;;

(in-package "PT")

(defmethod gm-status-changed ((gm (eql 'left-pack-gm)) self child)
  (declare (ignore child))
  (do-repack self))

(defmethod gm-repack ((gm (eql 'left-pack-gm)) self)
  (let ((w (width self))
	(h (height self))
	(x 0))
       (dolist (ch (reverse (managed-of (children self))))
	       (let* ((bw (+ 10 (base-width ch)))
		      (wid (min bw (- w x))))
		     (reshape ch x 0 wid h)
		     (incf x wid)))
       (repaint self)))

(defmethod gm-status-changed ((gm (eql 'just-pack-gm)) self child)
  (declare (ignore child))
  (do-repack self))

(defmethod gm-repack ((gm (eql 'just-pack-gm)) self)
  (let* ((w (width self))
	 (h (height self))
	 (kids (reverse (managed-of (children self))))
	 (num-kids (length kids))
	 (x 0)
	 (new-x 0)
	 (needed (apply #'+ (mapcar #'base-width kids)))
	 (pad (/ (- w needed) (max 1 num-kids))))
	(dolist (ch kids)
		(if (pended-p ch) (do-unpend ch))
		(setq new-x (+ x pad (base-width ch)))
		(apply #'reshape ch 
		       (actual-region ch 
				      :x (round x) 
				      :y 0 
				      :width (round (- new-x x))
				      :height h
				      :borders t :label nil))
		(setq x new-x))
	(repaint self)))

(defmethod new-instance :around ((self menu-bar)
				 &rest keys
				 &key
				 (structure nil structurep)
				 &allow-other-keys)
  (if structurep
      (apply #'call-next-method 
	     `(,self :children ,(mapcar #'process-menu-btn 
					 (cons *picasso-menu-structure* 
					       structure)) ,@keys))
      (call-next-method)))

(defun process-menu-btn (but &aux label)
  (when (and (symbolp (car but)) (consp (cadr but)) (eql (length but) 2))
	(setq label (car but))
	(setq but (cadr but)))
  (let* ((name (car but))
	 (keyword-pair nil)
	 (title name)
	 (entries nil)
	 (options nil))
	(dolist (s (cdr but))
		(cond (keyword-pair
		       (push s options)
		       (setq keyword-pair nil))
		      ((stringp s) (setq title s))
		      ((keywordp s) 
		       (push s options)
		       (setq keyword-pair t))
		      ((and (consp s) (symbolp (car s)) (consp (cadr s)) 
			    (eql (length s) 2))
		       (push `(,(car s) ,(process-menu-entry (cadr s))) 
			     entries))
		      ((consp s) (push (process-menu-entry s) entries))))
	(if label
	    `(,label (make-menu-button :value ,name 
				       ,@(reverse options)
				       :menu (make-menu-pane 
					      :name ,title
					      :lexical-parent #!po
					      :children ',(reverse entries))))
	    `(make-menu-button :value ,name 
			       ,@(reverse options)
			       :menu (make-menu-pane 
				      :name ,title
				      :lexical-parent #!po
				      :children ',(reverse entries))))))

(defun process-menu-entry (str &aux label)
  (when (and (symbolp (car str)) (consp (cadr str)) (eql (length str) 2))
	(setq label (car str))
	(setq str (cadr str)))
  (if label
      `(,label (make-menu-entry :center ,(car str) 
				:code ',(cadr str)
				,@(cddr str)))
      `(make-menu-entry :center ,(car str) 
			:code ',(cadr str)
			,@(cddr str))))


  


