;;;
;;; Object FADS interface to POSTGRES
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/libpq/RCS/pqcomm.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:18 $
;;;

(in-package libpq)

#{(progn
   (unless *libpq-loaded*
	   (remove-entry-point "__wrtchk")
	   (remove-entry-point "__findbuf")
	   (remove-entry-point "__xflsbuf")
	   (remove-entry-point "__bufsync")
	   (remove-entry-point "__findiop")
	   (remove-entry-point "__f_morefiles")
	   (remove-entry-point "__smbuf")
	   (remove-entry-point "_f_prealloc")
	   (remove-entry-point "__fwalk")
	   (remove-entry-point "__cleanup")
	   (remove-entry-point "__flsbuf")
	   (remove-entry-point "_fflush")
	   (remove-entry-point "_fclose")
	   (remove-entry-point "__iob")
	   (load *libpq-dot-o-file*)
	   (setq *libpq-loaded* t))
   (defforeign-list
    (list (list 'cpconnect 
		:entry-point "_pconnect" 
		:arg-checking *libpq-argument-check*
		:arguments '(string string)
		:return-type :void)
	  
	  (list 'cpflush
		:entry-point "_pflush"
		:arg-checking *libpq-argument-check*
		:arguments nil
		:return-type :void)
	  
	  (list 'cpclose
		:entry-point "_pgclose"
		:arg-checking *libpq-argument-check*
		:arguments nil
		:return-type :void)
	  
	  (list 'cputstr 
		:entry-point "_putstr" 
		:arg-checking *libpq-argument-check*
		:arguments '(string)
		:return-type :void)
	  
	  (list 'cputnchar
		:entry-point "_putnchar" 
		:arg-checking *libpq-argument-check*
		:arguments '(string fixnum)
		:return-type :void)
	  
	  (list 'cputint
		:entry-point "_putint" 
		:arg-checking *libpq-argument-check*
		:arguments '(integer fixnum)
		:return-type :void)
	  
	  (list 'cgetpstr
		:entry-point "_getpstr" 
		:arg-checking *libpq-argument-check*
		:arguments '(string fixnum)
		:return-type :fixnum)
	  
	  (list 'cgetpchar 
		:entry-point "_getpchar" 
		:arg-checking *libpq-argument-check*
		:arguments '((array string-char) fixnum fixnum)
		:return-type :void)
	  
	  (list 'cgetpbitmap 
		:entry-point "_getpchar" 
		:arg-checking *libpq-argument-check*
		:arguments '((simple-array (unsigned-byte 8) (100)) 
			     fixnum fixnum)
		:return-type :void)
	  
	  (list 'cgetpid
		:entry-point "_getpchar" 
		:arg-checking *libpq-argument-check*
		:arguments '(string fixnum fixnum)
		:return-type :void)
	  
	  (list 'cgetpint 
		:entry-point "_getpint" 
		:arguments '(fixnum) 
		:arg-checking *libpq-argument-check*
		:return-type :integer)))
   (defforeign 'Cputsinglefloat
	       :entry-point "_putsinglefloat" 
	       :return-type :void
	       :arguments '(single-float))
   (defforeign 'Cputsinglefloat2
	       :entry-point "_putsinglefloat_two" 
	       :return-type :void
	       :arguments '(single-float))
   (defforeign 'Cputsinglefloat3
	       :entry-point "_putsinglefloat_three" 
	       :return-type :void
	       :arguments '(single-float))
   (defforeign 'Cputsinglefloat4
	       :entry-point "_putsinglefloat_three" 
	       :return-type :void
	       :arguments '(single-float))
   (defforeign 'Cputdoublefloat
	       :entry-point "_putdoublefloat" 
	       :return-type :void
	       :arguments '(double-float))
   (defforeign 'Cputdoublefloat2
	       :entry-point "_putdoublefloat_two" 
	       :return-type :void
	       :arguments '(double-float fixnum))
   (defforeign 'Cgetsinglefloat
	       :entry-point  "_getsinglefloat"
	       :arguments nil
	       :return-type :single-float)
   (defforeign 'Cgetdoublefloat
	       :entry-point  "_getdoublefloat"
	       :arguments nil
	       :return-type :double-float)
   (defforeign 'Cputnfloat
	       :entry-point "_putnfloat" 
	       :arguments '(float fixnum))
   (defforeign 'Cgetpfloat
	       :entry-point "_getpfloat"
	       :return-type :double-float
	       :arguments '((simple-array float) fixnum fixnum))
   (defforeign 'Cputsinglefloatarray
	       :entry-point "_putsinglefloatarray"
	       :arguments '((simple-array single-float)))
   (defforeign 'Cputsinglefloatarray2
	       :entry-point "_putsinglefloatarray_two"
	       :arguments '((simple-array single-float) fixnum))
   (defforeign 'Cputsinglefloatarray3
	       :entry-point "_putsinglefloatarray_three"
	       :arguments '((simple-array single-float) fixnum))
   (defforeign 'Cputsinglefloatarray4
	       :entry-point "_putsinglefloatarray_four"
	       :arguments '((simple-array single-float) fixnum)))

(defun enable-libpq ()
  (setq *libpq-available* t))
