
;;;
;;;  MARKER-DISPLAY.CL
;;;  Functions used in displaying link-markers and bookmarks in
;;;  widgets of whatever media.
;;;

(in-package "PT")


;; need to scale x-vals by font-height and y-vals by font-width
(defun translate-to-window-coords (points w &optional (outer? nil))
  "given a list of points, returns a list of pixel coords for each
   point, adjusting to ensure that lines will be drawn around rather
   than through the region"
  (mapcar #'(lambda (p a) (translate-point p w a outer?))
	  points
	  (case (length points)
		(4 '(:tl :tr :br :bl))
		(6  (if (flush-left points w)
			'(:tl :tr :br :br :br :bl)
		      '(:tl :tr :br :bl :tl :tl)))
		(8 '(:tl :tr :br :br :br :bl :tl :tl)))))

(defun flush-left (pt-list  widget)
  (declare (ignore widget))  ;; for now...
  (eq (cdar pt-list) 0))


;; calculates region around marker, draws outline
(defmethod draw-marker ((lm link-marker) widget &optional (outer? nil))
  (when (region lm)
    (let ((pts (translate-to-window-coords 
		(marker-outline-points lm widget) widget outer?))
	  (links (filter (links-from lm))))
      (do-draw-outline (res widget) 
		       (if (null links) *dashed-gc* *solid-gc*)
		       pts)
      ;; if there is more than one link out of this marker, draw another
      ;; marker around it, just outside the first one:
      (when (not outer?)  ;; i.e., just drew inner region
	    (if (> (length links) 1)
		(draw-marker lm widget t)))
      )))

(defmethod draw-marker ((b bookmark) widget  &optional outer?)
  (declare (ignore outer?))
  (let ((pts (translate-to-window-coords 
	      (marker-outline-points b widget) widget nil)))
    (do-draw-outline (res widget) *bookmark-gc* pts)))

(defun do-draw-outline (res gc-res pts)
    ;; successively connect the points in the translated set:
    (mapcar #'(lambda (p1 p2)
		(xlib:draw-line res gc-res (car p1)
				(second p1) (car p2) (second p2)))
	    pts 
	    ;; list with 1st point moved to end, to ensure the region
	    ;; will be closed:
	    (append (cdr pts) (list (car pts)))))

