
;;;
;;;  LINK-SUPPORT.CL
;;;  Link manipulation stuff - starting/ending
;;;

(in-package "PT")

(defun start-link (node marker-or-region)
  "creates a new link emanating from the currently-selected marker or region"
  (let ((start (if (typep marker-or-region 'link-marker) marker-or-region
		    (make-link-marker 
		     :region marker-or-region
		     :parent node 
		     :label (if (typep node 'video-node)
				(get-index-key)
			      (get-string :prompt "Label for new marker: ")))
		    )))
    (when (not (eq marker-or-region start))  ;; i.e., had to make a new one
	;; change from reverse-video (marked region) to outlined:
	(unmark-marker #!hw@(node-panel node) start))
    (select-link-marker #!hw@(node-panel node) start)
    (feedback (format nil "Starting new link from ~a" (label start)))
    (make-link :source start :hyperdocs nil)))


(defun end-link (link node marker-or-region)
  "completes link, setting its dest to the currently-selected marker
   or region"
  (let ((end (if (typep marker-or-region 'link-marker) marker-or-region
		  (make-link-marker 
		   :region marker-or-region
		   :parent node
		   :label (if (typep node 'video-node)
			      (get-index-key)
			    (get-string :prompt "Label for new marker: ")))
		  )))
    (when (not (eq marker-or-region end))
	(unmark-marker #!hw@(node-panel node) end)
	(select-link-marker #!hw@(node-panel node) end))
    (set-dest link end)
    (add-obj link #!*current-hyperdoc*)
    (feedback (format nil "Ended link at ~a" (label end)))
    link))
    

