
;;;
;;;  HYPER-IMAGE-WIDGET
;;;  Widget for displaying image nodes in HIP:
;;;     

(in-package "PT")

;;;  Relevant slots from image-gadget: src-x/y/width/height;
;;;  bitmap-p (?)

(defclass hyper-image-widget (hypermedia-mixin image-widget)
  (
;;  (event-mask :initform '(:button-press :button-1-motion :keypress
;;					 :exposure :double-click))
   )
  (:documentation "Image widgets with hypermedia behavior"))

(defun make-hyper-image-widget (&rest args)
  (apply #'make-instance 'hyper-image-widget args))

(defmethod new-instance ((self hyper-image-widget) 
			 &key node 
			 &allow-other-keys)
  (call-next-method)
  (when node
	(setf (viewer node) self)
	(setup-node self node))
  ;; temporary kludge to get these guys to listen to the right events:
  (register-callback (widget self) #'show-link-menu 
		     :button-press :detail :left-button :state :control)
  (register-callback (widget self) #'follow-default-link
		     :button-press :detail :middle-button :state :control)
  (register-callback (widget self) #'hyper-position-mark
		     :button-press :detail :right-button))
  

(defmethod widget ((self hyper-image-widget))
  ;; no underlying widget here, since we inherit from image-widget
  self)

;;;
;;;  Method for setting up node correctly:
;;;

(defmethod setup-node ((self hyper-image-widget) (n image-node))
  ;; get the contents of the image file and put them into the buffer:
  (setf (value self) 
	(if (bitmap-p n) (make-image :file (dataset n))
	  (make-image :gif-file (dataset n))))
  (unmodify n)
  )

;;;
;;; Methods for setting and querying the current state of the widget:
;;;

(defmethod get-current-position ((self hyper-image-widget))
  '(0 0))

(defmethod set-position ((self hyper-image-widget)
			 &key &allow-other-keys)
  nil)

(defmethod get-mark-region ((self hyper-image-widget))
  "returns marked region as ((br  bc) (er  ec)).  
   For now, just returns whole region, represented as ((0 0) (1 1))"
  '((0 0) (1 1)))


(defmethod get-current-link-marker ((self hyper-image-widget)) 
  (car (link-markers (node self))))

(defmethod unmark-marker ((self hyper-image-widget) (b marker))
  nil)

(defmethod exposed-markers ((self hyper-image-widget))
  (markers (node self)))

(defmethod scroll-to ((self hyper-image-widget) offset)
  (declare (ignore offset))
  nil)

;;; Methods for outlining marker regions:

(defmethod marker-outline-points (marker (widget hyper-image-widget))
  "returns a set of (row, col) points defining the region"
  (let* ((beg (offset marker))
	 (end (endpt marker))
	 (x1 (car beg)) (y1 (cadr beg))
	 (x2 (car end)) (y2 (cadr end)))
    (list beg (list x2 y1) end (list x1 y2))))

(defmethod translate-point (pt (widget hyper-image-widget) &optional (adjust :tl) (outer? nil))
  "translates pt to coordinates of widget, adjusting so actual point
   will be outside of text region"
  ;; Adjust values are :tl, :tr, :bl, :br (for top/bottom, right/left).
  ;; For images, marker region represents percentage of image, so we
  ;; need to scale according to current size.
  (let* ((top (y-offset widget))
	 (left (x-offset widget))
	 (x-scale (car pt))
	 (y-scale (cadr pt))
	 (wi (width widget))
	 (hi (height widget))
	 (x-val (* x-scale wi))
	 (y-val (* y-scale hi))
	 (wi-adjust (if outer? -4 -3))
	 (hi-adjust (if outer? -4 -2))
	 )
    ;; adjust x and y so lines go in proper spaces between rows/cols
    (case adjust
	  (:tl (list (- left wi-adjust) (- top hi-adjust)))
	  (:tr (list (+ left x-val wi-adjust) (- top hi-adjust)))
	  (:bl (list (- left wi-adjust) (+ top y-val hi-adjust)))
	  (:br (list (+ left x-val wi-adjust) (+ top y-val hi-adjust)))
	  (otherwise (list x-val y-val))
	  )))
