
;;;
;;;  FAKE-SOH.CL
;;;  This file contains dummy functions to replace SOH
;;;

(in-package "CLOS")

(defun initdb (dbname) 
  (format t "Opening database ~S~%" dbname)
  dbname)

(defun closedb ()
  (format t "Closing database"))

(defclass dbclass (object)
  ())

(defclass dbobject (dbclass)
  ((objid)))

;; In header file
;; (defmacro defdbclass (name includes slots &rest options)
;;  `(defclass ,name ,includes ,slots ,@(clean-options options)))


(defmethod *initialize-instance ((instance dbobject) &rest initargs)
  (apply #'shared-initialize instance t initargs))

(defmethod initialize ((self dbobject) init-plist)
  (initialize-from-defaults self)
  (initialize-from-init-plist self init-plist))

(defmethod get-dbobject ((self dbobject))
  (fetch-dbobject self 'clos::deferred-update))

(defmethod store-dbobject ((self dbobject) &optional
			   store-components-p)
  (declare (ignore store-components-p))
  (format t "Storing dbobject ~S~%" self))

(defmethod delete-dbobject ((self dbobject) &optional no-error-p)
  (declare (ignore no-error-p))
  (format t "Deleting dbobject ~S~%" self))


(defmethod fetch-dbobject ((self dbobject) dbmode &optional
			   no-error-p)
  (declare (ignore dbmode no-error-p))
  (format t "Fetching dbobject ~S~%" self))

(defmethod mfetch-dbobject ((self standard-class) slot-name slot-value
			    dbmode
			    &optional no-error-p)
  (declare (ignore slot-name slot-value))
  (mfetch-dbobject-where self nil dbmode no-error-p))

(defmethod mfetch-dbobject-where ((self standard-class) where dbmode
			    &optional no-error-p)
  (declare (ignore where dbmode no-error-p))
  (let ((name (class-name self)))
       ;; have to see if we've loaded the fake data; should do it via
       ;; the find-module-named and find-system-named functions, but
       ;; those are causing package problems...
       (format t "Fetching nodes of type ~S~%" name)))
       ;; (cond ((eq name 'pt::node) (pt::fake-nodes))
	     ;;((eq name 'pt::hyperdoc) (pt::fake-hyperdocs))
	     ;;((eq name 'pt::link) (pt::fake-links))
	     ;;((eq name 'pt::link-marker) (pt::fake-link-markers))
	     ;;(t (format t "Fetching nodes of type ~S~%" name)
		;;nil))))

(defun save-object-cache ()
	(format t "Storing all database objects~%"))
