;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: johnb $
;;; $Source: /pic2/picasso/new/widgets/graphic/RCS/2d-vector.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1991/07/19 18:24:50 $
;;;

(in-package "PT")

;; (proclaim '(optimize (speed 3) (safety 0)))

;;; =================== 2D vector allocation routines =============

(defun alloc-2d (x y)
  (if (zerop (fill-pointer *2d-vector-free-array*))
      (make-2d-point :x x :y y)
      (let ((rv (vector-pop *2d-vector-free-array*)))
	   (setf (2d-point-x rv) x 
		 (2d-point-y rv) y)
	   rv)))

;; =============== 2d-vector manipulation routines ==========================

(defun duplicate-2d (v)
  (let ((rv (alloc-2d 0 0)))
       (2dv-copy rv v)
       rv))

(defun 2dv-length (v1)
  "Return the length of a vector."
  (let ((x (2d-point-x v1))
	(y (2d-point-y v1)))
       (sqrt (+ (* x x) (* y y)))))

(defun 2dv-scale! (v1 sf)
  "Destructively scale the vector by a factor."
  (setf (2d-point-x v1) (* sf (2d-point-x v1))
	(2d-point-y v1) (* sf (2d-point-y v1)))
  v1)

(defun 2dv-normalize! (v1 &aux (len (2dv-length v1)))
  "Destructively normalize the vector."
  (if (= len 0.0)
      v1
      (2dv-scale! v1 (/ 1.0 len))))

(defun 2dv-scale (v1 sf)
  "Scale the vector by a factor."
  (let ((rv (alloc-2d (2d-point-x v1) (2d-point-y v1))))
       (2dv-scale! rv sf)))

(defun 2dv-normalize (v1)
  "Normalize the vector."
  (let ((rv (alloc-2d (2d-point-x v1) (2d-point-y v1))))
       (2dv-normalize! rv)))

(defun 2dv-dot-product (v1 v2)
  "Return dot product of two vectors."
  (+ (* (2d-point-x v1) (2d-point-x v2))
     (* (2d-point-y v1) (2d-point-y v2))))

(defun 2dv-negate (v1)
  "Return a negated copy of the vector"
  (alloc-2d (- (2d-point-x v1)) (- (2d-point-y v1))))

(defun 2dv-negate! (v1)
  "Negate the vector passed"
  (setf (2d-point-x v1) (- (2d-point-x v1))
	(2d-point-y v1) (- (2d-point-y v1)))
  v1)

(defun 2dv- (v1 v2)
  "The - function for vectors. Returns the difference of the vectors."
  (alloc-2d (- (2d-point-x v1) (2d-point-x v2)) 
	    (- (2d-point-y v1) (2d-point-y v2))))

(defun 2dv-! (v1 v2)
  "Destructive - function for vectors. Returns the difference of the vectors."
  (setf (2d-point-x v1) (- (2d-point-x v1) (2d-point-x v2))
	(2d-point-y v1) (- (2d-point-y v1) (2d-point-y v2)))
  v1)

(defun 2dv+ (v1 v2)
  "The + function for vectors. Returns the sum of the vectors."
  (alloc-2d (+ (2d-point-x v1) (2d-point-x v2)) 
	    (+ (2d-point-y v1) (2d-point-y v2))))

(defun 2dv+! (v1 v2)
  "Destructive + function for vectors. Returns the sum of the vectors."
  (setf (2d-point-x v1) (+ (2d-point-x v1) (2d-point-x v2))
	(2d-point-y v1) (+ (2d-point-y v1) (2d-point-y v2)))
  v1)
