;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/framework/RCS/tool.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:07:22 $
;;;

(in-package "PT")

;;;
;;; tool window class
;;;

(defclass tool (top-level-po)
  (
   ;;  Defaults for inherited slots
   (name :initform "A Picasso Tool")
   (event-mask 
    :initform '(:exposure :enter-window :leave-window :structure-notify))
   (gm :initform 'packed-gm)
   (conform :initform :dont-conform)
   (x-offset :initform 200)
   (y-offset :initform 200)
   (width :initform 500)
   (height :initform 400)
   (border-width :initform 0)

   ;;  The title to be displayed 

   (title :initarg :title  
	  :initform "A Picasso Tool" 
	  :type string 
	  :accessor title)

   ;;  Slots for keeping track of the start and current frames

   (start-frame 
    :initarg :start-frame  
    :initform nil 
    :type list 
    :accessor start-frame)
   (start-frame-args
    :initarg :start-frame-args  
    :initform nil 
    :type list 
    :accessor start-frame-args)

   ;;  Slots for holding the tool's PSL and the PSL to be restored on tool exit

   (psl 
    :initarg :psl  
    :initform nil 
    :type list 
    :accessor psl)
   (prev-psl 
    :initarg :prev-psl  
    :initform nil 
    :type list 
    :accessor prev-psl)))

(defun make-tool (&rest keys)
  (apply #'make-instance 'tool :allow-other-keys t keys))

;;;
;;; class event mapping for tool
;;;

(defhandler ignore ((self tool) &rest args
                    &default :visibility-notify)
  (declare (ignore self args)))

;;;
;;; tool initialization method
;;;

(defmethod new-instance ((self tool)
			 &key
			 (icon nil)
			 (psl nil)
			 &allow-other-keys)

  (call-next-method)

  (setf (icon-name self) (or (icon-name self) (title self)))
  (setf (psl self) (pushnew (car (po-name self)) psl))

  (if (icon-p icon)
      (setf (window icon) self)
      (setf (icon self)
	    (if (stringp icon)
		(make-icon :parent (parent self)
			   :display (display self)
			   :image (make-image :file icon) :window self)
              (if (image-p icon)
                  (make-icon :parent (parent self)
                             :display (display self)
                             :image icon
                             :window self)
 		  (make-icon :parent (parent self)
			     :display (display self)
			     :image (make-image :file "picasso.icon")
			     :window self)))))

  self)



(defmethod invoke :around ((self tool) &rest arguments &aux sf sfa)
  (setf *gc-allowed* nil)
  (setf (prev-psl self) (package-search-list))
  (include-package (psl self))
  (if (eql (name-type (po-name self)) :qualified)
      (include-package (car (po-name self))))
  (call-next-method)
  (push-tool self)
  (setq sf (or (getf arguments :start-frame) (start-frame self)))
  (setq sfa (or (getf arguments :start-frame-args) (start-frame-args self)))
  (push-env self)
  (setq sfa (mapcar #'eval sfa))
  (pop-env)
  (catch self 
         (progn
	  (if sf (apply #'invoke #!((lookup sf)) sfa)
	      (apply #'invoke (value (lookup (car (frames self)) self)) sfa))
	  (event-discard (display self))
	  (event-loop :display (display self)))))


;; --------------------


(defmethod leave :after ((self tool) &optional (return-value nil))
  (xlib:unmap-window (res self))
  (flush-display (display self))
  (setq *package-search-list* (prev-psl self))
  (pop-tool)
  (setf *gc-allowed* t)
  (throw self return-value))


;;;
;;; tool window event handler(s)
;;;

(defhandler active ((self tool) &key display event-window &allow-other-keys
                         &default :enter-window)
  "Handle enter-window events on tool"
  ;; ignore events generated by children
  (when (eql event-window (res self))
	;; Sleep and check for leave event
	(xlib:display-finish-output display)
	(sleep 0.2)
	(let ((in-window t)
	      (tool-res (res self)))
	     (event-sync 
	      :display (display self)
	      :handler
	      #'(lambda (&key event-window event-key 
			   &allow-other-keys)
			(when (and (eq event-window tool-res)
				   (eq event-key :leave-notify))
			      (setq in-window nil))
			;; don't discard event
			nil))
	     
	     (if (not in-window)
		 (return-from tool-active)))
	
	;; Raise the window
	(if (autoraise self) (raise self))
	(if (current-frame) 
	    (enter-form (current-frame)))))

(defhandler inactive ((self tool) &key display event-window &allow-other-keys
                      &default :leave-window)
  "Handle leave-window events on tool"
  ;; ignore events generated by children
  (when (eql event-window (res self))
	;; Sleep and check for leave event
	(xlib:display-finish-output display)
	(sleep 0.2) 
	(let ((in-window nil)
	      (tool-res (res self)))
	     (event-sync 
	      :display (display self)
	      :handler
	      #'(lambda (&key event-window event-key 
			   &allow-other-keys)
			(when (and (eq event-window tool-res)
				   (eq event-key :enter-notify))
			      (setq in-window t))
			;; don't discard event
			nil))
	     
	     (if in-window
		 (return-from tool-inactive)))
	(if (current-frame) 
	    (leave-form (current-frame)))))

