;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;

(in-package "PT")

(defun handle-alist (type list)
  (setq list (mapcar #'(lambda (x) (remove-quote x) x) list))
  (case type
	(:single-sexpr (car list))
        (:multiple-sexpr (if (and (= (length list) 1)
				  (listp list)
				  (listp (car list))
				  (listp (caar list))
				  (atom (caaar list)))
			     (car list)
			     list))
	(:object-eval-sexpr (if (typep (car list) 'standard-object)
				(car list)
				(eval (car list))))
	(:var-list (if (and (= (length list) 1)
                            (listp (car list))
		            (> (length (car list)) 2))
		       (car list)
		       list))))



(defun def-internal (po-class name arglist params clauses)
  (let ((doc "")
	(make-params nil)
	(ref-params nil)
	(value-params nil)
	(value-result-params nil)
	(value-update-params nil)
	(value-result-update-params nil)
	(param-type 'value)
	(alist (remove-if-not #'consp params)))

	(dolist (arg arglist)
		(case arg
		      (&value (setq param-type 'value))
		      (&val (setq param-type 'value))
		      (&value-result (setq param-type 'value-result))
		      (&val-res (setq param-type 'value-result))
		      (&copy-in (setq param-type 'value-result))
		      (&value-update (setq param-type 'value-update))
		      (&value-result-update (setq param-type 
						  'value-result-update))
		      (&value-update-result (setq param-type 
						  'value-result-update))
		      (&reference (setq param-type 'reference))
		      (&ref (setq param-type 'reference))
		      (otherwise
		       (case param-type
			     (value (push arg value-params))
			     (value-result (push arg value-result-params))
			     (value-update (push arg value-update-params))
			     (value-result-update 
			      (push arg value-result-update-params))
			     (reference (push arg ref-params))))))
       (when ref-params 
	     (push ref-params make-params)
	     (push :ref-params make-params))

       (when value-params 
	     (push value-params make-params)
	     (push :value-params make-params))

       (when value-update-params 
	     (push value-update-params make-params)
	     (push :value-update-params make-params))

       (when value-result-params 
	     (push value-result-params make-params)
	     (push :value-result-params make-params))

       (when value-result-update-params 
	     (push value-result-update-params make-params)
	     (push :value-result-update-params make-params))

       (setq doc (apply #'concatenate 
			(cons 'string  
			      (mapcan #'(lambda (x) (if (stringp x) (list x)))
				      params))))
       (unless (equal doc "")
	       (push doc make-params)
	       (push :doc make-params))

       (dolist (clause clauses)
	       (let ((item (car clause))
		     (type (second clause))
		     (aliases (cddr clause))
		     (tmp nil))
		    (block trythem
			   (dolist (name (cons item aliases))
				   (setq tmp (cdr (assoc name alist)))
				   (when tmp
					 (push (handle-alist type tmp)
					       make-params)
					 (push (colonize item) make-params)
					 (return-from trythem))))))

       (push name make-params)
       (push :po-name make-params)

       (let ((make-func (symbol-function  
                          (read-from-string
                            (concatenate 'string
                                         "make-"
                                         (string po-class))))))
            (register name (apply make-func make-params)))))
