;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;

;; This file contains handy stuff for the picasso environment

(in-package "PT")

;; change directory
#+allegro (tpl:alias "cd" (name) "change directory" 
	   (excl:chdir (string-downcase (string name))))

;; Print working directory
#+allegro (tpl:alias "pwd" () "print working directory" 
  (format *terminal-io* "~A~%" (namestring (excl:current-directory))))

;; change package
(#+allegro tpl:alias #+lucid defun 
  #+allegro "cp" #+lucid cp (name) "change package"
	   (let* ((symname (if (stringp name)
			       (read-from-string name)
			     name))
		  (package (find-package symname)))
	     (cond ((not (null package))
		    (setq name (string-downcase (package-name package)))
		    (setq *package* package)
		    (set-prompt (format nil "<~a> " name)))
		   (t
		    (warn "no package named ~s" symname)))))

;; Repeat an operation 100 times and time it
(#+allegro tpl:alias #+lucid defun 
  #+allegro "t100" #+lucid t100 (exp)
  (time (dotimes (i 100)
                 (eval exp))))

#+allegro (setq 
  top-level:*zoom-print-level* 5
  top-level:*zoom-print-length* 5
  top-level:*zoom-display* 10)

#+lucid (setq 
  *debug-print-level* 5
  *debug-print-length* 10)

;; Event loop
(#+allegro tpl:alias #+lucid defun 
  #+allegro "el" #+lucid el ()
    "A Picasso event loop"
       (pt::event-loop))

(#+allegro tpl:alias #+lucid defun
  #+allegro "ea" #+lucid ea ()
  "Expose and attach last object"
  (pt::expose (pt::attach *)))

(#+allegro tpl:alias #+lucid defun
  #+allegro "da" #+lucid da ()
  "Destroy all windows who are children of the root"
  (when (pt::current-display)
	(let ((rw (pt::root-window)))
	     (when (and rw (pt::res rw))
		   (mapc #'(lambda (x) (pt::conceal x) (pt::destroy x))
			 (pt::children rw))
		   (setf (pt::children rw) nil)))))

(#+allegro tpl:alias #+lucid defun
  #+allegro "ce" #+lucid ce ()
  "Clear Picasso Environment"
  (pt::clear-env))

;; load tmp
(#+allegro tpl:alias #+lucid defun
  #+allegro "lt" #+lucid lt ()
  "Load file named .tmp from home dir"
  (load "~/.tmp"))

;; compile tmp
(#+allegro tpl:alias #+lucid defun
  #+allegro "ct" #+lucid ct ()
  "Compile file named .tmp from home dir"
  (compile-file "~/.tmp"))

;; compile and load tmp
(#+allegro tpl:alias #+lucid defun
  #+allegro "clt" #+lucid clt ()
  "Compile and load file named .tmp from home dir"
  (compile-file "~/.tmp")
  (load "~/.tmp"))

;; Remove tmp
(#+allegro tpl:alias #+lucid defun
  #+allegro "rt" #+lucid rt ()
  "Remove file named .tmp.fasl from home dir"
  (shell-command "/bin/rm" "~/.tmp.fasl"))

;; load brian's .tmp.cl
(#+allegro tpl:alias #+lucid defun
  #+allegro "brian" #+lucid brian ()
  "Load file named .tmp from bsmith's dir"
  (load "~bsmith/.tmp"))

;; load joe's .tmp.cl
(#+allegro tpl:alias #+lucid defun
  #+allegro "joe" #+lucid joe ()
  "Load file named .tmp from konstan's dir"
  (load "~konstan/.tmp"))

;; load steve's .tmp.cl
(#+allegro tpl:alias #+lucid defun
  #+allegro "steve" #+lucid steve ()
  "Load file named .tmp from seitz's dir"
  (load "~seitz/.tmp"))

#+gsgc
;; gsgc setup
(progn
  ;; set gsgc switches
  (setf (sys:gsgc-switch :print) t)
  (setf (sys:gsgc-switch :stats) t)
  ;; make alias for :gc
  (tpl:alias "gc" (&rest args) "garbage collection"
	     (cond ((null args) (excl:gc))
		   ((eq :step (car args))
		    (sys:gsgc-step-generation)
		    (excl:gc))
		   ((eq :tenure (car args))
		    (excl:gc :tenure))
		   ((eq :t (car args))
		    (excl:gc t))
		   ((eq :show (car args))
		    (sys:gsgc-parameters))
		   ((eq :spread (car args))
		    (setf (sys:gsgc-parameter :generation-spread)
			  (cadr args)))
		   ((eq :auto (car args))
		    (setf (sys:gsgc-switch :auto-step)
			  (not (sys:gsgc-switch :auto-step))))
		   ((eq :room (car args))
		    (room t))
		   ((eq :print (car args))
		    (setf (sys:gsgc-switch :print)
			  (not (sys:gsgc-switch :print))))
		   (t
		    (format t ":gc [:step] [:tenure] [:show] [:auto] ")
		    (format t "[:spread <arg>] [:room] [:print]~%")))))

#+excl
(setq top-level:*history* 100)

(#+allegro tpl:alias #+lucid defun
  #+allegro "lw" #+lucid lw ()
  "Return the window on which the mouse is pressed"
  (pt::locate-window))

(defun cim ()
  (run-tool-named '("cim-desktop" "tool")))

(defun cimtool ()
  (run-tool-named '("cimtool" "tool")))

(defun mosaic ()
  (run-tool-named '("mosaic" "tool")))

(defun ved ()
  (run-tool-named '("ved" "tool")))

(defun test ()
  (run-tool-named '("test" "tool")))

(defun vp ()
  (run-tool-named '("vp" "tool")))

(defun paper ()
  (run-tool-named '("paper" "demo" . "tool")))

(defun hip (&optional (hyperdoc nil))
  (call (find-po-named '("new-hip" "hip" . "tool")) :hyperdoc hyperdoc))

(defun gwip ()
  (run-tool-named '("gwip" "tool")))