;;;
;;; Copyright (c) 1982 Regents of the University of California
;;; Copyright (c) 1987 Regents of the University of California
;;;
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 

(in-package "CLING")

;;;
;;; Load in the appropriate libq routines
;;;

#{(progn
   (unless *libq-loaded*
	   (pt::remove-foreign-symbol "__ubound")
	   (pt::remove-foreign-symbol "__malloc_at_addr")
	   (pt::remove-foreign-symbol "___mallinfo")
	   (pt::remove-foreign-symbol "__root")
	   (pt::remove-foreign-symbol "__lbound")
	   (pt::remove-foreign-symbol "_pclose")
	   (pt::remove-foreign-symbol "_realloc")
	   (pt::remove-foreign-symbol "_valloc")
	   (pt::remove-foreign-symbol "_calloc")
	   (pt::remove-foreign-symbol "_malloc")
	   (pt::remove-foreign-symbol "_memalign")
	   (pt::remove-foreign-symbol "_free")
	   (pt::remove-foreign-symbol "__ypsleeptime")
	   (pt::remove-foreign-symbol "_yp_bind")
	   (pt::remove-foreign-symbol "_yp_unbind")
	   (pt::remove-foreign-symbol "_yp_get_default_domain")
	   (pt::remove-foreign-symbol "__yp_dobind")
	   (pt::remove-foreign-symbol "__ypserv_timeout")
	   (pt::remove-foreign-symbol "_usingypmap")
	   (pt::remove-foreign-symbol "_cfree")
	   ;; these added after file-system changes to prevent
	   ;; "multiply defined" errors in Allegro
	   (pt::remove-foreign-symbol "_yp_ismapthere")
	   (pt::remove-foreign-symbol "_yp_softbind")
	   (pt::remove-foreign-symbol "__yp_dobind_soft")
	   ;; load the libq library via a slight hack
	   (setq *libq-loaded*
		 #+allegro
		 (load *libq-object-location*
		       :foreign-files *libq-foreign-files*
		       :system-libraries *libq-system-libraries*)
		 ;; system libs are loaded by default with l-f-libs in lucid
		 #+lucid
		 (load-foreign-files *libq-object-location*))
		 #+lucid
	         (load-foreign-libraries *libq-foreign-files*)
		 )
   #+allegro
   (defforeign 'ii-sqInit
	       :entry-point "_IIsqInit"
	       :arg-checking *libq-argument-check*
	       :arguments '(t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqInit
			  (:name "_IIsqInit")
			  (:return-type :null))
     (a :arbitrary))
   #+allegro
   (defforeign 'ii-writio
	       :entry-point "_IIwritio"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum fixnum fixnum fixnum simple-string)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-writio
			  (:name "_IIwritio")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum)
     (c :fixnum)
     (d :fixnum)
     (e :fixnum)
     (f :simple-string))
   #+allegro
   (defforeign 'ii-syncup
	       :entry-point "_IIsyncup"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-syncup
			  (:name "_IIsyncup")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum))
   #+allegro
   (defforeign 'ii-sqConnect
	       :entry-point "_myIIsqConnect"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string simple-string)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqConnect
			  (:name "_myIIsqConnect")
			  (:return-type :null))
     (a :simple-string)
     (b :simple-string))
   #+allegro
   (defforeign 'ii-sqDisconnect
	       :entry-point "_IIsqDisconnect"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqDisconnect
			  (:name "_IIsqDisconnect")
			  (:return-type :null)))
   #+allegro
   (defforeign 'ii-xact
	       :entry-point "_IIxact"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-xact
			  (:name "_IIxact")
			  (:return-type :null))
     (a :fixnum))
   #+allegro
   (defforeign 'ii-putdomio
	       :entry-point "_IIputdomio"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum fixnum fixnum t)
	       :return-type :fixnum)
   #+lucid
   (def-foreign-function (ii-putdomio
			  (:name "_IIputdomio")
			  (:return-type :fixnum))
     (a :fixnum)
     (b :fixnum)
     (c :fixnum)
     (d :fixnum)
     (e :arbitrary))
   #+allegro
   (defforeign 'ii-getdomio
	       :entry-point "_IIgetdomio"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum fixnum fixnum t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (iigetdomio
			  (:name "_IIgetdomio")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum)
     (c :fixnum)
     (d :fixnum)
     (e :arbitrary))
   #+allegro
   (defforeign 'ii-sqMods
	       :entry-point "_IIsqMods"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqMods
			  (:name "_IIsqMods")
			  (:return-type :null))
     (a :fixnum))
   #+allegro
   (defforeign 'ii-retinit
	       :entry-point "_IIretinit"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-retinit
			  (:name "_IIretinit")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum))
   #+allegro
   (defforeign 'ii-nextget
	       :entry-point "_IInextget"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :fixnum)
   #+lucid
   (def-foreign-function (ii-nextget
			  (:name "_IInextget")
			  (:return-type :fixnum)))
   #+allegro
   (defforeign 'ii-sqFlush
	       :entry-point "_IIsqFlush"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqFlush
			  (:name "_IIsqFlush")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum))
   #+allegro
   (defforeign 'ii-flush
	       :entry-point "_IIflush"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-flush
			  (:name "_IIflush")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum))
   #+allegro
   (defforeign 'ii-break
	       :entry-point "_IIbreak"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-break
			  (:name "_IIbreak")
			  (:return-type :null)))
   #+allegro
   (defforeign 'ii-errtest
	       :entry-point "_IIerrtest"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :fixnum)
   #+lucid
   (def-foreign-function (ii-errtest
			  (:name "_IIerrtest")
			  (:return-type :fixnum)))
   #+allegro
   (defforeign 'ii-reti
	       :entry-point "_myIIreti"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :integer)
   #+lucid
   (def-foreign-function (ii-reti
			  (:name "_myIIret")
			  (:return-type :signed-32bit)))
   #+allegro
   (defforeign 'ii-retf
	       :entry-point "_myIIretf"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :single-float)
   #+lucid
   (def-foreign-function (ii-retf
			  (:name "_myIIretf")
			  (:return-type :single-float)))
   #+allegro
   (defforeign 'ii-rets
	       :entry-point "_myIIrets"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string)
	       :return-type :integer)
   #+lucid
   (def-foreign-function (ii-rets
			  (:name "_myIIrets")
			  (:return-type :signed-32bit))
     (a :simple-string))
   #+allegro
   (defforeign 'ii-csOpen
	       :entry-point "_IIcsOpen"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csOpen
			  (:name "_IicsOpen")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum)
     (c :fixnum))
   #+allegro
   (defforeign 'ii-csClose
	       :entry-point "_IIcsClose"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csClose
			  (:name "_IIcsClose")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum)
     (c :fixnum))
   #+allegro
   (defforeign 'ii-csQuery
	       :entry-point "_IIcsQuery"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csQuery
			  (:name "_IIcsQuery")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum)
     (c :fixnum))
   #+allegro
   (defforeign 'ii-csRetrieve
	       :entry-point "_IIcsRetrieve"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum fixnum)
	       :return-type :fixnum)
   #+lucid
   (def-foreign-function (ii-csRetrieve
			  (:name "_IIcsRetrieve")
			  (:return-type :fixnum))
     (a :simple-string)
     (b :fixnum)
     (c :fixnum))
   #+allegro
   (defforeign 'ii-csERetrieve
	       :entry-point "_IIcsERetrieve"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csERetrieve
			  (:name "_IIcsERetrieve")
			  (:return-type :null)))
   #+allegro
   (defforeign 'ii-csDelete
	       :entry-point "_IIcsDelete"
	       :arg-checking *libq-argument-check*
	       :arguments '(t simple-string fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csDelete
			  (:name "_IIcsDelete")
			  (:return-type :null))
     (a :arbitrary)
     (b :simple-string)
     (c :fixnum)
     (d :fixnum))
   #+allegro
   (defforeign 'ii-csERplace
	       :entry-point "_IIcsERplace"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csERplace
			  (:name "_IIcsERplace")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum)
     (c :fixnum))
   #+allegro
   (defforeign 'ii-csDaGet
	       :entry-point "_IIcsDaGet"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csDaGet
			  (:name "_IIcsDaGet")
			  (:return-type :null))
     (a :fixnum)
     (b :arbitrary))
   #+allegro
   (defforeign 'ii-sqDaIn
	       :entry-point "_IIsqDaIn"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqDaIn
			  (:name "_IIsqDaIn")
			  (:return-type :null))
     (a :fixnum)
     (b :arbitrary))
   #+allegro
   (defforeign 'ii-csGetio
	       :entry-point "_IIcsGetio"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum fixnum fixnum fixnum t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-csGetio
			  (:name "_IIcsGetio")
			  (:return-type :null))
     (a :fixnum)
     (b :fixnum)
     (c :fixnum)
     (d :fixnum)
     (e :arbitrary))
   #+allegro
   (defforeign 'ii-csGeti
	       :entry-point "_mycsGeti"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :integer)
   #+lucid
   (def-foreign-function (ii-csGeti
			  (:name "_mycsGeti")
			  (:return-type :signed-32bit)))
   #+allegro
   (defforeign 'ii-csGetf
	       :entry-point "_mycsGetf"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :single-float)
   #+lucid
   (def-foreign-function (ii-csGetf
			  (:name "_mycsGetf")
			  (:return-type :single-float)))
   #+allegro
   (defforeign 'ii-csGets
	       :entry-point "_mycsGets"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string)
	       :return-type :integer)
   #+lucid
   (def-foreign-function (ii-csGets
			  (:name "_mycsGets")
			  (:return-type :signed-32bit))
     (a :simple-string))
   #+allegro
   (defforeign 'ii-sqExImmed
	       :entry-point "_IIsqExImmed"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqExImmed
			  (:name "_IIsqExImmed")
			  (:return-type :null))
     (a :simple-string))
   #+allegro
   (defforeign 'ii-sqPrepare
	       :entry-point "_IIsqPrepare"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum simple-string fixnum fixnum t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqPrepare
			  (:name "_IIsqPrepare")
			  (:return-type :null))
     (a :fixnum)
     (b :simple-string)
     (c :fixnum)
     (d :fixnum)
     (e :arbitrary))
   #+allegro
   (defforeign 'ii-sqExStmt
	       :entry-point "_IIsqExStmt"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqExStmt
			  (:name "_IIsqExStmt")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum))
   #+allegro
   (defforeign 'ii-sqDescribe
	       :entry-point "_IIsqDescribe"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum simple-string t fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-sqDescribe
			  (:name "_IIsqDescribe")
			  (:return-type :null))
     (a :fixnum)
     (b :simple-string)
     (c :arbitrary)
     (d :fixnum))
   #+allegro
   (defforeign 'ii-eqiqi
	       :entry-point "_myeqiqioi"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string)
	       :return-type :integer)
   #+lucid
   (def-foreign-function (ii-eqiqi
			  (:name "_myeqiqioi")
			  (:return-type :signed-32bit))
     (a :simple-string))
   #+allegro
   (defforeign 'ii-eqiqf
	       :entry-point "_myeqiqiod"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string)
	       :return-type :single-float)
   #+lucid
   (def-foreign-function (ii-eqiqf
			  (:name "_myeqiqiod")
			  (:return-type :single-float))
     (a :simple-string))
   #+allegro
   (defforeign 'ii-eqiqs
	       :entry-point "_myeqiqios"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string simple-string)
	       :return-type :integer)
   #+lucid
   (def-foreign-function (ii-eqiqs
			  (:name "_myeqiqios")
			  (:return-type :signed-32bit))
     (a :simple-string)
     (b :simple-string))
   #+allegro
   (defforeign 'ii-LQpriProcInit
	       :entry-point "_IILQpriProcInit"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum simple-string)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-LQpriProcInit
			  (:name "_IILQpriProcInit")
			  (:return-type :null))
     (a :fixnum)
     (b :simple-string))
   #+allegro
   (defforeign 'ii-LQprvProcValio
	       :entry-point "_IILQprvProcValio"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum fixnum fixnum fixnum fixnum t)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-LQprvProcValio
			  (:name "_IILQprvProcValio")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum)
     (c :fixnum)
     (d :fixnum)
     (e :fixnum)
     (f :fixnum)
     (g :arbitrary))
   #+allegro
   (defforeign 'ii-LQprvI
	       :entry-point "_myIILQprvI"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-LQprvI
			  (:name "_myIILQprvI")
			  (:return-type :null))
     (a :simple-string)
     (b :fixnum))
   #+allegro
   (defforeign 'ii-LQprvF
	       :entry-point "_myIILQprvF"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string single-float)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-LQprvF
			  (:name "_myIILQprvF")
			  (:return-type :null))
     (a :simple-string)
     (b :single-float))
   #+allegro
   (defforeign 'ii-LQprvS
	       :entry-point "_myIILQprvS"
	       :arg-checking *libq-argument-check*
	       :arguments '(simple-string simple-string)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-LQprvS
			  (:name "_myIILQprvS")
			  (:return-type :null))
     (a :simple-string)
     (b :simple-string))
   #+allegro
   (defforeign 'ii-LQprsProcStatus
	       :entry-point "_IILQprsProcStatus"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :fixnum)
   #+lucid
   (def-foreign-function (ii-LQprsProcStatus
			  (:name "_IILQprsProcStatus")
			  (:return-type :fixnum)))
   #+allegro
   (defforeign 'ii-putctrl
	       :entry-point "_IIputctrl"
	       :arg-checking *libq-argument-check*
	       :arguments '(fixnum)
	       :return-type :void)
   #+lucid
   (def-foreign-function (ii-putctrl
			  (:name "_IIputctrl")
			  (:return-type :null))
     (a :fixnum))
   #+allegro
   (defforeign 'sqlca-loc
	       :entry-point "_sqlcaLoc"
	       :arg-checking *libq-argument-check*
	       :arguments nil
	       :return-type :fixnum)
   #+lucid
   (def-foreign-function (sqlca-loc
			  (:name "_sqlcaLoc")
			  (:return-type :fixnum)))
   )
;;;
;;; SQL Descriptor Area (sqlda) for Dynamic SQL
;;;

(setq sqlda (make-sqlda))

;;;
;;; system level database commands
;;;
(defun system-level-db-command (command dbname &optional flags)
  #+allegro
  (excl:run-shell-command
   (concatenate 'simple-string 
		(string command) " " (string flags) " " (string dbname)))
  #+lucid
  (run-program command :arguments (list flags dbname)))

;;;
;;; full path name
;;;
(defun full-path-name (name)
  (if (eql #\/ (char name 0))
      name
    (concatenate 'simple-string 
		 (namestring (pt::get-cur-directory)) name)))

(defun enable-cling ()
  (setq *cling-available* t)
  (setq to-ingres t)
  (setq show-query nil)
  (setq sqlca-ptr (sqlca-loc)))
