;;; 
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: bsmith $
;;; $Source: RCS/colormap.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 91/08/04 19:03:13 $
;;;

(in-package "PT")

(defclass colormap (pmc)
  ((res
    :initform nil
    :type vector
    :reader res)
   (name
    :initarg :name
    :initform ""
    :type string
    :reader name)
   (visual
    :initarg :visual
    :initform nil
    :type visual
    :reader visual)
   (screen
    :initarg :screen
    :initform nil
    :type screen
    :reader screen)
   (hashtab
    :initarg :hashtab
    :initform nil
    :type hash-table
    :reader hashtab)))

(defun make-colormap (&rest args)
  (apply #'make-instance 'colormap :allow-other-keys t args))

(defun get-color (&optional name spec)
  (cond ((null name) (white-color))
	((colormap-p spec) 
	 (gethash name (hashtab spec)))
	((window-p spec)
	 (gethash name (hashtab (colormap spec))))
	((display-p spec)
	 (gethash name (hashtab (default-colormap spec))))
	((screen-p spec)
	 (gethash name (hashtab (default-colormap spec))))
	(spec
	 (error "get-color: illegal second argument \'~s\'" spec))
	(t (gethash name (hashtab (current-colormap))))))

(defmethod new-instance ((self colormap)
			 &key
			 (visual	nil)
			 (window	nil)
			 (screen	nil)
			 (res		nil)
			 (name		nil)
			 &allow-other-keys)
  (if screen
      (setq window (root screen))
      (setq screen (screen window)))
  (unless window 
	  (setf (slot-value self 'window) 
		(setq window (root-window))))
  (setf (slot-value self 'screen) screen)
  (unless visual
	  (setf (slot-value self 'visual)
		(setq visual (xlib:window-visual (res window)))))
  (setf (slot-value self 'res)
	(if res res (xlib:create-colormap visual (res window))))
  (setf (slot-value self 'hashtab)
	(make-hash-table :size 5 :rehash-size 5 :test #'equal))
  
  (when name
	(when (null (colormap-table screen))
	      (let ((ctab (make-hashtable :size 10 :test #'equal)))
		   (setf (gethash nil ctab) (current-colormap screen))
		   (setf (slot-value screen 'colormap-table) ctab)))
	(setf (gethash name (colormap-table screen)) self)))

(defmethod do-attach ((self colormap))
  (xlib:install-colormap (res self)))

(defmethod do-detach ((self colormap))
  (xlib:uninstall-colormap (res self)))

