;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/resource/font.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:13 $
;;;

(in-package "PT")

;;;
;;; Definition of the font class
;;;
(defclass font (pmc)
  ((res
    :initform nil
    :type vector
    :reader res)
   (name
    :initarg :name
    :initform *default-font-name*
    :type string
    :reader name)
   (display
    :initarg :display
    :initform nil
    :type display
    :reader display)
   (ref-count
    :initform 0
    :type integer
    :reader ref-count)))

;;;
;;; 	Dimension accessors
;;;

(defmethod width ((self font)
		  &key 
		  &allow-other-keys)
  (if (attached-p self)
      (xlib:max-char-width (res self))
      0))

(defmethod font-width (self)
  (if (stringp self)
      (font-width (get-font self))
      (if (attached-p self)
	  (xlib:max-char-width (res self))
	  0)))

(defun font-ascent (font &optional gc)
  (if (stringp font)
      (font-height (get-font font) gc)
      (if font 
	  (cond ((font-p font)
		 (if (attached-p font)
		     (xlib:max-char-ascent (res font))
		     0))
		((xlib:font-p font)
		 (xlib:max-char-ascent font))
		(t (error "font-ascent: bad font \'~s\'" font)))
	  (if (and (xlib:gcontext-p gc) (setq font (xlib:gcontext-font gc))) 
	      (xlib:max-char-ascent font)
	      0))))

(defun font-descent (font &optional gc)
  (if (stringp font)
      (font-height (get-font font) gc)
      (if font 
	  (cond ((font-p font)
		 (if (attached-p font)
		     (xlib:max-char-descent (res font))
		     0))
		((xlib:font-p font)
		 (xlib:max-char-descent font))
		(t (error "font-height: bad font \'~s\'" font)))
	  (if (and (xlib:gcontext-p gc) (setq font (xlib:gcontext-font gc))) 
	      (xlib:max-char-descent font)
	      0))))

(defun font-height (font &optional gc)
  (if (stringp font)
      (font-height (get-font font) gc)
      (if font 
	  (cond ((font-p font)
		 (if (attached-p font) 
		     (+ (xlib:max-char-ascent (res font))  
			(xlib:max-char-descent (res font))) 
		     0))
		((xlib:font-p font)
		 (+ (xlib:max-char-ascent font)  
		    (xlib:max-char-descent font))) 
		(t (error "font-height: bad font \'~s\'" font)))
	  (if (and (xlib:gcontext-p gc) (setq font (xlib:gcontext-font gc))) 
	      (+ (xlib:max-char-ascent font)  
		 (xlib:max-char-descent font))
	      0))))

(defmethod height ((font font))
  (if (stringp font)
      (font-height (get-font font))
      (cond ((font-p font)
	     (if (attached-p font) 
		 (+ (xlib:max-char-ascent (res font))  
		    (xlib:max-char-descent (res font))) 
		 0))
	    ((xlib:font-p font)
	     (+ (xlib:max-char-ascent font)  
		(xlib:max-char-descent font))) 
	    (t (error "font-height: bad font \'~s\'" font)))))

;;;
;;;	Path accessors
;;;

(defun font-path (&optional (display (current-display)))
  (xlib:font-path (res display)))

(defun set-font-path (val &optional (display (current-display)))
  (setf (xlib:font-path (res display)) val))

(defun setf-font-path (val)
  (setf (xlib:font-path (res (current-display))) val))

;;;
;;;	Lookup font in table
;;;

(defun get-font (&optional (name *default-font-name*) 
			   spec &aux display)
  (setq display
	(cond ((window-p spec)
	       (display spec))
	      ((display-p spec)
	       spec) 
	      (t (current-display))))
  (gethash name (font-table display)))

;;;
;;;	Create a new font instance or retrieve an old one. . .
;;;

(defun make-font (&key
		  (name *default-font-name*)
		  (display (current-display))
		  (attach-p nil)
		  &allow-other-keys
		  &aux font) 
  ;;  set display 
  (if (not (display-p display))
      (setq display (current-display))) 

  ;;  test font, defaulting if invalid
  (setq font 
	(cond ((setq font (get-font name display))
	       font)
	      ((stringp name)
	       (if (font-name-p name display)
		   (make-instance 'font :name name :display display
				  :allow-other-keys t)
		   (progn
		    (warn "make-font: Invalid font-name: \'~s\'." name)
		    (get-font))))
	      (t (get-font))))

  ;;  attach if needed
  (when attach-p (do-attach font))
  font)

(defmethod new-instance ((self font)
			 &key (ignore nil)
			 (display (current-display))
			 &allow-other-keys)
  (declare (ignore ignore))
  
  ;; put in hashtable
  (setf (gethash (name self) (font-table display)) self))

;;;
;;;	Attach & Detach methods
;;;

(defmethod do-attach  ((self font)) 
  (incf (slot-value self 'ref-count))
  (unless (res self)
	  (setf (slot-value self 'res)
		(xlib:open-font (res (display self)) (name self)))))

(defmethod do-detach ((self font) &aux res)
  (when (zerop (decf (slot-value self 'ref-count)))
	(when (setq res (res self))
	      (xlib:close-font res)
	      (setf (slot-value self 'res) nil))))

