;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/picasso/propagator.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:07 $
;;;

(in-package "PT")

;; nice debugging tool

(defun dumphash (tab)
  (maphash #'(lambda (k v) (format t "~S:  ~S~%" k v)) tab))

#{(setf (gethash (cons 'value (find-class 'variable)) *class-meth-table*) t)

;;; Update, expressions are expected to be without any remaining local
;;; variable references.  To accomplish this, they should generally
;;; be created in backquote form.  for instance, 
;;;
;;; (bind-slot 'sname win1 `(concatenate 'string (var name ,win2)))
;;;

(defun bind-var-internal (name reference expression &key (receipt nil))
  (bind-slot 'value (find-var name reference) (var-adjust expression reference) 
	     :receipt receipt))

(defun var-adjust (expression reference)
  (cond ((atom expression) expression)
	((var-p expression) (append expression (list :ref reference)))
	(t (cons (var-adjust (car expression) reference)
		 (var-adjust (cdr expression) reference)))))

(defun bind-slot (slot object expression &key (receipt nil))
  (let* ((dependees (get-dependees expression object))
	 (function (po-get-function expression object))
	 (ftab-entry (cons function (mapcar #'cdr dependees)))
	 (key `(,slot ',object)))
	
	;; create appropriate methods for virtual slots
	(unless (slot-exists-p object slot)
		(eval `(defmethod ,slot ((self (eql ',object)))
				  (if (next-method-p) (call-next-method)
				      ,function)))
		(if *compile-dynamic-methods*
		    (compile `(method ,slot ((eql ,object))))
		    (push `(compile '(method ,slot ((eql ,object))))
			  *dynamic-method-compilation-queue*))
		(eval `(defmethod (setf ,slot) (value (self (eql ',object)))
				  (declare (ignore value))
				  (if (next-method-p) (call-next-method))))
		(if *compile-dynamic-methods*
		    (compile `(method (setf ,slot) (t (eql ,object))))
		    (push `(compile '(method (setf ,slot) (t (eql ,object))))
			  *dynamic-method-compilation-queue*))
		)
	
	;; process the dependee list
	(when (null dependees)
	      (unbind-from-deplist-internal key nil)
	      (unless (null function) 
		      (warn "Bind-slot should not be used with
			    constants")))
	
	(dolist (d dependees)
		(let ((new-d (cdr d)))
		     
		     ;; add the location to the hash table
		     
		     (pushnew key (gethash new-d *prop-table*) :test #'equal)
		     
		     ;; handle checking for methods
		     (if (= (incf (gethash new-d *meth-table* 0)) 1)
			 (case (car d)
			       (slot 
				(eval 
				 `(defmethod (setf ,(car new-d)) :around
					     (value (self (eql ,(cadr new-d))))
					     (unless (equal (slot-value self ',(car new-d))
							    value)
						     (call-next-method)
						     (propagate (gethash ',new-d *prop-table*)
								',new-d))))
				(if *compile-dynamic-methods*
				  (compile `(method (setf ,(car new-d)) :around
						    (t (eql ,(cadadr new-d)))))
				  (push `(compile 
					  '(method (setf ,(car new-d)) :around
						   (t (eql ,(cadadr new-d)))))
					*dynamic-method-compilation-queue*)))
			       (vslot
				(eval
				 `(defmethod (setf ,(car new-d)) :around
					     (value (self (eql ,(cadr new-d))))
					     (declare (ignore value))
					     (if (next-method-p) (call-next-method))
					     (propagate (gethash ',new-d *prop-table*)
							',new-d)))
				(if *compile-dynamic-methods*
				  (compile `(method (setf ,(car new-d)) :around
						    (t (eql ,(cadadr new-d)))))
				  (push `(compile 
					  '(method (setf ,(car new-d)) :around
						   (t (eql ,(cadadr new-d)))))
					*dynamic-method-compilation-queue*)))))
		     
		     ;;;  Now, let's deal with the actual function
		     (let* ((fkey (cons key new-d))
			    (func-list (gethash fkey *func-table*))
			    (unbind-list 
			     (mapcan #'(lambda (func) 
					       (cond 
						((replaces (cdr func) 
							   (mapcar #'cdr
								   dependees))
						 (list (cons key func)))))
				     func-list)))
			   (pushnew ftab-entry (gethash fkey *func-table*) 
				    :test #'equal)
			   (setq unbind-list (delete (cons key ftab-entry) 
						     unbind-list 
						     :test #'equal))
			   (mapc #'unbind-internal unbind-list)
			   (when receipt 
				 (setq receipt (gensym))
				 (setf (gethash receipt *unbind-table*) 
				       (cons key ftab-entry))))))
	(eval `(setf (,slot ',object) ,function)))
  receipt)

(defun unbind-internal (receipt)
  (let* ((dest (car receipt))
	 (pair (cdr receipt))
	 (places (cdr pair))
	 (loc (cons dest nil)))
	(dolist (place places)
		(rplacd loc place)
		(setf (gethash loc *func-table*)
		      (delete pair (gethash loc *func-table*) :test #'equal))
		(unless (gethash loc *func-table*)
			(setf (gethash place *prop-table*)
			      (delete dest (gethash place *prop-table*) 
				      :test #'equal))
			(unless (gethash place *prop-table*)
				(remhash place *prop-table*))
			(remhash loc *func-table*)))))

(defun unbind-fast (receipt)
  (unbind-internal (gethash receipt *unbind-table*))
  (remhash receipt *unbind-table*))

(defun unbind-from-deplist-internal (dest source-list
					&key
					(unbind-supersets t)
					(unbind-subsets t))
  (prog (unbind-receipts)
	(maphash #'(lambda (key value)
		     (if (equal (car key) dest)
			 (dolist (f value)
			     (let ((sub (subsetp (cdr f) source-list
						 :test #'equal))
				   (sup (subsetp source-list (cdr f)
						 :test #'equal)))
				  (when 
				   (or (and unbind-subsets sub)
				       (and unbind-supersets sup)
				       (and sub sup))
				   (pushnew (cons dest f) unbind-receipts))))))
		 *func-table*)
	(mapc #'unbind-internal unbind-receipts)))

(defun unbind-var (name reference expr &key
			(unbind-supersets t)
			(unbind-subsets t))
  (unbind-slot 'value (find-var name reference)
	       (var-adjust expr reference)
	       :unbind-supersets unbind-supersets
	       :unbind-subsets unbind-subsets))

(defun unbind-slot (slot object expr &key
			 (unbind-supersets t)
			 (unbind-subsets t))
  ;;  takes a slot name, object, and any expression (or list) containing
  ;;  var expressions.  The effect is to remove ANY bindings for the slot of
  ;;  the specified object which have the same set of dependees, and, 
  ;;  unless specified otherwise, remove bindings for proper supersets and 
  ;;  subsets.  The expression must be in "bind" form (var specifications).
  (unbind-from-deplist-internal `(,slot ',object) 
			      (mapcar #'cdr (get-dependees expr object))
			      :unbind-supersets unbind-supersets
			      :unbind-subsets unbind-subsets))

(defun propagate (dlist from)
  (dolist (d dlist)
	  (eval `(setf ,d ,(caar (gethash (cons d from) *func-table*))))))

;;; To be called as (do-propagate 'title foo-obj) or (do-propagate #?var)

(defun do-propagate (var-slot &optional (object nil object-p)
			      &aux desc)
  (unless object-p
    (setq object var-slot var-slot 'value))
  (setq desc `(,var-slot ',object))
  (propagate (gethash desc *prop-table*) desc))

(defun get-dependees (expression reference)
  (cond ((atom expression) nil)
	((slot-p expression)
	 (if (real-slot-p expression)
	     (if (already-meth expression)
		 `((no-need ,(second expression) ',(third expression)))
		 `((slot ,(second expression) ',(third expression))))
	     `((vslot ,(second expression) ',(third expression)))))
	((var-ex-p expression)
	 (list (process-var-ex (cadr expression) reference)))
	((var-ex-with-ref-p expression)
	 (list (process-var-ex (cadr expression) (fourth expression))))
	((var-p expression)
	 (list (process-var expression reference)))
	((non-local-var-p expression)
	 (list (process-non-local-var expression)))
	(t (append (get-dependees (car expression) reference)
		   (get-dependees (cdr expression) reference)))))

(defun already-meth (expression)
  (gethash (cons (cadr expression) (class-of (caddr expression))) 
           *class-meth-table*))

(defun slot-p (expr)
  (and (eql (car expr) 'var)
       (= (length expr) 3)))

(defun real-slot-p (expr)
  (slot-exists-p (third expr) (second expr)))

(defun var-ex-p (expr)
  (and (eql (car expr) 'var)
       (= (length expr) 2)
       (valid-var-expression (cadr expr))))

(defun var-ex-with-ref-p (expr)
  (and (eql (car expr) 'var)
       (= (length expr) 4)
       (valid-var-expression (cadr expr))))

(defun var-p (expr)
  (and (eql (car expr) 'var)
       (= (length expr) 2)))

(defun non-local-var-p (expr)
  (and (= (length expr) 4)
       (eql (car expr) 'var)
       (eql (third expr) :ref)))

(defun process-var-ex (expr ref)
  (if (eql (car expr) 'value) (setq expr (cadr expr)))
  (cond ((= (length expr) 2)
	 `(var value ',(find-var (eval (cadr expr)) ref)))
	((= (length expr) 3)
	 `(var value ',(eval expr)))
	(t (error "process-var-ex: unresolvable expression ~s" expr))))

(defun process-var (expr ref)
  `(var value ',(find-var (second expr) ref)))

(defun process-non-local-var (expr)
  `(var value ',(find-var (second expr) (fourth expr))))

(defun po-get-function (expr ref)
  (cond ((atom expr) expr)
	((slot-p expr) `(,(second expr) ',(third expr)))
	((var-ex-p expr) (cdr (process-var-ex (cadr expr) ref)))
	((var-ex-with-ref-p expr) 
	    (cdr (process-var-ex (cadr expr) (fourth expr))))
	((var-p expr) (cdr (process-var expr ref)))
	((non-local-var-p expr) (cdr (process-non-local-var expr)))
	(t (cons (po-get-function (car expr) ref)
		 (po-get-function (cdr expr) ref)))))


;;; (bind-function 'a f2 '(+ (slot a f1) (slot b f1)))

(defun replaces (deplist1 deplist2)
  (or (subsetp deplist1 deplist2 :test #'equal)
      (subsetp deplist2 deplist1 :test #'equal)))

(defun dump-prop ()
  (format t "~%METHOD TABLE~%")
  (dumphash *meth-table*)
  (format t "~%UNDO TABLE~%")
  (dumphash *unbind-table*)
  (format t "~%PROP TABLE~%")
  (dumphash *prop-table*)
  (format t "~%FUNC TABLE~%")
  (dumphash *func-table*)
  t)

(defun clear-prop ()
  (clrhash *unbind-table*)
  (clrhash *prop-table*)
  (clrhash *func-table*))

#{(setq *dummy-prop-var* (make-variable :value nil))

  
