;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/picasso/picasso-dict.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:07 $
;;;

(in-package "PT")

;;; Dictionary entries are of the form (package name . suffix) where
;;; package is an atom, and name and suffix are strings.  A name can be
;;; given in fully-qualified form, or in either the form (name . suffix) or
;;; (name) (with suffix being presumed nil).  In the latter case, the 
;;; dictionary is searched according to the package-search-list which

(defun setup-package-search-list ()
  (setq *package-search-list* (list (file-author "~") "picasso")))

;;;
;;;	Following function has been moved to window-method.cl to
;;;	avoid circular dependencies
;;;


(defun find-picasso-object-named (name-form)
  (let ((result (find-picasso-object-named-internal name-form)))
       (if (picasso-object-p result) 
	   result
	   (let ((new-result (eval result)))
		(if (picasso-object-p new-result)
		    (register name-form new-result)
		    (warn "Picasso Object Named ~S NOT FOUND" name-form))
		new-result))))

(defun find-picasso-object-named-internal (name-form)
  (case (name-type name-form)
	(:qualified (or (gethash name-form *global-dict*)
			(and (load (concatenate 'string *picasso-dict-path*
						   "/"
						   (car name-form)
						   "/"
						   (cadr name-form)
						   (if (cddr name-form)
						       "." "")
						   (if (cddr name-form)
						       (cddr name-form) ""))
				   :if-does-not-exist nil)
			     (gethash name-form *global-dict*))))

	(:singular 
	 (let ((qual-name (cons nil (list name-form)))
	       (result nil))
	      (dolist (p (package-search-list))
		      (rplaca qual-name p)
		      (if (setq result (gethash qual-name *global-dict*))
			  (return-from find-picasso-object-named-internal 
				       result))
		      (if (and 
			   (load (concatenate 'string *picasso-dict-path*
						 "/"
						 (car qual-name)
						 "/"
						 (cadr qual-name))
				 :if-does-not-exist nil)
			   (setq result (gethash qual-name *global-dict*)))
			  (return-from find-picasso-object-named-internal
				       result))))
	 nil)
	(:unqualified 
	 (let ((qual-name (cons nil name-form))
	       (result nil))
	      (dolist (p (package-search-list))
		      (rplaca qual-name p)
		      (if (setq result (gethash qual-name *global-dict*))
			  (return-from find-picasso-object-named-internal
				       result))
		      (if (and
			   (load (concatenate 'string *picasso-dict-path*
					 "/"
					 (car qual-name)
					 "/"
					 (cadr qual-name)
					 (if (cddr qual-name)
					     "." "")
                                         (if (cddr qual-name)
					     (cddr qual-name) ""))
				 :if-does-not-exist nil)
			   (setq result (gethash qual-name *global-dict*)))
			  (return-from find-picasso-object-named-internal
				       result))))
	 nil)
	(otherwise (error "Bad name passed to find-picasso-object: ~S"
			  name-form))))

(defun register (name-form object &optional (redefine t))
  (case (name-type name-form)
	(:qualified)
	(:unqualified (push (current-package) name-form))
	(:singular (setq name-form (cons (current-package) (list name-form))))
	(otherwise (error "Bad name passed to register: ~S" name-form)))
  (if (and (gethash name-form *global-dict*) (not redefine))
      nil
      (or (setf (gethash name-form *global-dict*) object) t)))


(defun name-type (name)
  (if (stringp name) 
      :singular
      (if (and (consp name) (stringp (car name)))
	  (if (or (stringp (cdr name)) (null (cdr name)))
	      :unqualified
	      (if (eq (name-type (cdr name)) :unqualified)
		  :qualified
		  :error))
	  :error)))

(defun include-package (name-list)
  (if (stringp name-list)
      (setf *package-search-list*
	    (cons name-list 
		  (delete name-list (package-search-list) :test #'equal)))
      (if (and (listp name-list) (every #'stringp name-list))
	  (setf *package-search-list*
		(append name-list
			(delete-if #'(lambda (x) (member x name-list 
							 :test #'equal))
				   (package-search-list))))
	  (error "Use-package.  Bad argument: ~S" name-list))))

(defun exclude-package (name-list)
  (if (stringp name-list)
      (setf *package-search-list*
	    (delete name-list (package-search-list) :test #'equal))
      (if (and (listp name-list) (every #'stringp name-list))
	  (setf *package-search-list*
		(delete-if #'(lambda (x) (member x name-list :test #'equal))
			   (package-search-list)))
	  (error "Unuse-package.  Bad argument: ~S" name-list))))

(defun deep-load (po-name &aux psl)
    (let* ((it (find-po-named po-name))
	   (cv (append (frames it) (dialogs it) (panels it) (forms it)))
	   (cn (mapcar #'(lambda (v) (value (lookup v it))) cv)))
	  (if (tool-p it)
	      (progn
	       (setq psl (package-search-list))
	       (include-package (psl it))
	       (mapc #'deep-load cn)
	       (setq *package-search-list* psl))
	      (mapc #'deep-load cn))))


