;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/label/default-label.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:03 $
;;;

(in-package "PT")

;; default null label

(defmethod label-init ((label t) self &aux atts sup)
  (setq atts (slot-value self 'label-attributes)
	sup (parent self))
  (unless (getf atts :foreground)
	  (setf (getf atts :foreground) "black"))
  (unless (getf atts :background)
	  (setf (getf atts :background) 
		(if (or (null (background sup))
			(tile-p (background sup)) 
			(image-p (get-image (background sup))))
		    "white"
		    (background sup))))
  (unless (getf atts :font)
	  (setf (getf atts :font) "8x13"))
  (setf (slot-value self 'label-x) 0
	(slot-value self 'label-y) 0)
  (setf (slot-value self 'intern-label-gc)
	(make-shared-gc (parent self) atts)))

(defmethod label-clear ((label t) self)
  (declare (ignore self))
  nil)

(defmethod label-repaint ((label t) self)
  (declare (ignore self))
  nil)

(defmethod label-notify-change ((label t) self &aux gc)
  (when (setq gc (slot-value self 'intern-label-gc))
	(alter-gc gc (label-attributes self)))
  nil)

(defmethod label-left-pad ((label t) self &rest args)
  (declare (ignore self args))
  0)

(defmethod label-top-pad ((label t) self &rest args)
  (declare (ignore self args))
  0)

(defmethod label-right-pad ((label t) self &rest args)
  (declare (ignore self args))
  0)

(defmethod label-bottom-pad ((label t) self &rest args)
  (declare (ignore self args))
  0)

(defmethod label-pad ((label t) self &rest args)
  (declare (ignore self args))
  (values 0 0 0 0))
