;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/gm/gm-support.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:51 $
;;;

(in-package "PT")

;;;
;;; Macros for geometry maagement and collections.
;;;

(defun repack-off (collection)
  "Turn repacking off for a collection."
  (setf (repack-flag collection) nil))

(defun repack-on (collection)
  "Turn repacking on for a collection and repack it."
  (unless (repack-flag collection)
	  (setf (slot-value collection 'repack-flag) t)
	  (repack collection)))

(defun post-force-repack (self)
  "Repack all collections of the children that need repacking."
  (mapc #'force-repack-needy-collections (children self)))

(defun post-repack (self)
  "Repack all collections of the children that need repacking."
  (mapc #'repack-needy-collections (children self)))

(defun do-repack (self)
  "Do a repack if we're both exposed and repacking is on."
  (if (and (repack-flag self) (exposed-p self))
       (let ((rc (repack-count self)))
	    (min-size self)
	    (unless (> (repack-count self) rc)
		    (gm-repack (gm self) self)
		    (post-repack self)
		    (setf (slot-value self 'repack-needed) nil)
		    (incf (repack-count self))))
       (setf (slot-value self 'repack-needed) t)))


(defun repack (self)
  "Do a repack if we need it."
  (if (repack-needed self) (do-repack self)))

(defun force-repack (self)
  "Force a repack no matter what!"
  (progn
    (min-size self)
    (gm-repack (gm self) self)
    (post-force-repack self)
    (setf (slot-value self 'repack-needed) nil)
    (incf (repack-count self))))


(defun just-repack (self)
  "Repack if needed but do'nt recalc min size."
  (if (and (repack-flag self) (exposed-p self))
       (progn
	(gm-repack (gm self) self)
	(post-repack self)
	(setf (repack-needed self) nil)
	(incf (repack-count self)))
       (setf (repack-needed self) t)))

