;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/borders/null-border.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:43 $
;;;

(in-package "PT")

;; no border

(defmethod border-init ((border t) self)
  (when (opaque-window-p self)
	(setf (xlib:drawable-border-width (res self)) 0)))

(defmethod border-resize ((border t) self)
  (declare (ignore self))
  nil)

(defmethod border-repaint ((border t) self)
  (declare (ignore self))
  nil)

(defmethod border-clear ((border t) self)
  (declare (ignore self))
  nil)

(defun valid-border-p (bspec)
  (or (integerp bspec) (and (consp bspec) (every #'integerp bspec))))

(defun quad-border-p (bspec)
  (and (consp bspec) (eq (length bspec) 4) (every #'integerp bspec)))
