(in-package "PT")

;;
;;	Creates class-event-map and registers all relevent events for class-of
;;	self and all inherited classes.  This process works from the top of
;;	the class inheritence tree to the bottom.  Hence, all local mappings
;;	will override inherited ones.
;;	NOTE:  if one event is mapped to two different handlers, it is 
;;	undetermined which one will get called.
;;
(defun make-class-event-map (self &aux cpl map class-name func)

  ;;  Compute class-precedence-list from self
  (setq cpl (cdddr (reverse (mapcar #'class-name 
				   (class-precedence-list (class-of self))))))

  ;;  Make hash-table if necessary
  (setq map (class-event-map self))
  (if (or (null map) (not (hash-table-p map)))
      ;;  create new map
      (setf (slot-value self 'class-event-map)
	    (setq map (make-hash-table :test #'equal))))

  ;;  Fill map in with entries starting at the top of the tree
  (dolist (class cpl)
	  (setq class-name (string class))
	  (dolist (mappings (gethash class *event-handler-table*))
		  (setq func (car mappings))
		  (setq func
			(if (atom func)
			    (symbol-function (read-from-string 
					      (concatenate 
					       'string class-name 
					       "-"
					       (string func))))
			    (symbol-function (read-from-string 
					      (concatenate 
					       'string (string (car func))
					       "-"
					       (string (cadr func)))))))
;;		  (format t "func: ~s~%" func)
		  (dolist (mapping (cadr mappings))
;;			  (format t "mapping: ~s~%" func)
			  (setq mapping (list (convert-event-type 
					       (first mapping))
					      (if (second mapping)
						  (apply 
						   #'xlib:make-state-mask 
						   (convert-state 
						    (second mapping)))
						  0)
					      (convert-detail (first mapping) 
							      (third mapping))))
			  (if (function-p func)
			      (setf (find-entry map mapping) func)))))

  ;;  Return class-event-map
  map)

;;;
;;;	Clear event-mappings for specified widget(s).
;;;	If widgets is null, clear all.
;;;
(defun clean-event-mapping (&optional widgets)
  (cond ((null widgets)
	 (clrhash *event-handler-table*))
	((atom widgets)
	 (remhash widgets *event-handler-table*))
	(t
	 (dolist (w widgets)
	 (remhash w *event-handler-table*)))))

;;;
;;;	Load event defaults in from file(s)
;;;

(defun load-event-maps (&key (erase-old t) &aux pic-loaded user-loaded)
  (if erase-old
      (setq *resource-database* nil))
  (when (probe-file *picasso-defaults-path*)
	(if (null *resource-database*)
	    (setq *resource-database* (xlib:make-resource-database)))
	(unwind-protect
	 (progn
	  (xlib:read-resources *resource-database* 
			       *picasso-defaults-path*)
	  (setq pic-loaded t))
	 (if (not pic-loaded)
	     (setq *resource-database* nil))))
  (when (probe-file *user-defaults-path*)
	(if (null *resource-database*)
	    (setq *resource-database* (xlib:make-resource-database)))
	(unwind-protect
	 (progn
	  (xlib:read-resources *resource-database* 
			       *user-defaults-path*)
	  (setq user-loaded t))
	 (if (not user-loaded)
	     (if pic-loaded 
		 (xlib:read-resources *resource-database* 
				      *picasso-defaults-path*)
		 (setq *resource-database* nil)))))
  (when (or pic-loaded user-loaded) 
	(xlib:map-resource *resource-database* #'register-loaded-event)
	t))

#+allegro
(defun register-loaded-event (event func &aux class-name hdata mapping temp)
  (when (not (eq (length event) 4))
	(return-from register-loaded-event))
  (setq func (read-from-string func nil))
  (setq class-name (read-from-string (car event)))
  (setq hdata (gethash class-name *event-handler-table*))
  (setq mapping (list (convert-event-type 
		       (excl::make-keyword
			(parse-from-database (second event))))
		      (parse-from-database (third event)) 
		      (parse-from-database2 (fourth event))))
  (setq mapping (parse-event-spec mapping))
  (when mapping
	(if (setq temp (member func hdata :test #'ev-hand-test)) 
	    (push mapping (cadar temp))
	    (setf (gethash class-name *event-handler-table*) 
		  (push (list func (list mapping)) hdata)))))

#+lucid
(defun register-loaded-event (event func &aux class-name hdata mapping temp)
  (when (not (eq (length event) 4))
	(return-from register-loaded-event))
  (setq class-name (car event))
  (setq hdata (gethash class-name *event-handler-table*))
  (setq mapping (list (convert-event-type 
		       (parse-from-database (second event)))
		      (parse-from-database (third event)) 
		      (parse-from-database (fourth event))))
  (setq mapping (parse-event-spec mapping))
  (when mapping
	(if (setq temp (member func hdata :test #'ev-hand-test)) 
	    (push mapping (cadar temp))
	    (setf (gethash class-name *event-handler-table*) 
		  (push (list func (list mapping)) hdata)))))

#+allegro
(defun parse-from-database (str)
  (if (string= str "*")
      nil
      (read-from-string str nil)))
#+lucid
(defun parse-from-database (str)
  (if (string= str "*")
      nil
      str))

#+allegro
(defun parse-from-database2 (str &aux s)
  (if (string= str "*")
      nil
      (if (setq s (character str))
	  s
	  (read-from-string str))))
