;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: smoot $
;;; $Source: /pic2/picasso/toolkit/base/RCS/collection-gadget.cl,v $
;;; $Revision: 1.4 $
;;; $Date: 1991/11/26 22:55:21 $
;;;

(in-package "PT")

;;;
;;; gadget class
;;;
(defclass collection-gadget (gadget) 
  ((name :initform "A Collection") 
   (value :type t :initform "Collection" 
	  ;; :reader value
	  )
   (gm :type atom :initarg :gm  :initform 'null-gm :accessor gm)
   (gc-spec :initform nil)
   (children :type t :initarg :children  :initform nil :accessor children)
   (label-type :initform nil)
   (repack-flag 
    :type atom 
    :initarg :repack-flag  
    :initform nil 
    :reader repack-flag)
   (repack-needed 
    :type atom 
    :initarg :repack-needed  
    :initform nil 
    :accessor repack-needed)
   ;;; conform is one of :dont-conform :grow-only and :grow-shrink
   (conform 
    :type atom 
    :initarg :conform  
    :initform :grow-shrink 
    :reader conform)
   (repack-count :type integer :initform 0 :accessor repack-count)
   (min-size :type list :initform nil :accessor min-size)
   (gm-data :type t :initform nil :accessor gm-data)))

(defun make-collection-gadget (&rest keys)
  (apply #'make-instance 'collection-gadget :allow-other-keys t keys))

(defun force-repack-needy-collections (self)
  (when (collection-p self)
	(force-repack self)
	(post-force-repack self)))

(defun repack-needy-collections (self)
  (when (collection-p self)
	(repack self)
	(post-repack self)))

(defmethod (setf gm) (value (self collection-gadget))
  (let ((oldgm (gm self)))
       (setf (slot-value self 'gm) value)
       (gm-changed value self oldgm)))

(defmethod (setf gm-data) (value (self collection-gadget))
  (let ((old-data (gm-data self)))
       (setf (slot-value self 'gm-data) value)
       (gm-data-changed (gm self) self old-data)))


(defmethod (setf repaint-flag) (value (self collection-gadget))
  (when (or (not value) (not (parent self)) (repaint-flag (parent self)))
	(setf (slot-value self 'repaint-flag) value)
	(dolist (ch (children self))
		(setf (repaint-flag ch) value))))

(defmethod value ((self collection-gadget)
		  &key 
		  &allow-other-keys)
  (slot-value self 'value))

(defmethod (setf value) (value (self collection-gadget))
  (setf (slot-value self 'value) value))

(defmethod (setf repack-flag) (value (self collection-gadget))
  (unless (eql value (repack-flag self))
	  (setf (slot-value self 'repack-flag) value)
	  (if (and value (repack-needed self))
	      (repack self))))

(defmethod (setf conform) (value (self collection-gadget))
  (if (member value '(:dont-conform :grow-only :grow-shrink))
      (progn
       (setf (slot-value self 'conform) value)
       (resize-hint-changed self))
      (warn "collection-gadget.(setf conform):  Illegal value, ignored~%")))

(defmethod (setf min-size) (value (self collection-gadget))
  (if (null value) 
      (let ((prnt (parent self)))
	   (setf (slot-value self 'min-size) nil)
	   (if (and (window-p prnt) (not (root-window-p prnt)))
	       (setf (min-size prnt) nil)))
      (case (conform self)
	    (:dont-conform
	     (setf (slot-value self 'min-size) value))
	    (:grow-shrink
	     (let ((bs (static-base-size self))
		   (newbs nil))
		  (setf (slot-value self 'min-size) value)
		  (setf newbs (static-base-size self))
		  (unless (equal bs newbs)
			  (resize-hint-changed self))))
	    (:grow-only
	     (let ((bs (static-base-size self))
		   (newbs nil))
		  (setf (slot-value self 'min-size) 
			(mapcar #'max (static-min-size self) value))
		  (setf newbs (static-base-size self))
		  (unless (equal bs newbs)
			  (resize-hint-changed self))))
	    (otherwise 
	     (error "collection-gadget.(setf min-size):  illegal conform~%")))))

(defun geom-spec-changed (child)
  "Handle a change in the geom-spec of a child"
  (let ((prnt (parent child)))
       (when prnt
	     (setf (min-size prnt) nil)
	     (if (and (repack-flag prnt) (exposed-p prnt))
		 (gm-spec-changed (gm prnt) prnt child)
		 (setf (repack-needed prnt) t)))))

(defun resize-hint-changed (child)
  "handle a change in resize-hint"
  (let ((prnt (parent child)))
       (when prnt 
	     (setf (min-size prnt) nil)
	     (if (and (repack-flag prnt) (exposed-p prnt))
		 (gm-resize-hint-changed (gm prnt) prnt child)
		 (setf (repack-needed prnt) t)))))

(defun status-changed (child)
  "handle a change in status"
  (let ((prnt (parent child)))
       (when prnt 
	     (setf (min-size prnt) nil)
	     (if (and (repack-flag prnt) (exposed-p prnt))
		 (gm-status-changed (gm prnt) prnt child)
		 (setf (repack-needed prnt) t)))))

(defmethod min-size ((self collection-gadget))
  (unless (slot-value self 'min-size)
	  (calculate-min-size self))
  (or (slot-value self 'min-size) '(0 0)))

(defmethod static-min-size ((self collection-gadget))
  (cond ((slot-value self 'min-size))
	('(0 0))))

(defun make-collection (&rest args)
  (apply #'make-collection-gadget args))

(defmethod new-instance ((self collection-gadget)
			 &key
			 &allow-other-keys)
  (setf (slot-value self 'children) nil)
  (call-next-method)
  (initialize-gm self)
  self)

;;;
;;; Methods that effect a cg's status
;;;

(defmethod do-attach ((self collection-gadget))
  (repack-off self)
  (setf (slot-value self 'repaint-flag) nil)
  (call-next-method)
  (when (attached-p self)
	(mapc #'(lambda (ch) (if (not (concealed-p ch)) (do-attach ch)))
	      (children self))
	(mapc #'(lambda (ch) (if (attach-when-possible ch) (do-attach ch)))
	      (concealed-of (children self)))
	(if (exposed-p self)
	    (mapc #'(lambda (ch) (make-uninvisible ch)) (children self))))
  (repack-on self)
  (setf (slot-value self 'repaint-flag) t))

(defmethod do-detach ((self collection-gadget))
  (repack-off self)
  (setf (slot-value self 'repaint-flag) nil)
  (mapc #'detach (children self))
  (call-next-method)
  (repack-on self)
  (setf (slot-value self 'repaint-flag) t))

(defmethod do-pend ((self collection-gadget))
  (if (widget-p self)
      (mapc #'(lambda (ch) (make-invisible ch :x-unmap nil))
	    (managed-of (children self)))
      (mapc #'make-invisible (managed-of (children self))))
  (call-next-method))

(defmethod do-unpend ((self collection-gadget))
  (call-next-method)
  (if (exposed-p self)
      (mapc #'make-uninvisible (invisible-of (children self)))))

(defmethod do-make-invisible ((self collection-gadget)
			      &key (x-unmap t))
  (if (exposed-p self)
      (progn
       (repack-off self)
       (if (and x-unmap (not (widget-p self)))
	   (mapc #'make-invisible (managed-of (children self)))
	   (mapc #'(lambda (ch) (make-invisible ch :x-unmap nil)) 
		 (managed-of (children self))))
       (call-next-method)
       (repack-on self))
      (call-next-method)))

(defmethod do-make-uninvisible ((self collection-gadget)
				&key 
				&allow-other-keys)
  (repack-off self)
  (call-next-method)
  (mapc #'make-uninvisible (invisible-of (children self)))
  (repack-on self))

(defmethod do-expose ((self collection-gadget)
		      &key 
		      &allow-other-keys)
  (if (and (exposed-p (parent self)) (attached-p self))
      (let ((old-status (status self)))
	   (repack-off self)
	   (setf (slot-value self 'status) :exposed)
	   (mapc #'make-uninvisible (pending-of (children self)))
	   (repack-on self)
	   (if (eq old-status :concealed)
	       (status-changed self)))
      (setf (status self) :exposed)))

(defmethod do-conceal ((self collection-gadget)
		       &key 
		       &allow-other-keys)
  (repack-off self)
  (if (widget-p self)
      (mapc #'(lambda (ch) (make-invisible ch :x-unmap nil))
	    (managed-of (children self)))
      (mapc #'make-invisible (managed-of (children self))))
  (call-next-method)
  (repack-on self))

;;;
;;; CG operations
;;;

(defmethod (setf dimmed) (value (self collection-gadget))
  (call-next-method)
  (mapc #'(lambda (ch) (setf (dimmed ch) value)) (children self)))

(defmethod (setf inverted) (value (self collection-gadget))
  (call-next-method)
  (mapc #'(lambda (ch) (setf (inverted ch) value)) (children self)))

(defmethod clear ((self collection-gadget)
		  &key 
		  &allow-other-keys)
  ;; (declare (optimize (speed 3) (safety 0)))
  (when (exposed-p self)
	(call-next-method)
	(mapc #'clear (exposed-gadgets-of (children self)))))

(defmethod clear-region ((self collection-gadget) x y w h)
  ;; (declare (integer x y w h) (optimize (speed 3) (safety 0)))
  (declare (integer x y w h))
  (when (exposed-p self)
	;; Let superclass do the actual clearing of myself
	(call-next-method)
	;; Now clear the children in order.
	(let ((region-max-x (+ x w))
	      (region-max-y (+ y h))
	      (min-x 0)
	      (min-y 0)
	      (max-x 0)
	      (max-y 0)
	      (ch-min-x 0)
	      (ch-min-y 0)
	      (ch-max-x 0)
	      (ch-max-y 0))
	  (declare (integer region-max-x region-max-y
			    min-x min-y max-x max-y
			    ch-min-x ch-min-y ch-max-x ch-max-y))
	  (dolist (ch (exposed-gadgets-of (children self)))
		  (setq ch-min-x (x-offset ch)
			ch-min-y (y-offset ch))
		  (setq ch-max-x (+ ch-min-x (width ch))
			ch-max-y (+ ch-min-y (height ch)))
		  (setq min-x (max ch-min-x x)
			min-y (max ch-min-y y)
			max-x (min ch-max-x region-max-x)
			max-y (min ch-max-y region-max-y))
		  (if (and (> max-x min-x) (> max-y min-y))
		      (clear-region ch
				    (- min-x ch-min-x)
				    (- min-y ch-min-y)
				    (- max-x min-x)
				    (- max-y min-y)))))))

(defmethod do-repaint ((self collection-gadget)
		       &key (clear t)
		       &allow-other-keys)
  (dolist (ch (children self))
	  (when (and (exposed-p ch) (repaint-flag ch))
		(if (not (opaque-window-p ch))
		    (repaint ch))
		(border-repaint (border-type ch) ch)
		(label-repaint (label-type ch) ch))))

(defmethod do-repaint-region ((self collection-gadget) x y w h
			      &key (clear t) &allow-other-keys)
  (declare (integer x y w h))
  (let ((region-max-x (+ x w))
	(region-max-y (+ y h))
	(min-x 0)
	(min-y 0)
	(max-x 0)
	(max-y 0)
	(ch-min-x 0)
	(ch-min-y 0)
	(ch-max-x 0)
	(ch-max-y 0))
    (declare (integer region-max-x region-max-y
		      min-x min-y max-x max-y
		      ch-min-x ch-min-y ch-max-x ch-max-y))
    (dolist (ch (exposed-gadgets-of (children self)))
	    (setq ch-min-x (+ (repaint-x ch))
		  ch-min-y (+ (repaint-y ch)))
	    (setq ch-max-x (+ ch-min-x (width ch))
		  ch-max-y (+ ch-min-y (height ch)))
	    (setq min-x (max ch-min-x x)
		  min-y (max ch-min-y y)
		  max-x (min ch-max-x region-max-x)
		  max-y (min ch-max-y region-max-y))
	    (if (and (>= max-x min-x) (>= max-y min-y))
		(progn
		  (repaint-region ch min-x min-y
				  (- max-x min-x)
				  (- max-y min-y)
				  :clear clear)
		  (border-repaint (border-type ch) ch)
		  (label-repaint (label-type ch) ch))))))

(defmethod resize-window-handler ((self collection-gadget))
  (just-repack self))

(defmethod configure ((self collection-gadget)
		      &key 
		      (x-offset (slot-value self 'x-offset))
		      (y-offset (slot-value self 'y-offset))
		      (collection-repack nil)
		      &allow-other-keys)
  (let ((x-offset-p (not (eql x-offset (slot-value self 'x-offset))))
        (y-offset-p (not (eql y-offset (slot-value self 'y-offset)))))
       (unless collection-repack (call-next-method))
       (if (and (not (x-window-p self)) 
		(or x-offset-p y-offset-p collection-repack))
	   (mapc #'(lambda (win)
			   (cond ((x-window-p win) (configure win))
				 ((collection-p win)
				  (configure win :collection-repack t))))
		 (children self)))))

(defmethod base-width ((self collection-gadget))
  (case (conform self)
	(:dont-conform (slot-value self 'base-width))
	(otherwise 
	 (max (slot-value self 'base-width) (first (min-size self))))))

(defmethod base-height ((self collection-gadget))
  (case (conform self)
	(:dont-conform (slot-value self 'base-height))
	(otherwise 
	 (max (slot-value self 'base-height) (second (min-size self))))))

(defmethod static-base-width ((self collection-gadget))
  (case (conform self)
	(:dont-conform (slot-value self 'base-width))
	(otherwise 
	 (max (slot-value self 'base-width) 
	      (or (first (slot-value self 'min-size)) 0)))))

(defmethod static-base-height ((self collection-gadget))
  (case (conform self)
	(:dont-conform (slot-value self 'base-height))
	(otherwise 
	 (max (slot-value self 'base-height) 
	      (or (second (slot-value self 'min-size)) 0)))))

(defmethod base-size ((self collection-gadget))
  (list (base-width self) (base-height self)))

(defmethod static-base-size ((self collection-gadget))
  (list (static-base-width self) (static-base-height self)))

(defmethod resize-hint ((self collection-gadget))
  (nconc (base-size self) (cddr (call-next-method))))

;;;
;;;	WINDOW methods that had to be put here to avoid circular dependencies
;;;

(defmethod new-instance :after ((self window) 
				&key 
				(children nil) 
				&allow-other-keys
				&aux sup new-child args) 
  (if (setq sup (parent self))
      (add-child sup self))
  (dolist (ch children) 
	  (if (and (symbolp (car ch)) (eql (length ch) 2) (listp (cadr ch)))
	      (progn
	       (setq args (mapcar #'eval (cdadr ch)))
	       (setf (getf args :parent) self)
	       (setq new-child (apply (symbol-function (caadr ch)) args))
	       (add-var (car ch) #!po@self new-child)
	       (if (typep new-child 'window)
		   (setf (name new-child) (string (car ch)))))
	      (progn
	       (setq args (mapcar #'eval (cdr ch)))
	       (setf (getf args :parent) self)
	       (apply (symbol-function (car ch)) args)))))
