(in-package "PT")

(defmacro button-p (self)
  "determine if this object is a button"
  `(typep ,self 'button))

(defmacro color-p (self)
  "determine if this object is a color"
  `(typep ,self 'color))

(defmacro colormap-p (self)
  "determine if this object is a color"
  `(typep ,self 'colormap))

(defmacro cursor-p (self)
  "determine if this object is a cursor"
  `(typep ,self 'cursor))

(defmacro display-p (self)
  "determine if this object is an display"
  `(typep ,self 'display))

(defmacro screen-p (self)
  "determine if this object is an display"
  `(typep ,self 'screen))

(defmacro font-p (self)
  "determine if this object is a font"
  `(typep ,self 'font))

(defmacro locator-p (self)
  "determine if this object is of the class"
  `(typep ,self 'locator))

(defmacro opaque-window-p (self)
  "determine if this object is an opaque-window"
  `(typep ,self 'opaque-window))

(defmacro image-p (self)
  "determine if this object is a pixmap"
  `(typep ,self 'image))

(defmacro tile-p (self)
  "determine if this object is a pixmap"
  `(typep ,self 'tile))

(defmacro root-window-p (self)
  "determine if this object is an root-window"
  `(typep ,self 'root-window))

(defmacro text-window-p (self)
  "determine if this object is a text-window"
  `(typep ,self 'text-window))

(defmacro title-bar-p (self)
  "determine if this object is a title-bar"
  `(typep ,self 'title-bar))

(defmacro tool-window-p (self)
  "determine if this object is a tool-window"
  `(typep ,self 'tool-window))

(defmacro transparent-window-p (self)
  "determine if this object is a transparent-window"
  `(typep ,self 'transparent-window))

(defmacro x-window-p (self)
  "determine if this object is a x-window"
  `(typep ,self 'x-window))

(defmacro gadget-p (self)
  "determine if this object is a gadget"
  `(typep ,self 'gadget))

(defmacro null-gadget-p (self)
  "determine if this object is a null-gadget"
  `(typep ,self 'null-gadget))

(defmacro round-button-gadget-p (self)
  "determine if this object is a round-button-gadget"
  `(typep ,self 'round-button-gadget))

(defmacro text-gadget-p (self)
  "determine if this object is a text-gadget"
  `(typep ,self 'text-gadget))

(defmacro window-p (self)
  "determine if this object is a window"
  `(typep ,self 'window))

(defmacro widget-p (self)
  "determine if this object is a bitmap"
  `(typep ,self 'widget))

(defmacro collection-p (self)
  "determine if this object is a collection"
  `(typep ,self 'collection-gadget))

(defmacro bordered-p (win)
  "Tests if a window has a border"
  `(not (null (slot-value ,win 'border-type))))

(defmacro labeled-p (win)
  "Tests if a window has a label"
  `(not (null (slot-value ,win 'label))))

(defmacro variable-holder-p (self)
  "determine if this object is a variable holder"
  `(typep ,self 'variable-holder))

(defmacro picasso-object-p (self)
  "determine if this object is a picasso-object"
  `(typep ,self 'picasso-object))

(defmacro variable-p (self)
  "determine if this object is a variable"
  `(typep ,self 'variable))

(defmacro invalid-p (thing)
  `(eq ,thing :invalid))

(defmacro lazy-slot-p (slot class-name)
  `(member ,slot (get ,class-name :lazy)))

(defmacro unlazy-slot-p (slot class-name)
  `(member ,slot (get ,class-name :unlazy)))

(defmacro icon-p (self)
  "determine if this object is an icon"
  `(typep ,self 'icon))

(defmacro click-button-p (self)
  `(typep ,self 'click-button))

(defmacro gray-button-p (self)
  `(typep ,self 'gray-button))

(defmacro gray-pop-button-p (pb)
  `(typep ,pb 'gray-pop-button))

(defmacro pop-button-p (pb)
  `(typep ,pb 'pop-button))

(defmacro dialog-p (obj)
  `(typep ,obj 'dialog))

(defmacro form-p (obj)
  `(typep ,obj 'form))

(defmacro panel-p (obj)
  `(typep ,obj 'panel))

(defmacro tool-p (obj)
  `(typep ,obj 'tool))

(defmacro frame-p (self)
  `(typep ,self 'frame))

(defmacro top-level-po-p (self)
  `(typep ,self 'top-level-po))

(defmacro top-level-p (self)
  `(or (top-level-po-p ,self) (root-window-p ,self)))

(defmacro callable-po-p (self)
  `(typep ,self 'callable-po))

(defmacro 2d-shape-p (self)
  `(typep ,self '2d-shape))

(defmacro annot-dl-p (self)
  `(typep ,self 'annot-dl))

(defmacro box-p (self)
  `(typep ,self 'box))

(defmacro display-list-p (self)
  `(typep ,self 'display-list))

(defmacro plot-widget-p (pb)
  `(typep ,pb 'plot-widget))

(defmacro polygon-p (self)
  `(typep ,self 'polygon))

(defmacro segment-dl-p (self)
  `(typep ,self 'segment-dl))

(defmacro shape-p (self)
  `(typep ,self 'shape))

(defmacro menu-button-p (self)
  `(typep ,self 'menu-button))

(defmacro menu-bar-p (self)
  `(typep ,self 'menu-bar))

(defmacro menu-entry-p (self)
  `(typep ,self 'menu-entry))

(defmacro menu-item-p (self)
  `(typep ,self 'menu-item))

(defmacro menu-p (self)
  `(typep ,self 'menu))

(defmacro arb-widget-p (self)
  "determine if this object is a widget"
  `(typep ,self 'widget))

(defun null-widget-p (self)
  "determine if this object is a null-widget"
  (typep self 'null-widget))

(defmacro indicator-widget-p (win)
  `(typep ,win 'indicator-widget))

(defmacro indicator-p (win)
  `(typep ,win 'indicator))

(defmacro meter-slider-p (win)
  `(typep ,win 'meter-slider))

(defmacro qual-widget-p (pb)
  `(typep ,pb 'qual-widget))

(defmacro browse-widget-p (self)
  `(typep ,self 'browse-widget))

(defmacro matrix-field-p (self)
  `(typep ,self 'matrix-field))

(defmacro sound-widget-p (self)
  `(typep ,self 'sound-widget))

