(in-package "PT")

(defstruct 2d-point x y)

(defstruct (fg-annot (:conc-name fga-))
  id                    ;; Unique id of annotation.
  text                  ;; Text to display inside.
  vertex-id             ;; Id of vertex which is justification point.
  (horiz-just :center)  ;; One of :left :center :right
  (vert-just :center)   ;; One of :top :center :bottom
  width                 ;; Width, in world coords, of annotation
  height                ;; Height, in world coords, of annotation
  ;; -------------------  CACHED VALUES ----------------------------
  objects               ;; A list of objects that contain this annotation.
  font-widths           ;; List with width of string in the various fonts.
  font-heights          ;; List with height of string in the various fonts.
  font-ascents          ;; List with ascent of string in the various fonts.
  font-descents         ;; List with descents of string in the various fonts.
  sel-font-widths       ;; List with width of string in the selected fonts.
  sel-font-heights      ;; List with height of string in the selected fonts.
  sel-font-ascents      ;; List with ascent of string in the selected fonts.
  sel-font-descents     ;; List with descents of string in the selected fonts.
 font-idx              ;; Last font index used to draw.
  vertex                ;; Index of vertex in vertex-table.
  )

(defstruct (fg-symbol (:conc-name fgs-))
  id                    ;; Unique id of symbol.
  symbol-type-id        ;; Id of symbol type.
  vertex-id             ;; Id of vertex which is justification point.
  (horiz-just :center)  ;; One of :left :center :right
  (vert-just :center)   ;; One of :top :center :bottom
  ;; -------------------  CACHED VALUES ----------------------------
  objects               ;; A list of objects that contain this symbol.
  vertex                ;; Index of vertex in vertex-table.
  symbol-type           ;; Index of symbol type in symbol-type-table.
  bitmap-idx            ;; Last bitmap index used to draw.
  )

(defstruct (fg-symbol-type (:conc-name fgst-))
  id                    ;; Unique id of symbol type.
  bitmaps               ;; List of bitmaps to try, best first.
  widths                ;; List of the widths of the bitmaps
  heights               ;; List of the heights of the bitmaps
  width                 ;; Width, in world coords, of symbol
  height                ;; Height, in world coords, of symbol
  )

(defstruct (fg-line (:conc-name fgl-))
  id                    ;; Unique id of line.
  start-vertex-id       ;; Id's of start and end vertices of line.
  end-vertex-id
  ;; -------------------  CACHED VALUES ----------------------------
  objects               ;; A list of objects that contain this line.
  start-vertex          ;; Indices of start and end of line in vertex-table.
  end-vertex
  )

(defstruct (fg-object (:conc-name fgo-))
  id                    ;; Unique id of object.
  line-ids              ;; List of ids of lines
  annot-ids             ;; List of ids of annotations
  symbol-ids            ;; List of ids of symbols
  (visible t)           ;; Is this object visible?
  selected              ;; Is this object selected?
  (selectable t)        ;; Is this object selectable?
  (line-width 0)        ;; Line width to use on object lines.
  (color "white")       ;; Color use on object lines/annotations/symbols.
  ;; -------------------  CACHED VALUES ----------------------------
  lines                 ;; List of the indexes of the lines
  annots                ;; List of the indexes of the annotations
  symbols               ;; List of the indexes of the symbols
  extent                ;; List of xmin ymin xmax ymax of object
  )


(defstruct sound
  (length 0 :type fixnum)
  (sample-rate 0 :type fixnum)
  (bytes-per-unit 0 :type fixnum)
  (channels 1 :type fixnum)
  (samples-per-unit 1 :type fixnum)
  (data nil :type (vector xlib::card8 *)))   
;; nil is a dummy value
