;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; This file contains code for miscelaneous functions in FMTOOL.
;;;
;;; $Author$
;;; $Source$
;;; $Revision$
;;; $Date$
;;;

(in-package "PT")

;; ==============================================================
;;
;; Function to support the set-properties dialog.
;;
(defun get-fgo-colors (viewer objs)
  (mapcar #'(lambda (x) (fgo-color (find-fgo viewer x))) objs))

(defun get-fgo-visibilities (viewer objs)
  (mapcar #'(lambda (x) (fgo-visible (find-fgo viewer x))) objs))

(defun get-fgo-widths (viewer objs)
  (mapcar #'(lambda (x) (fgo-line-width (find-fgo viewer x))) objs))

(defun set-props (objs viewer visible color width)
  (set-fgo-visible viewer objs visible)
  (set-fgo-color viewer objs color)
  (set-fgo-line-width viewer objs width)
  (repaint viewer))

(defun restore-props (objs viewer visiblities colors widths)
  (mapc #'(lambda (x y) (set-fgo-visible viewer x y)) objs visiblities)
  (mapc #'(lambda (x y) (set-fgo-color viewer x y)) objs colors)
  (mapc #'(lambda (x y) (set-fgo-line-width viewer x y)) objs widths))

(defun do-join (var rv)
  (cond ((eq (car rv) :add)
         (setf (value var) (union (value var) (second rv))))
        ((eq (car rv) :remove)
         (setf (value var) (set-difference (value var) (second rv))))
        ((eq (car rv) :restrict)
         (setf (value var) (intersection (value var) (second rv))))
        ((eq (car rv) :replace)
         (setf (value var) (second rv)))))

(defun next-key (key keys)
  (cadr (member key keys :test #'equalp)))

