;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: picasso $
;;; $Source: RCS/scrolling-text-widget.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 90/07/22 14:33:19 $
;;;

;;;
;;; TODO:  unbind and rebind if buffer of text-widget changes.
;;; May want to save receipts to make this go quick.
;;;

(in-package 'pt  :nicknames '(picasso-toolkit) :use '(lisp excl pcl))

;;;
;;; define the scroll-bar field class
;;;
(defclass scrolling-text-widget (collection-widget)
  ((scroll-bar :initarg :scroll-bar :initform nil :accessor scroll-bar)
   (text-widget :initarg :text-widget :initform nil :accessor text-widget)
   (gm :initform 'packed-gm)
   (conform :initform :grow-only)))

(defun make-scrolling-text-widget (&rest keys)
  (apply #'make-instance 'scrolling-text-widget :allow-other-keys t keys))

;;;
;;; initialize a scrolling-text-widget instance
;;;

(defmethod (setf value) (value (self scrolling-text-widget))
  (if (text-widget self)
      (setf (value (text-widget self)) value)))

(defmethod value ((self scrolling-text-widget))
  (value (text-widget self)))

(defmethod new-instance ((self scrolling-text-widget)
			 &key
			 (rows 24)
			 (columns 80)
			 (font (make-font))
			 (prev-page-func '(sb-prev-page self))
			 (next-page-func '(sb-next-page self))
			 (prev-line-func '(sb-prev-line self))
			 (next-line-func '(sb-next-line self))
			 (move-func `(stw-sb-move self ',self event))
			 &allow-other-keys
			 &aux sb tw)
  
  (call-next-method)
  (setq sb (make-scroll-bar :parent self
			    :orientation :vertical
			    :geom-spec :left
			    :border-width 0
			    :lower-limit 0
			    :upper-limit 1
			    :slider-location 0
			    :slider-size 1
			    :pause-seconds 0.0
			    :prev-page-func prev-page-func
			    :next-page-func next-page-func
			    :prev-line-func prev-line-func 
			    :next-line-func next-line-func 
			    :moved-func move-func))

  (setq tw (make-text-widget :parent self
			     :geom-spec :fill
			     :rows rows
			     :columns columns 
			     :font font))
  
  (setf (slot-value self 'text-widget) tw)
  (setf (slot-value self 'scroll-bar) sb)
  
  ;; Set up the bindings between the scroll-bars and the text widget
  (setf (repaint-flag tw) nil)
  (setf (repaint-flag sb) nil)
  (bind-slot 'upper-limit sb `(var rows ,(buffer tw)))
  (bind-slot 'slider-location sb `(var top-of-screen ,tw))
  (bind-slot 'slider-size sb `(var rows ,tw))
  (bind-slot 'top-of-screen tw `(var slider-location ,sb))
  (setf (repaint-flag tw) t)
  (setf (repaint-flag sb) t)
  self)

(defun stw-sb-move (sb stw ev)
  (let* ((tw (text-widget stw))
	 (cm (cursor-mode tw)))
	(setf (cursor-mode tw) nil)
	(setf (fast-scroll tw) t)
	(drag-scroll-bar sb #'stw-sb-dynamic-move ev)
	(setf (fast-scroll tw) nil)
	(setf (cursor-mode tw) cm)))

(defun stw-sb-dynamic-move (sb ev)
  (declare (ignore ev))
  (let* ((stw (parent sb))
	 (tw (text-widget stw))
	 (old-pos (top-of-screen tw))
	 (new-pos (round (slider-location sb))))
	(if (> old-pos new-pos)
	    (tbg-scroll-up tw (- old-pos new-pos))
	    (tbg-scroll-down tw (- new-pos old-pos))))
  (xlib:display-force-output (res (current-display))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Methods used by applications programmers:
;;;

(defmethod load-file ((self scrolling-text-widget) file &key (count -1))
  (load-file (text-widget self) file) :count count)

(defmethod put-file ((self scrolling-text-widget) file &key (count -1))
  (put-file (text-widget self) file) :count count)

(defmethod append-to-file ((self scrolling-text-widget) file)
  (append-to-file (text-widget self) file))

(defmethod save-file ((self scrolling-text-widget) file)
  (save-file (text-widget self) file))

(defmethod (setf value) (value (self scrolling-text-widget))
  (if (text-widget self)
      (setf (value (text-widget self)) value)))

(defmethod value ((self scrolling-text-widget))
  (value (text-widget self)))

(defmethod rows ((self scrolling-text-widget))
  (rows (text-widget self)))

(defmethod (setf rows) (new-rows (self scrolling-text-widget))
  (setf (rows (text-widget self)) new-rows)
  (rows (text-widget self)))

(defmethod columns ((self scrolling-text-widget))
  (columns (text-widget self)))

(defmethod (setf columns) (new-columns (self scrolling-text-widget))
  (setf (columns (text-widget self)) new-columns)
  (columns (text-widget self))) ; possibly different

(defmethod font ((self scrolling-text-widget))
  (font (text-widget self)))

(defmethod (setf font) (new-font (self scrolling-text-widget))
  (setf (font (text-widget self)) new-font)
  (font (text-widget self))) ; possibly different

(defmethod (setf top-of-screen) (value (self scrolling-text-widget))
  (setf (slot-value self 'top-of-screen) (round value)))

(defmethod (setf left-of-screen) (value (self scrolling-text-widget))
  (setf (slot-value self 'left-of-screen) (round value)))

